/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.cache;

import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.sellcom.core.Contract;
import org.sellcom.core.util.cache.Cache;
import org.sellcom.core.util.cache.SoftCache;

public class ConcurrentSoftCache<K, V>
implements Cache<K, V> {
    private final Cache<K, V> entries;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public ConcurrentSoftCache() {
        this.entries = new SoftCache();
    }

    public ConcurrentSoftCache(Function<K, V> mappingFunction) {
        Contract.checkArgument(mappingFunction != null, "Mapping function must not be null", new Object[0]);
        this.entries = new SoftCache<K, V>(mappingFunction);
    }

    public boolean equals(Object other) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.equals(other);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void evict(K key) {
        try {
            this.lock.writeLock().lock();
            this.entries.evict(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void evict(K key, V value) {
        try {
            this.lock.writeLock().lock();
            this.entries.evict(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void evictAll() {
        try {
            this.lock.writeLock().lock();
            this.entries.evictAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        try {
            this.lock.readLock().lock();
            this.entries.forEach(action);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Optional<V> get(K key) {
        try {
            this.lock.readLock().lock();
            Optional<V> optional = this.entries.get(key);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getOrDefault(K key, V defaultValue) {
        try {
            this.lock.readLock().lock();
            V v = this.entries.getOrDefault(key, defaultValue);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int hashCode() {
        try {
            this.lock.readLock().lock();
            int n = this.entries.hashCode();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.lock.readLock().lock();
            boolean bl = this.entries.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void put(K key, V value) {
        try {
            this.lock.writeLock().lock();
            this.entries.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void putIfAbsent(K key, V value) {
        try {
            this.lock.writeLock().lock();
            this.entries.putIfAbsent(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        try {
            this.lock.readLock().lock();
            int n = this.entries.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        try {
            this.lock.readLock().lock();
            String string = this.entries.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

