/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.sellcom.core.Contract;
import org.sellcom.core.util.cache.Cache;

public final class SoftCache<K, V>
implements Cache<K, V> {
    private final Map<K, SoftReference<V>> entries = new HashMap<K, SoftReference<V>>();
    private final Function<K, V> mappingFunction;
    private final ReferenceQueue<V> staleReferences = new ReferenceQueue();

    public SoftCache() {
        this.mappingFunction = null;
    }

    public SoftCache(Function<K, V> mappingFunction) {
        Contract.checkArgument(mappingFunction != null, "Mapping function must not be null", new Object[0]);
        this.mappingFunction = mappingFunction;
    }

    @Override
    public void evict(K key) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        this.expungeStaleReferences();
        this.entries.remove(key);
    }

    @Override
    public void evict(K key, V value) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        Optional<V> currentValue = this.get(key);
        if (currentValue.isPresent() && Objects.equals(currentValue.get(), value)) {
            this.evict(key);
        }
    }

    @Override
    public void evictAll() {
        this.expungeStaleReferences();
        this.entries.clear();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Contract.checkArgument(action != null, "Action must not be null", new Object[0]);
        this.expungeStaleReferences();
        for (Map.Entry<K, SoftReference<V>> currentEntry : this.entries.entrySet()) {
            K currentKey = currentEntry.getKey();
            V currentValue = currentEntry.getValue().get();
            if (currentValue == null) continue;
            action.accept(currentKey, currentValue);
        }
    }

    @Override
    public Optional<V> get(K key) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        this.expungeStaleReferences();
        Object value = null;
        SoftReference<V> softReference = this.entries.get(key);
        if (softReference == null) {
            if (this.mappingFunction != null) {
                value = this.mappingFunction.apply(key);
                this.entries.put(key, new KeyedSoftReference(this.staleReferences, key, value));
            }
            return Optional.ofNullable(value);
        }
        value = softReference.get();
        if (value == null) {
            if (this.mappingFunction != null) {
                value = this.mappingFunction.apply(key);
                this.entries.put(key, new KeyedSoftReference(this.staleReferences, key, value));
            }
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        this.expungeStaleReferences();
        V value = null;
        SoftReference<V> softReference = this.entries.get(key);
        if (softReference == null) {
            return defaultValue;
        }
        value = softReference.get();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        this.expungeStaleReferences();
        return this.entries.isEmpty();
    }

    @Override
    public void put(K key, V value) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        this.entries.put(key, new KeyedSoftReference(this.staleReferences, key, value));
    }

    @Override
    public void putIfAbsent(K key, V value) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        Optional<V> currentValue = this.get(key);
        if (!currentValue.isPresent()) {
            this.put(key, value);
        }
    }

    @Override
    public int size() {
        this.expungeStaleReferences();
        return this.entries.size();
    }

    private void expungeStaleReferences() {
        KeyedSoftReference reference;
        while ((reference = (KeyedSoftReference)this.staleReferences.poll()) != null) {
            this.entries.remove(reference.getKey());
        }
    }

    public String toString() {
        this.expungeStaleReferences();
        StringBuilder builder = new StringBuilder("{");
        this.entries.forEach((key, reference) -> {
            Object value = reference.get();
            if (value != null) {
                builder.append(key);
                builder.append("=");
                builder.append(value);
                builder.append(", ");
            }
        });
        builder.setLength(builder.length() - 2);
        builder.append("}");
        return builder.toString();
    }

    private static class KeyedSoftReference<K, V>
    extends SoftReference<V> {
        private final K key;

        private KeyedSoftReference(ReferenceQueue<? super V> staleReferences, K key, V value) {
            super(value, staleReferences);
            this.key = key;
        }

        private K getKey() {
            return this.key;
        }
    }
}

