/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingBooleanSupplier
extends BooleanSupplier {
    default public BooleanSupplier fallbackTo(BooleanSupplier fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public BooleanSupplier fallbackTo(BooleanSupplier fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsBooleanThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.getAsBoolean();
            }
        };
    }

    @Override
    default public boolean getAsBoolean() {
        try {
            return this.getAsBooleanThrowing();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public boolean getAsBooleanThrowing() throws Exception;

    default public BooleanSupplier orReturn(boolean value) {
        return this.orReturn(value, null);
    }

    default public BooleanSupplier orReturn(boolean value, Consumer<Exception> exceptionConsumer) {
        return () -> {
            try {
                return this.getAsBooleanThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingBooleanSupplier orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsBooleanThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingBooleanSupplier orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsBooleanThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingBooleanSupplier orTryWith(ThrowingBooleanSupplier other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingBooleanSupplier orTryWith(ThrowingBooleanSupplier other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsBooleanThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.getAsBooleanThrowing();
            }
        };
    }
}

