/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.DoubleToIntFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingDoubleToIntFunction
extends DoubleToIntFunction {
    @Override
    default public int applyAsInt(double argument) {
        try {
            return this.applyAsIntThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public int applyAsIntThrowing(double var1) throws Exception;

    default public DoubleToIntFunction fallbackTo(DoubleToIntFunction fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public DoubleToIntFunction fallbackTo(DoubleToIntFunction fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsInt(argument);
            }
        };
    }

    default public DoubleToIntFunction orReturn(int value) {
        return this.orReturn(value, null);
    }

    default public DoubleToIntFunction orReturn(int value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingDoubleToIntFunction orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingDoubleToIntFunction orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingDoubleToIntFunction orTryWith(ThrowingDoubleToIntFunction other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingDoubleToIntFunction orTryWith(ThrowingDoubleToIntFunction other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsIntThrowing(argument);
            }
        };
    }
}

