/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingDoubleUnaryOperator
extends DoubleUnaryOperator {
    default public ThrowingDoubleUnaryOperator andThen(ThrowingDoubleUnaryOperator after) {
        Contract.checkArgument(after != null, "After operator must not be null", new Object[0]);
        return argument -> after.applyAsDoubleThrowing(this.applyAsDoubleThrowing(argument));
    }

    @Override
    default public double applyAsDouble(double argument) {
        try {
            return this.applyAsDoubleThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public double applyAsDoubleThrowing(double var1) throws Exception;

    default public ThrowingDoubleUnaryOperator compose(ThrowingDoubleUnaryOperator before) {
        Contract.checkArgument(before != null, "Before operator must not be null", new Object[0]);
        return argument -> this.applyAsDoubleThrowing(before.applyAsDoubleThrowing(argument));
    }

    default public DoubleUnaryOperator fallbackTo(DoubleUnaryOperator fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public DoubleUnaryOperator fallbackTo(DoubleUnaryOperator fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback operator must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsDouble(argument);
            }
        };
    }

    default public DoubleUnaryOperator orReturn(double value) {
        return this.orReturn(value, null);
    }

    default public DoubleUnaryOperator orReturn(double value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingDoubleUnaryOperator orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingDoubleUnaryOperator orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingDoubleUnaryOperator orTryWith(ThrowingDoubleUnaryOperator other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingDoubleUnaryOperator orTryWith(ThrowingDoubleUnaryOperator other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other operator must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsDoubleThrowing(argument);
            }
        };
    }
}

