/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.Function;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingFunction<T, R>
extends Function<T, R> {
    @Override
    default public <V> ThrowingFunction<T, V> andThen(ThrowingFunction<? super R, ? extends V> after) {
        Contract.checkArgument(after != null, "After function must not be null", new Object[0]);
        return argument -> after.applyThrowing((R)this.applyThrowing(argument));
    }

    @Override
    default public R apply(T argument) {
        try {
            return this.applyThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public R applyThrowing(T var1) throws Exception;

    @Override
    default public <V> ThrowingFunction<V, R> compose(ThrowingFunction<? super V, ? extends T> before) {
        Contract.checkArgument(before != null, "Before function must not be null", new Object[0]);
        return argument -> this.applyThrowing(before.applyThrowing((Object)argument));
    }

    default public Function<T, R> fallbackTo(Function<T, R> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public Function<T, R> fallbackTo(Function<T, R> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.apply(argument);
            }
        };
    }

    default public Function<T, R> orReturn(R value) {
        return this.orReturn(value, null);
    }

    default public Function<T, R> orReturn(R value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingFunction<T, R> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingFunction<T, R> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingFunction<T, R> orTryWith(ThrowingFunction<? super T, ? extends R> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingFunction<T, R> orTryWith(ThrowingFunction<? super T, ? extends R> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyThrowing(argument);
            }
        };
    }
}

