/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingIntBinaryOperator
extends IntBinaryOperator {
    @Override
    default public int applyAsInt(int former, int latter) {
        try {
            return this.applyAsIntThrowing(former, latter);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public int applyAsIntThrowing(int var1, int var2) throws Exception;

    default public IntBinaryOperator fallbackTo(IntBinaryOperator fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public IntBinaryOperator fallbackTo(IntBinaryOperator fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback operator must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsInt(former, latter);
            }
        };
    }

    default public IntBinaryOperator orReturn(int value) {
        return this.orReturn(value, null);
    }

    default public IntBinaryOperator orReturn(int value, Consumer<Exception> exceptionConsumer) {
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingIntBinaryOperator orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingIntBinaryOperator orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingIntBinaryOperator orTryWith(ThrowingIntBinaryOperator other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingIntBinaryOperator orTryWith(ThrowingIntBinaryOperator other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other operator must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsIntThrowing(former, latter);
            }
        };
    }
}

