/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.IntToLongFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingIntToLongFunction
extends IntToLongFunction {
    @Override
    default public long applyAsLong(int argument) {
        try {
            return this.applyAsLongThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public long applyAsLongThrowing(int var1) throws Exception;

    default public IntToLongFunction fallbackTo(IntToLongFunction fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public IntToLongFunction fallbackTo(IntToLongFunction fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsLong(argument);
            }
        };
    }

    default public IntToLongFunction orReturn(long value) {
        return this.orReturn(value, null);
    }

    default public IntToLongFunction orReturn(long value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingIntToLongFunction orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingIntToLongFunction orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingIntToLongFunction orTryWith(ThrowingIntToLongFunction other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingIntToLongFunction orTryWith(ThrowingIntToLongFunction other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsLongThrowing(argument);
            }
        };
    }
}

