/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.ObjLongConsumer;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingObjLongConsumer<T>
extends ObjLongConsumer<T> {
    @Override
    default public void accept(T former, long latter) {
        try {
            this.acceptThrowing(former, latter);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public void acceptThrowing(T var1, long var2) throws Exception;

    default public ObjLongConsumer<T> fallbackTo(ObjLongConsumer<T> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public ObjLongConsumer<T> fallbackTo(ObjLongConsumer<T> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback consumer must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                this.acceptThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                fallback.accept(former, latter);
            }
        };
    }

    default public ThrowingObjLongConsumer<T> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                this.acceptThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingObjLongConsumer<T> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                this.acceptThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingObjLongConsumer<T> orTryWith(ThrowingObjLongConsumer<? super T> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingObjLongConsumer<T> orTryWith(ThrowingObjLongConsumer<? super T> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other consumer must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                this.acceptThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                other.acceptThrowing(former, latter);
            }
        };
    }
}

