/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingPredicate<T>
extends Predicate<T> {
    @Override
    default public boolean test(T argument) {
        try {
            return this.testThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public boolean testThrowing(T var1) throws Exception;

    default public Predicate<T> fallbackTo(Predicate<T> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public Predicate<T> fallbackTo(Predicate<T> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback predicate must not be null", new Object[0]);
        return argument -> {
            try {
                return this.testThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.test(argument);
            }
        };
    }

    default public Predicate<T> orReturn(boolean value) {
        return this.orReturn(value, null);
    }

    default public Predicate<T> orReturn(boolean value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.testThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingPredicate<T> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.testThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingPredicate<T> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.testThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingPredicate<T> orTryWith(ThrowingPredicate<? super T> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingPredicate<T> orTryWith(ThrowingPredicate<? super T> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other predicate must not be null", new Object[0]);
        return argument -> {
            try {
                return this.testThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.testThrowing(argument);
            }
        };
    }
}

