/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingSupplier<T>
extends Supplier<T> {
    default public Supplier<T> fallbackTo(Supplier<T> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public Supplier<T> fallbackTo(Supplier<T> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.get();
            }
        };
    }

    @Override
    default public T get() {
        try {
            return this.getThrowing();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public T getThrowing() throws Exception;

    default public Supplier<T> orReturn(T value) {
        return this.orReturn(value, null);
    }

    default public Supplier<T> orReturn(T value, Consumer<Exception> exceptionConsumer) {
        return () -> {
            try {
                return this.getThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingSupplier<T> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingSupplier<T> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingSupplier<T> orTryWith(ThrowingSupplier<? extends T> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingSupplier<T> orTryWith(ThrowingSupplier<? extends T> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.getThrowing();
            }
        };
    }
}

