/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.ToDoubleBiFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingToDoubleBiFunction<T, U>
extends ToDoubleBiFunction<T, U> {
    @Override
    default public double applyAsDouble(T former, U latter) {
        try {
            return this.applyAsDoubleThrowing(former, latter);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public double applyAsDoubleThrowing(T var1, U var2) throws Exception;

    default public ToDoubleBiFunction<T, U> fallbackTo(ToDoubleBiFunction<T, U> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public ToDoubleBiFunction<T, U> fallbackTo(ToDoubleBiFunction<T, U> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsDouble(former, latter);
            }
        };
    }

    default public ToDoubleBiFunction<T, U> orReturn(double value) {
        return this.orReturn(value, null);
    }

    default public ToDoubleBiFunction<T, U> orReturn(double value, Consumer<Exception> exceptionConsumer) {
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingToDoubleBiFunction<T, U> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingToDoubleBiFunction<T, U> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingToDoubleBiFunction<T, U> orTryWith(ThrowingToDoubleBiFunction<? super T, ? super U> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingToDoubleBiFunction<T, U> orTryWith(ThrowingToDoubleBiFunction<? super T, ? super U> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsDoubleThrowing(former, latter);
            }
        };
    }
}

