/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingToIntBiFunction<T, U>
extends ToIntBiFunction<T, U> {
    @Override
    default public int applyAsInt(T former, U latter) {
        try {
            return this.applyAsIntThrowing(former, latter);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public int applyAsIntThrowing(T var1, U var2) throws Exception;

    default public ToIntBiFunction<T, U> fallbackTo(ToIntBiFunction<T, U> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public ToIntBiFunction<T, U> fallbackTo(ToIntBiFunction<T, U> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsInt(former, latter);
            }
        };
    }

    default public ToIntBiFunction<T, U> orReturn(int value) {
        return this.orReturn(value, null);
    }

    default public ToIntBiFunction<T, U> orReturn(int value, Consumer<Exception> exceptionConsumer) {
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingToIntBiFunction<T, U> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingToIntBiFunction<T, U> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingToIntBiFunction<T, U> orTryWith(ThrowingToIntBiFunction<? super T, ? super U> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingToIntBiFunction<T, U> orTryWith(ThrowingToIntBiFunction<? super T, ? super U> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsIntThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsIntThrowing(former, latter);
            }
        };
    }
}

