/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.ToLongBiFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingToLongBiFunction<T, U>
extends ToLongBiFunction<T, U> {
    @Override
    default public long applyAsLong(T former, U latter) {
        try {
            return this.applyAsLongThrowing(former, latter);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public long applyAsLongThrowing(T var1, U var2) throws Exception;

    default public ToLongBiFunction<T, U> fallbackTo(ToLongBiFunction<T, U> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public ToLongBiFunction<T, U> fallbackTo(ToLongBiFunction<T, U> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsLongThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsLong(former, latter);
            }
        };
    }

    default public ToLongBiFunction<T, U> orReturn(long value) {
        return this.orReturn(value, null);
    }

    default public ToLongBiFunction<T, U> orReturn(long value, Consumer<Exception> exceptionConsumer) {
        return (former, latter) -> {
            try {
                return this.applyAsLongThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingToLongBiFunction<T, U> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsLongThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingToLongBiFunction<T, U> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsLongThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingToLongBiFunction<T, U> orTryWith(ThrowingToLongBiFunction<? super T, ? super U> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingToLongBiFunction<T, U> orTryWith(ThrowingToLongBiFunction<? super T, ? super U> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsLongThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsLongThrowing(former, latter);
            }
        };
    }
}

