/*
 * Decompiled with CFR 0.152.
 */
package org.semanticwb.resources.filerepository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.semanticwb.Logger;
import org.semanticwb.SWBPlatform;
import org.semanticwb.SWBUtils;
import org.semanticwb.jcr170.implementation.SWBCredentials;
import org.semanticwb.jcr170.implementation.SWBRepository;
import org.semanticwb.model.GenericObject;
import org.semanticwb.model.Role;
import org.semanticwb.model.User;
import org.semanticwb.model.UserGroup;
import org.semanticwb.model.WebPage;
import org.semanticwb.model.WebSite;
import org.semanticwb.platform.SemanticObject;
import org.semanticwb.platform.SemanticOntology;
import org.semanticwb.portal.api.SWBActionResponse;
import org.semanticwb.portal.api.SWBParamRequest;
import org.semanticwb.portal.api.SWBResourceException;
import org.semanticwb.portal.api.SWBResourceURL;
import org.semanticwb.portal.util.FileUpload;
import org.semanticwb.resources.filerepository.base.SemanticRepositoryFileBase;

public class SemanticRepositoryFile
extends SemanticRepositoryFileBase {
    private static final String SWB_FILEREP_DELETED = "swbfilerep:deleted";
    private static final String JCR_LASTMODIFIED = "jcr:lastModified";
    private static final String SWBFILEREPFILESIZE = "swbfilerep:filesize";
    private static final String SWBFILEREPUSERID = "swbfilerep:userid";
    private static final String SWBFILEREPCOMMENT = "swbfilerep:comment";
    private static SWBRepository rep = null;
    private static Logger log = SWBUtils.getLogger(SemanticRepositoryFile.class);
    private static final String MODE_FILES = "showfiles";
    private static final String MODE_DIRS = "showdirs";
    private static final String MODE_ADDFORM = "getAddForm";
    private static final String MODE_GETFILE = "getFile";
    private static final String MODE_SELFOLDER = "selFolder";
    private static final String FILE_DETAIL = "fdetail";
    private static final String REP_FILE = "swbfilerep:RepositoryFile";
    private static final String REP_FOLDER = "swbfilerep:RepositoryFolder";
    private static final String REP_NODE = "swbfilerep:RepositoryNode";
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_FROZEN_NODE = "jcr:frozenNode";
    private static final String CONTENT_NOT_FOUND = "El contenido no se encontr\u00f3 en el repositorio.";
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private String IDREP = null;
    private String resUUID = null;
    private static final String PARAM_UUID = "UUID";

    public SemanticRepositoryFile() {
    }

    public SemanticRepositoryFile(SemanticObject base) {
        super(base);
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response, SWBParamRequest paramRequest) throws SWBResourceException, IOException {
        if (paramRequest.getMode().equals(MODE_FILES)) {
            this.doShowFiles(request, response, paramRequest);
        } else if (paramRequest.getMode().equals(MODE_DIRS)) {
            this.doShowDirs(request, response, paramRequest);
        } else if (paramRequest.getMode().equals(MODE_ADDFORM)) {
            this.doAddForm(request, response, paramRequest);
        } else if (paramRequest.getMode().equals(MODE_GETFILE)) {
            this.doGetFile(request, response, paramRequest);
        } else {
            super.processRequest(request, response, paramRequest);
        }
    }

    public void doView(HttpServletRequest request, HttpServletResponse response, SWBParamRequest paramRequest) throws SWBResourceException, IOException {
        response.setContentType("text/html; charset=ISO-8859-1");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        PrintWriter out = response.getWriter();
        User user = paramRequest.getUser();
        WebPage wp = paramRequest.getWebPage();
        this.IDREP = this.docRepNS(request, response, paramRequest);
        this.resUUID = this.getResourceBase().getAttribute(wp.getId() + "_uuid");
        if (this.resUUID == null) {
            this.loadResUUID(wp, user);
        }
        String path = SWBPlatform.getContextPath() + "/swbadmin/images/repositoryfile/";
        out.println("<div style=\"font-family:verdana; font-size:10px;\">");
        out.println("<fieldset>");
        out.println("<legend> <img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"\"/> " + this.getTitle(request, paramRequest) + "</legend>");
        out.println("");
        if (user != null && user.isSigned()) {
            if (!this.isUseFolders()) {
                out.println(this.doShowFiles(request, response, paramRequest));
            } else {
                out.println(this.doShowDirs(request, response, paramRequest));
            }
        } else {
            out.println(paramRequest.getLocaleString("mustBeSigned"));
        }
        out.println("</fieldset>");
        out.println("</div>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResUUID(WebPage wp, User user) {
        Session session = null;
        try {
            User usrcreator = this.getResourceBase().getCreator();
            if (usrcreator == null && user != null) {
                usrcreator = user;
            }
            session = rep.login((Credentials)new SWBCredentials(usrcreator), this.IDREP);
            Node root = null;
            Node nodeRep = null;
            Node nodePage = null;
            root = session.getRootNode();
            if (this.getResourceBase().getAttribute("repNode_uuid", "").equals("")) {
                nodeRep = root.addNode(this.getResourceBase().getId(), REP_NODE);
                this.getResourceBase().setAttribute("repNode_uuid", nodeRep.getUUID());
            } else {
                nodeRep = session.getNodeByUUID(this.getResourceBase().getAttribute("repNode_uuid"));
            }
            if (nodeRep != null && wp != null && !nodeRep.hasNode(wp.getId())) {
                nodePage = nodeRep.addNode(wp.getId(), REP_FOLDER);
                nodePage.setProperty("swb:title", wp.getDisplayName());
                nodePage.setProperty(SWBFILEREPUSERID, usrcreator.getId());
                nodePage.setProperty("swb:description", "");
                nodePage.setProperty(SWB_FILEREP_DELETED, Boolean.FALSE.booleanValue());
            }
            session.save();
            this.resUUID = nodePage.getUUID();
            if (wp != null) {
                this.getResourceBase().setAttribute(wp.getId() + "_uuid", this.resUUID);
            }
            this.getResourceBase().updateAttributesToDB();
        }
        catch (Exception e) {
            log.error("Error al revisar el nodo ra\u00edz del Rep. de Documentos. SemanticRepositoryFile.loadResUDDI()", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doShowFiles(HttpServletRequest request, HttpServletResponse response, SWBParamRequest paramRequest) throws SWBResourceException, IOException {
        StringBuffer ret = new StringBuffer("");
        User user = paramRequest.getUser();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MMM/yyyy hh:mm:ss");
        int luser = this.getLevelUser(user);
        Session session = null;
        String parentUUID = request.getParameter("parentUUID");
        this.IDREP = this.docRepNS(request, response, paramRequest);
        WebPage wp = paramRequest.getWebPage();
        this.resUUID = this.getResourceBase().getAttribute(wp.getId() + "_uuid");
        if (this.resUUID == null) {
            this.loadResUUID(paramRequest.getWebPage(), user);
        }
        if (parentUUID == null) {
            parentUUID = this.resUUID;
        }
        String path = SWBPlatform.getContextPath() + "/swbadmin/images/repositoryfile/";
        String UUID = "";
        try {
            session = rep.login((Credentials)new SWBCredentials(user), this.IDREP);
            Node nodePage = session.getNodeByUUID(parentUUID);
            NodeIterator nit = nodePage.getNodes();
            ret.append(this.getLinkStyle());
            ret.append("\n<div style=\"position: relative; float: left;width: 600px;\">");
            ret.append("\n<fieldset>");
            ret.append("\n<table width=\"100%\">");
            ret.append("\n<thead >");
            ret.append("\n<tr >");
            ret.append("\n<th colspan=\"4\">");
            ret.append("\n" + nodePage.getProperty("swb:title").getString());
            ret.append("\n</th>");
            ret.append("\n<th colspan=\"2\" style=\"text-align:right;\">");
            SWBResourceURL urladd = paramRequest.getRenderUrl();
            urladd.setAction("addfile");
            urladd.setParameter("parentUUID", parentUUID);
            urladd.setMode(MODE_ADDFORM);
            if (user != null && luser > 1) {
                ret.append("\n<a href=\"" + urladd + "\">");
                ret.append("\n<img src=\"" + path + "add.gif\" border=\"0\" alt=\"" + paramRequest.getLocaleString("addFile") + "\"/>");
                ret.append("\n" + paramRequest.getLocaleString("addFile"));
                ret.append("\n</a>");
            }
            ret.append("\n</th>");
            ret.append("\n</tr>");
            SWBResourceURL urlorder = paramRequest.getRenderUrl();
            urlorder.setParameter("parentUUID", parentUUID);
            ret.append("\n<tr bgcolor=\"#B8B8B8\">");
            ret.append("\n<th >");
            ret.append("\n" + paramRequest.getLocaleString("msgInfo"));
            ret.append("\n</th>");
            ret.append("\n<th>");
            ret.append("\n<a href=\"" + urlorder + "&orderBy=type\" title=\"Ordenar por tipo\">" + paramRequest.getLocaleString("msgType") + "</a>");
            ret.append("\n</th>");
            ret.append("\n<th>");
            ret.append("\n<a href=\"" + urlorder + "&orderBy=title\" title=\"Ordenar por t\u00edtulo\">" + paramRequest.getLocaleString("msgTitle") + "</a>");
            ret.append("\n</th>");
            ret.append("\n<th>");
            ret.append("\n<a href=\"" + urlorder + "&orderBy=date\" title=\"Ordenar por fecha\">" + paramRequest.getLocaleString("msgDate") + "</a>");
            ret.append("\n</th>");
            ret.append("\n<th>");
            ret.append("\n" + paramRequest.getLocaleString("msgSelect"));
            ret.append("\n</th>");
            ret.append("\n<th>");
            ret.append("\n" + paramRequest.getLocaleString("msgAction"));
            ret.append("\n</th>");
            ret.append("\n</tr>");
            ret.append("\n</thead>");
            int nfiles = 0;
            if (nit.hasNext()) {
                String orderBy = request.getParameter("orderBy");
                if (null == orderBy) {
                    orderBy = "title";
                }
                HashMap<String, Node> hmNodes = new HashMap<String, Node>();
                while (nit.hasNext()) {
                    Node nodofolder = nit.nextNode();
                    String skey = nodofolder.getUUID();
                    if (orderBy.equals("title")) {
                        skey = nodofolder.getProperty("swb:title").getString() + "-" + nodofolder.getUUID();
                    } else if (orderBy.equals("date")) {
                        skey = nodofolder.getProperty("jcr:created").getDate().getTime() + "-" + nodofolder.getUUID();
                    } else if (orderBy.equals("type")) {
                        String file = nodofolder.getName();
                        String type = this.getFileName(file);
                        skey = type + "-" + nodofolder.getProperty("swb:title").getString() + "-" + nodofolder.getUUID();
                        hmNodes.put(skey, nodofolder);
                    }
                    hmNodes.put(skey, nodofolder);
                }
                ArrayList list = new ArrayList(hmNodes.keySet());
                Collections.sort(list);
                ret.append("\n<tbody>");
                String bgcolor = "#FFFFFF";
                for (String skey : list) {
                    Node nodo = (Node)hmNodes.get(skey);
                    if (!nodo.getPrimaryNodeType().getName().equals(REP_FILE)) continue;
                    boolean isdeleted = false;
                    try {
                        isdeleted = nodo.getProperty(SWB_FILEREP_DELETED).getBoolean();
                    }
                    catch (Exception e) {
                        log.event("Error al revisar la propiedad Deleted del repositorio de documentos.", (Throwable)e);
                    }
                    if (nodo == null || isdeleted) continue;
                    ++nfiles;
                    UUID = nodo.getUUID();
                    ret.append("\n<tr bgcolor=\"" + bgcolor + "\">");
                    bgcolor = bgcolor.equals("#FFFFFF") ? "#E8E8E8" : "#FFFFFF";
                    ret.append("\n<td>");
                    SWBResourceURL urldetail = paramRequest.getRenderUrl();
                    urldetail.setMode(MODE_ADDFORM);
                    urldetail.setParameter(PARAM_UUID, nodo.getUUID());
                    urldetail.setParameter("repNS", this.IDREP);
                    urldetail.setAction(FILE_DETAIL);
                    urldetail.setParameter("parentUUID", parentUUID);
                    ret.append("\n<a href=\"#\" onclick=\"window.location='" + urldetail + "';\"><img src=\"" + path + "info.gif\" border=\"0\" alt=\"" + paramRequest.getLocaleString("msgFileDetail") + "\"/></a>");
                    ret.append("\n</td>");
                    ret.append("\n<td>");
                    String file = nodo.getName();
                    String type = this.getFileName(file);
                    SWBResourceURL urlgetfile = paramRequest.getRenderUrl();
                    urlgetfile.setMode(MODE_GETFILE);
                    urlgetfile.setAction("inline");
                    urlgetfile.setCallMethod(3);
                    urlgetfile.setWindowState("maximized");
                    ret.append("\n<a href=\"" + urlgetfile + "/" + UUID + "/" + file + "\" onclick=\"window.location='" + urlgetfile + "/" + UUID + "/" + file + "';return false;\" alt=\"\"><img border=0 src='" + path + "" + type + "' alt=\"" + this.getFileType(file) + "\" /></a>");
                    ret.append("\n</td>");
                    ret.append("\n<td>");
                    ret.append("\n" + nodo.getProperty("swb:title").getString());
                    ret.append("\n</td>");
                    ret.append("\n<td>");
                    ret.append("\n" + sdf.format(nodo.getProperty("jcr:created").getDate().getTime()));
                    ret.append("\n</td>");
                    ret.append("\n<td>");
                    SWBResourceURL uout = paramRequest.getActionUrl();
                    uout.setParameter(PARAM_UUID, UUID);
                    uout.setParameter("repNS", this.IDREP);
                    uout.setParameter("parentUUID", parentUUID);
                    Node ndata = nodo.getNode(JCR_CONTENT);
                    String s_usrID = ndata.getProperty(SWBFILEREPUSERID).getString();
                    User autor = user.getUserRepository().getUser(s_usrID);
                    String fullname = paramRequest.getLocaleString("msgUsrAnonymous");
                    if (autor != null) {
                        fullname = autor.getFullName();
                    }
                    if (!ndata.isCheckedOut() && luser > 1) {
                        SWBResourceURL duout = paramRequest.getActionUrl();
                        duout.setParameter(PARAM_UUID, UUID);
                        duout.setParameter("repNS", this.IDREP);
                        duout.setAction("check");
                        duout.setParameter("faction", "out");
                        duout.setParameter("parentUUID", parentUUID);
                        ret.append("\n<a href=\"#\" onclick=\"window.location='" + duout + "';\">");
                        ret.append("\n<img src=\"" + path + "out.gif\" border=\"0\"/>");
                        ret.append("\n</a>");
                    } else if (paramRequest.getUser().getId().equals(autor.getId()) && luser > 1) {
                        SWBResourceURL uin = paramRequest.getRenderUrl();
                        uin.setParameter(PARAM_UUID, UUID);
                        uin.setParameter("repNS", this.IDREP);
                        uin.setMode("edit");
                        uin.setAction("checkin");
                        uin.setParameter("parentUUID", parentUUID);
                        ret.append("\n<a href=\"#\" onclick=\"window.location='" + uin + "';\">");
                        ret.append("\n<img src=\"" + path + "in.gif\" border=\"0\"alt=\"" + paramRequest.getLocaleString("msgFileUpdate") + "\"/>");
                        ret.append("\n</a>");
                        uout.setParameter("faction", "undo");
                        uout.setAction("check");
                        ret.append("\n<a href=\"#\" onclick=\"window.location='" + uout + "';\">");
                        ret.append("\n<img src=\"" + path + "undo.gif\" border=\"0\" alt=\"" + paramRequest.getLocaleString("msgFileUnlock") + "\"/>");
                        ret.append("\n</a>");
                    } else if (luser > 1) {
                        ret.append("\n<img src=\"" + path + "reserved.gif\" border=\"0\" alt=\"" + paramRequest.getLocaleString("msgFileReserved") + "\"/>");
                    }
                    if (luser == 3 && ndata.isCheckedOut() && !paramRequest.getUser().getId().equals(autor.getId())) {
                        uout.setParameter("faction", "undo");
                        uout.setAction("check");
                        ret.append("\n<a href=\"#\" onclick=\"window.location='" + uout + "';\">");
                        ret.append("\n<img src=\"" + path + "undo.gif\" border=\"0\" alt=\"" + paramRequest.getLocaleString("msgFileUnlock") + "\"/>");
                        ret.append("\n</a>");
                    }
                    ret.append("\n</td>");
                    ret.append("\n<td>");
                    SWBResourceURL usus = paramRequest.getRenderUrl();
                    usus.setParameter(PARAM_UUID, UUID);
                    usus.setParameter("repNS", this.IDREP);
                    SWBResourceURL uview = paramRequest.getRenderUrl();
                    uview.setParameter(PARAM_UUID, UUID);
                    uview.setParameter("repNS", this.IDREP);
                    ret.append("\n<a href=\"" + urlgetfile + "/" + UUID + "/" + file + "\" onclick=\"window.location='" + urlgetfile + "/" + UUID + "/" + file + "'; return false;\" alt=\"\"><img src=\"" + path + "preview.gif\" border=\"0\" alt=\"" + paramRequest.getLocaleString("msgViewFile") + "\"/></a>");
                    if (user != null && user.getId().equals(autor.getId()) || luser == 3) {
                        SWBResourceURL udel = paramRequest.getActionUrl();
                        udel.setParameter(PARAM_UUID, UUID);
                        udel.setParameter("repNS", this.IDREP);
                        udel.setAction("removefile");
                        if (null != parentUUID) {
                            udel.setParameter("parentUUID", parentUUID);
                        }
                        ret.append("\n<a href=\"#\" onclick=\"if(confirm('" + paramRequest.getLocaleString("msgAlertConfirmRemoveFile") + " " + nodo.getName() + "?')){ window.location='" + udel + "';} else { return false; }\">");
                        ret.append("\n<img src=\"" + path + "delete.gif\" border=\"0\" alt=\"" + paramRequest.getLocaleString("msgALTDelete") + "\"/>");
                        ret.append("\n</a>");
                    }
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                }
                ret.append("\n</tbody>");
            }
            ret.append("\n<tfoot>");
            ret.append("\n<tr>");
            ret.append("\n<th colspan=\"2\">");
            ret.append("\n" + nfiles + " " + paramRequest.getLocaleString("msgFiles"));
            ret.append("\n</th>");
            ret.append("\n<th colspan=\"2\">");
            ret.append("\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            ret.append("\n</th>");
            ret.append("\n<th colspan=\"2\" style=\"text-align:right;\">");
            if (user != null && luser > 1) {
                ret.append("\n<a style=\"text-decoration:none;\" href=\"" + urladd + "\">");
                ret.append("\n<img src=\"" + path + "add.gif\" border=\"0\" alt=\"" + paramRequest.getLocaleString("msgAltAddFile") + "\"/>");
                ret.append("\n" + paramRequest.getLocaleString("msgALTAddFile"));
                ret.append("\n</a>");
            }
            ret.append("\n</th>");
            ret.append("\n</tr>");
            ret.append("\n</tfoot>");
            ret.append("\n</table>");
            ret.append("\n</fieldset>");
            ret.append("\n</div>");
        }
        catch (Exception e) {
            log.error("Error al traer los archivos de folder del repositorio de documentos", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        if (request.getParameter("getfile") != null && request.getParameter("getfile").equals("true")) {
            SWBResourceURL urlgetfile = paramRequest.getRenderUrl();
            urlgetfile.setMode(MODE_GETFILE);
            urlgetfile.setParameter(PARAM_UUID, request.getParameter("fuuid"));
            urlgetfile.setParameter("repNS", request.getParameter("repNS"));
            urlgetfile.setAction("inline");
            urlgetfile.setCallMethod(3);
            urlgetfile.setWindowState("maximized");
            ret.append("<div style=\"diplay:none;\"><iframe src=\"" + urlgetfile + "\" style=\"display: none;\"/></div>");
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doShowDirs(HttpServletRequest request, HttpServletResponse response, SWBParamRequest paramRequest) throws SWBResourceException, IOException {
        StringBuffer ret = new StringBuffer("");
        User user = paramRequest.getUser();
        int luser = this.getLevelUser(user);
        WebPage wp = paramRequest.getWebPage();
        Session session = null;
        String path = SWBPlatform.getContextPath() + "/swbadmin/images/repositoryfile/";
        this.IDREP = this.docRepNS(request, response, paramRequest);
        if (this.resUUID == null) {
            this.loadResUUID(wp, user);
        }
        ret.append("\n<script>include_dom('" + SWBPlatform.getContextPath() + "/swbadmin/js/repositoryfile.js');</script>");
        ret.append(this.getLinkStyle());
        ret.append("\n<div style=\"position: relative; float: left;width: 240px;\">");
        SWBResourceURL urlfol = paramRequest.getRenderUrl();
        urlfol.setMode("view");
        String formid = "repAddFolder" + this.getResourceBase().getId();
        try {
            ret.append("\n<fieldset>");
            ret.append("\n<ul style=\"list-style-type:none; text-decoration:none;\">");
            session = rep.login((Credentials)new SWBCredentials(user), this.IDREP);
            Node nodePage = session.getNodeByUUID(this.resUUID);
            if (user != null && user.isSigned()) {
                SWBResourceURL urledit = paramRequest.getRenderUrl();
                urledit.setAction("editfolder");
                urledit.setMode(MODE_ADDFORM);
                urledit.setParameter("parentUUID", this.resUUID);
                urledit.setParameter(PARAM_UUID, this.resUUID);
                ret.append("\n<li style=\"list-style-type:none; text-decoration:none;\">");
                ret.append("\n<a href=\"#\" onclick=\"window.location='" + urledit + "';\"><img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"\"/></a>");
                ret.append("\n<a href=\"#\" onclick=\"javascript:setParentUUID(document." + formid + ",'" + this.resUUID + "'); window.location='" + urlfol + "';\">" + nodePage.getProperty("swb:title").getString() + "</a></li>");
            } else {
                ret.append("<li style=\"list-style-type:none;\"><a href=\"#\"><img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"\"/>" + nodePage.getProperty("swb:title").getString() + "</a></li>");
            }
            NodeIterator nit = nodePage.getNodes(REP_FOLDER);
            if (nit.hasNext()) {
                HashMap<String, Node> hmNodes = new HashMap<String, Node>();
                while (nit.hasNext()) {
                    Node nodofolder = nit.nextNode();
                    boolean isDeleted = Boolean.FALSE;
                    if (nodofolder.getProperty(SWB_FILEREP_DELETED) != null) {
                        isDeleted = nodofolder.getProperty(SWB_FILEREP_DELETED).getBoolean();
                    }
                    String skey = nodofolder.getProperty("swb:title").getString();
                    if (isDeleted) continue;
                    hmNodes.put(skey, nodofolder);
                }
                ArrayList list = new ArrayList(hmNodes.keySet());
                Collections.sort(list);
                ret.append("\n<ul>");
                for (String key : list) {
                    Node nodofolder = (Node)hmNodes.get(key);
                    SWBResourceURL urledit = paramRequest.getRenderUrl();
                    urledit.setAction("editfolder");
                    urledit.setMode(MODE_ADDFORM);
                    urledit.setParameter("parentUUID", this.resUUID);
                    urledit.setParameter(PARAM_UUID, nodofolder.getUUID());
                    if (user != null && user.isSigned()) {
                        ret.append("\n<li style=\"list-style-type:none;\">");
                        ret.append("\n<a href=\"#\" onclick=\"window.location='" + urledit + "';\"><img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"edit folder\"/></a>");
                        ret.append("\n<a href=\"#\" onclick=\"javascript:setParentUUID(document." + formid + ",'" + nodofolder.getUUID() + "'); window.location='" + urlfol + "?parentUUID=" + nodofolder.getUUID() + "';\">" + nodofolder.getProperty("swb:title").getString() + "</a></li>");
                        continue;
                    }
                    ret.append("<li style=\"list-style-type:none;\"><a href=\"#\"><img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"\"/>" + nodofolder.getProperty("swb:title").getString() + "</a></li>");
                }
                ret.append("\n</ul>");
            }
        }
        catch (Exception nodePage) {
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        ret.append("\n</ul>");
        ret.append("\n</fieldset>");
        if (user != null && user.isSigned() && luser > 2) {
            ret.append("\n<fieldset>");
            SWBResourceURL urladd = paramRequest.getRenderUrl();
            urladd.setAction("addfolder");
            urladd.setMode(MODE_ADDFORM);
            ret.append("\n<form name=\"" + formid + "\" action=\"" + urladd + "\" method=\"post\">");
            ret.append("\n<input type=\"hidden\" name=\"parentUUID\" value=\"" + this.resUUID + "\">");
            ret.append("\n<input type=\"submit\" value=\"" + paramRequest.getLocaleString("msgBtnAddFolder") + "\">");
            ret.append("\n</form>");
            ret.append("\n</fieldset>");
        }
        ret.append("\n</div>");
        ret.append(this.doShowFiles(request, response, paramRequest));
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddForm(HttpServletRequest request, HttpServletResponse response, SWBParamRequest paramRequest) throws SWBResourceException, IOException {
        int luser;
        PrintWriter out = response.getWriter();
        StringBuffer ret = new StringBuffer();
        Session session = null;
        String parentUUID = request.getParameter("parentUUID");
        String fUUID = request.getParameter(PARAM_UUID);
        String action = paramRequest.getAction();
        if (action == null) {
            action = "";
        }
        this.IDREP = this.docRepNS(request, response, paramRequest);
        WebPage dir = paramRequest.getWebPage();
        String path = SWBPlatform.getContextPath() + "/swbadmin/images/repositoryfile/";
        User user = paramRequest.getUser();
        SWBCredentials credentials = new SWBCredentials(user);
        SWBResourceURL url = paramRequest.getActionUrl();
        if (parentUUID == null) {
            parentUUID = this.resUUID;
        }
        if ((luser = this.getLevelUser(user)) < 1) {
            return;
        }
        ret.append("\n<script>include_dom('" + SWBPlatform.getContextPath() + "/swbadmin/js/repositoryfile.js');</script>");
        ret.append(this.getLinkStyle());
        if (action.equals("addfile")) {
            String folderTitle = dir.getDisplayName();
            if (!this.resUUID.equals(parentUUID)) {
                try {
                    session = rep.login((Credentials)credentials, this.IDREP);
                    Node nf = session.getNodeByUUID(parentUUID);
                    if (null != nf) {
                        folderTitle = folderTitle + " - " + nf.getProperty("swb:title").getString();
                    }
                }
                catch (Exception e) {
                    log.error("Error al tratar de cargar el nodo de la carpeta con UUID: " + parentUUID, (Throwable)e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            url.setAction("addfile");
            ret.append("\n<div class=\"swbform\">");
            ret.append("\n<form name=\"frmnewdoc\" method=\"post\" enctype=\"multipart/form-data\" action=\"" + url.toString() + "\">");
            ret.append("\n<fieldset>");
            ret.append("\n<legend>");
            ret.append("\n<img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"\"/> " + folderTitle);
            ret.append("\n</legend>");
            ret.append("\n<input type=\"hidden\" name=\"repNS\" value=\"" + this.IDREP + "\">");
            ret.append("\n<input type=\"hidden\" name=\"parentUUID\" value=\"" + parentUUID + "\">");
            ret.append("\n<table width=\"100%\"  border=\"0\">");
            ret.append("\n<tr>");
            ret.append("\n<td width=\"200\">");
            ret.append("\n" + paramRequest.getLocaleString("msgTitleDocument"));
            ret.append("\n</td>");
            ret.append("\n<td>");
            ret.append("\n<input  type=\"text\" maxlength=\"99\" name=\"repftitle\">");
            ret.append("\n</td>");
            ret.append("\n</tr>");
            ret.append("\n<tr>");
            ret.append("\n<td width=\"200\">");
            ret.append("\n" + paramRequest.getLocaleString("msgDescription"));
            ret.append("\n</td>");
            ret.append("\n<td>");
            ret.append("\n<textarea rows=\"5\" name=\"repfdescription\" cols=\"20\" onKeyDown=\"textCounter(this.form.repfdescription,255);\" onKeyUp=\"textCounter(this.form.repfdescription,255);\"></textarea>");
            ret.append("\n</td>");
            ret.append("\n</tr>");
            ret.append("\n<tr>");
            ret.append("\n<td width=\"200\">");
            ret.append("\n" + paramRequest.getLocaleString("msgFile"));
            ret.append("\n</td>");
            ret.append("\n<td>");
            ret.append("\n<input type=\"file\"  name=\"repfdoc\">");
            ret.append("\n</td>");
            ret.append("\n</tr>");
            ret.append("\n</table>");
            ret.append("\n</fieldset>");
            ret.append("\n<fieldset>");
            ret.append("\n<input type=\"button\"  name=\"s\" value=\"" + paramRequest.getLocaleString("msgBTNSave") + "\" onclick=\"javascript:valida();\" />\r\n");
            SWBResourceURL urlb = paramRequest.getRenderUrl();
            urlb.setMode("view");
            urlb.setParameter("parentUUID", parentUUID);
            ret.append("\n<input type=\"button\"  name=\"cancel\" value=\"" + paramRequest.getLocaleString("msgBTNCancel") + "\" onclick=\"window.location='" + urlb.toString() + "';\" />\r\n");
            ret.append("\n</fieldset>");
            ret.append("\n</form>");
            ret.append("\n</div>");
        } else if (action.equals("addfolder")) {
            url.setAction("addfolder");
            ret.append("\n<div class=\"swbform\">");
            ret.append("\n<form name=\"frmnewfolder\" method=\"post\" action=\"" + url.toString() + "\">");
            ret.append("\n<fieldset>");
            ret.append("\n<legend>");
            ret.append("\n<img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"\"/> " + dir.getDisplayName());
            ret.append("\n</legend>");
            ret.append("\n<input type=\"hidden\" name=\"repNS\" value=\"" + this.IDREP + "\">");
            ret.append("\n<input type=\"hidden\" name=\"parentUUID\" value=\"" + parentUUID + "\">");
            ret.append("\n<table width=\"100%\"  border=\"0\">");
            ret.append("\n<tr>");
            ret.append("\n<td width=\"200\">");
            ret.append("\n" + paramRequest.getLocaleString("msgFolderName"));
            ret.append("\n</td>");
            ret.append("\n<td>");
            ret.append("\n<input  type=\"text\" maxlength=\"99\" name=\"repftitle\">");
            ret.append("\n</td>");
            ret.append("\n</tr>");
            ret.append("\n<tr>");
            ret.append("\n<td width=\"200\">");
            ret.append("\n" + paramRequest.getLocaleString("msgDescription"));
            ret.append("\n</td>");
            ret.append("\n<td>");
            ret.append("\n<textarea rows=\"5\" name=\"repfdescription\" cols=\"20\" onKeyDown=\"textCounter(this.form.repfdescription,255);\" onKeyUp=\"textCounter(this.form.repfdescription,255);\"></textarea>");
            ret.append("\n</td>");
            ret.append("\n</tr>");
            ret.append("\n</table>");
            ret.append("\n</fieldset>");
            ret.append("\n<fieldset>");
            ret.append("\n<input type=\"button\"  name=\"s\" value=\"" + paramRequest.getLocaleString("msgBTNSave") + "\" onclick=\"javascript:validateAddFolder();\" />\r\n");
            SWBResourceURL urlb = paramRequest.getRenderUrl();
            urlb.setMode("view");
            urlb.setParameter("parentUUID", parentUUID);
            ret.append("\n<input type=\"button\"  name=\"cancel\" value=\"" + paramRequest.getLocaleString("msgBTNCancel") + "\" onclick=\"window.location='" + urlb.toString() + "';\" />\r\n");
            ret.append("\n</fieldset>");
            ret.append("\n</form>");
            ret.append("\n</div>");
        } else if (action.equals("editfolder")) {
            String ftitle = "";
            String fdescription = "";
            try {
                session = rep.login((Credentials)credentials, this.IDREP);
                Node fnode = session.getNodeByUUID(fUUID);
                ftitle = fnode.getProperty("swb:title").getString();
                fdescription = fnode.getProperty("swb:description").getString();
            }
            catch (Exception e) {
                log.error("Error al cargar la informaci\u00f3n de la carpeta para editarla", (Throwable)e);
            }
            url.setAction("updatefolder");
            ret.append("\n<div class=\"swbform\">");
            ret.append("\n<form name=\"frmnewfolder\" method=\"post\" action=\"" + url.toString() + "\">");
            ret.append("\n<fieldset>");
            ret.append("\n<legend>");
            ret.append("\n<img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"\"/> " + dir.getDisplayName());
            ret.append("\n</legend>");
            ret.append("\n<input type=\"hidden\" name=\"repNS\" value=\"" + this.IDREP + "\">");
            ret.append("\n<input type=\"hidden\" name=\"parentUUID\" value=\"" + parentUUID + "\">");
            ret.append("\n<input type=\"hidden\" name=\"UUID\" value=\"" + fUUID + "\">");
            ret.append("\n<table width=\"100%\"  border=\"0\">");
            ret.append("\n<tr>");
            ret.append("\n<td width=\"200\">");
            ret.append("\n" + paramRequest.getLocaleString("msgFolderName"));
            ret.append("\n</td>");
            ret.append("\n<td>");
            ret.append("\n<input  type=\"text\" maxlength=\"99\" name=\"repftitle\" value=\"" + ftitle + "\">");
            ret.append("\n</td>");
            ret.append("\n</tr>");
            ret.append("\n<tr>");
            ret.append("\n<td width=\"200\">");
            ret.append("\n" + paramRequest.getLocaleString("msgDescription"));
            ret.append("\n</td>");
            ret.append("\n<td>");
            ret.append("\n<textarea rows=\"5\" name=\"repfdescription\" cols=\"20\" onKeyDown=\"textCounter(this.form.repfdescription,255);\" onKeyUp=\"textCounter(this.form.repfdescription,255);\">" + fdescription + "</textarea>");
            ret.append("\n</td>");
            ret.append("\n</tr>");
            ret.append("\n</table>");
            ret.append("\n</fieldset>");
            ret.append("\n<fieldset>");
            if (luser > 2) {
                ret.append("\n<input type=\"button\"  name=\"s\" value=\"" + paramRequest.getLocaleString("msgBTNSave") + "\" onclick=\"javascript:validateAddFolder();\" />\r\n");
            }
            SWBResourceURL urlb = paramRequest.getRenderUrl();
            urlb.setMode("view");
            urlb.setParameter("parentUUID", parentUUID);
            ret.append("\n<input type=\"button\"  name=\"cancel\" value=\"" + paramRequest.getLocaleString("msgBTNCancel") + "\" onclick=\"window.location='" + urlb.toString() + "';\" />\r\n");
            if (!parentUUID.equals(fUUID) && luser > 2) {
                SWBResourceURL urlrem = paramRequest.getActionUrl();
                urlrem.setMode("view");
                urlrem.setAction("removefolder");
                urlrem.setParameter("repNS", this.IDREP);
                urlrem.setParameter("parentUUID", parentUUID);
                urlrem.setParameter(PARAM_UUID, fUUID);
                ret.append("\n<input type=\"button\"  name=\"btnremove\" value=\"Eliminar carpeta\" onclick=\"if(confirm('Eliminar carpeta y todos los archivos contenidos. \u00bfEst\u00e1s seguro de eliminar la carpeta?')){window.location='" + urlrem.toString() + "'} else { return false;};\" />\r\n");
            }
            ret.append("\n</fieldset>");
            ret.append("\n</form>");
            ret.append("\n</div>");
        } else if (action.equals(FILE_DETAIL)) {
            String folderTitle = dir.getDisplayName();
            String UUID = request.getParameter(PARAM_UUID);
            Node nodo = null;
            Node nf = null;
            if (!this.resUUID.equals(parentUUID)) {
                try {
                    session = rep.login((Credentials)credentials, this.IDREP);
                    nf = session.getNodeByUUID(parentUUID);
                    if (null != nf) {
                        folderTitle = folderTitle + " - " + nf.getProperty("swb:title").getString();
                    }
                }
                catch (Exception e) {
                    log.error("Error al tratar de cargar el nodo de la carpeta con UUID: " + parentUUID, (Throwable)e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            url.setAction("updatefile");
            ret.append("\n<div class=\"swbform\">");
            ret.append("\n<form name=\"frmnewdoc\" method=\"post\"  action=\"" + url.toString() + "\">");
            ret.append("\n<fieldset>");
            ret.append("\n<legend>");
            ret.append("\n<img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"\"/> " + folderTitle);
            ret.append("\n</legend>");
            ret.append("\n<input type=\"hidden\" name=\"repNS\" value=\"" + this.IDREP + "\" />");
            ret.append("\n<input type=\"hidden\" name=\"parentUUID\" value=\"" + parentUUID + "\" />");
            ret.append("\n<input type=\"hidden\" name=\"UUID\" value=\"" + UUID + "\" />");
            ret.append("\n<table width=\"100%\"  border=\"0\" >");
            boolean editFile = Boolean.FALSE;
            try {
                session = rep.login((Credentials)credentials, this.IDREP);
                nodo = session.getNodeByUUID(UUID);
                if (nodo.getPrimaryNodeType().getName().equals(REP_FILE)) {
                    Node nc = nodo.getNode(JCR_CONTENT);
                    ret.append("\n<tr>");
                    ret.append("\n<td>");
                    ret.append("\n" + paramRequest.getLocaleString("msgTitle"));
                    ret.append("\n:</td>");
                    ret.append("\n<td>");
                    String vn = this.getLastVersionOfcontent(session, "", UUID);
                    User autor = user.getUserRepository().getUser(nc.getProperty(SWBFILEREPUSERID).getString());
                    String fullname = paramRequest.getLocaleString("msgUsrAnonymous");
                    if (autor != null) {
                        fullname = autor.getFullName();
                    }
                    if (luser == 3 || paramRequest.getUser().getId().equals(autor.getId())) {
                        editFile = Boolean.TRUE;
                    }
                    if (editFile) {
                        ret.append("\n<input type=\"text\" maxlength=\"99\" name=\"repftitle\" value=\"" + nodo.getProperty("swb:title").getString() + "\">");
                    } else {
                        ret.append("\n" + nodo.getProperty("swb:title").getString());
                    }
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                    ret.append("\n<tr>");
                    ret.append("\n<td>");
                    ret.append("\n" + paramRequest.getLocaleString("msgDescription"));
                    ret.append("\n:</td>");
                    ret.append("\n<td>");
                    if (editFile) {
                        ret.append("\n<textarea rows=\"5\" name=\"repfdescription\" cols=\"20\" onKeyDown=\"textCounter(this.form.repfdescription,255);\" onKeyUp=\"textCounter(this.form.repfdescription,255);\">" + nodo.getProperty("swb:description").getString() + "</textarea>");
                    } else {
                        ret.append("\n" + nodo.getProperty("swb:description").getString());
                    }
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                    ret.append("\n<tr>");
                    ret.append("\n<td>");
                    ret.append("\n" + paramRequest.getLocaleString("msgLastUpdate"));
                    ret.append("\n:</td>");
                    ret.append("\n<td>");
                    ret.append("\n" + nc.getProperty(JCR_LASTMODIFIED).getString());
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                    ret.append("\n<tr>");
                    ret.append("\n<td>");
                    ret.append("\n" + paramRequest.getLocaleString("msgAutor"));
                    ret.append("\n:</td>");
                    ret.append("\n<td>");
                    ret.append("\n" + fullname);
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                    ret.append("\n<tr>");
                    ret.append("\n<td>");
                    ret.append("\n" + paramRequest.getLocaleString("msgActualVersion"));
                    ret.append("\n:</td>");
                    ret.append("\n<td>");
                    SWBResourceURL urlv = paramRequest.getRenderUrl();
                    urlv.setAction("showfileversions");
                    urlv.setParameter(PARAM_UUID, UUID);
                    urlv.setParameter("parentUUID", parentUUID);
                    urlv.setParameter("repNS", this.IDREP);
                    ret.append("\n" + vn + " (<a href=\"" + urlv + "\">" + paramRequest.getLocaleString("msgViewVersionHistory") + "</a>)");
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                    ret.append("\n<tr>");
                    ret.append("\n<td>");
                    String file = nodo.getName();
                    String type = this.getFileName(file);
                    ret.append("\n" + paramRequest.getLocaleString("msgFileName"));
                    ret.append("\n:</td>");
                    ret.append("\n<td>");
                    ret.append("\n" + file);
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                    ret.append("\n<tr>");
                    ret.append("\n<td>");
                    ret.append("\n" + paramRequest.getLocaleString("msgFileType"));
                    ret.append("\n:</td>");
                    ret.append("\n<td>");
                    ret.append("\n" + this.getFileType(file));
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                    ret.append("\n<tr>");
                    ret.append("\n<td>");
                    ret.append("\n" + paramRequest.getLocaleString("msgFileSize"));
                    ret.append("\n:</td>");
                    ret.append("\n<td>");
                    ret.append("\n" + nc.getProperty(SWBFILEREPFILESIZE).getString() + " bytes");
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                    ret.append("\n<tr>");
                    ret.append("\n<td>");
                    SWBResourceURL usus = paramRequest.getRenderUrl();
                    usus.setParameter(PARAM_UUID, UUID);
                    usus.setParameter("repNS", this.IDREP);
                    usus.setParameter("parentUUID", parentUUID);
                    SWBResourceURL urlgetfile = paramRequest.getRenderUrl();
                    urlgetfile.setMode(MODE_GETFILE);
                    urlgetfile.setParameter(PARAM_UUID, UUID);
                    urlgetfile.setParameter("repNS", this.IDREP);
                    urlgetfile.setAction("inline");
                    urlgetfile.setCallMethod(3);
                    urlgetfile.setWindowState("maximized");
                    urlgetfile.setParameter("parentUUID", parentUUID);
                    ret.append("\n<a href=\"#\" onclick=\"window.location='" + urlgetfile + "';\" title=\"" + paramRequest.getLocaleString("msgViewFile") + "\"><img border=\"0\" src=\"" + path + "preview.gif\" alt=\"\" /></a>");
                    if (luser == 3 || paramRequest.getUser().getId().equals(autor.getId())) {
                        SWBResourceURL udel = paramRequest.getActionUrl();
                        udel.setParameter(PARAM_UUID, UUID);
                        udel.setParameter("parentUUID", parentUUID);
                        udel.setParameter("repNS", this.IDREP);
                        udel.setAction("removefile");
                        ret.append("\n<a href=\"#\" onclick=\"if(confirm('" + paramRequest.getLocaleString("msgAlertConfirmRemoveFile") + " " + nodo.getName() + "?')){ window.location='" + udel + "';} else { return false; }\">");
                        ret.append("\n<img src=\"" + path + "delete.gif\" border=\"0\" alt=\"" + paramRequest.getLocaleString("msgAltDelete") + "\"/>");
                        ret.append("\n</a>");
                    }
                    ret.append("\n</td>");
                    ret.append("\n</tr>");
                }
            }
            catch (Exception e) {
                log.error("Error detalle archivo.", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            ret.append("\n</table>");
            ret.append("\n</fieldset>");
            ret.append("\n<fieldset>");
            if (editFile) {
                ret.append("\n<input type=\"button\"  name=\"s\" value=\"" + paramRequest.getLocaleString("msgBTNSave") + "\" onclick=\"javascript:validateEditFile();\" />\r\n");
            }
            SWBResourceURL urlb = paramRequest.getRenderUrl();
            urlb.setMode("view");
            urlb.setParameter("parentUUID", parentUUID);
            urlb.setAction(FILE_DETAIL);
            urlb.setParameter(PARAM_UUID, UUID);
            ret.append("\n<input type=\"button\"  name=\"cancel\" value=\"" + paramRequest.getLocaleString("msgBTNCancel") + "\" onclick=\"window.location='" + urlb.toString() + "';\" />\r\n");
            ret.append("\n</fieldset>");
            ret.append("\n</form>");
            ret.append("\n</div>");
        } else if (action.equals("showfileversions")) {
            String folderTitle = dir.getDisplayName();
            String UUID = request.getParameter(PARAM_UUID);
            String repNS = request.getParameter("repNS");
            Node nf = null;
            if (null != UUID) {
                try {
                    session = rep.login((Credentials)new SWBCredentials(user), repNS);
                    nf = session.getNodeByUUID(UUID);
                }
                catch (Exception e) {
                    log.error("Error al tratar de cargar el nodo de la carpeta con UUID: " + parentUUID, (Throwable)e);
                }
            }
            if (nf != null) {
                try {
                    ret.append("\n<div class=\"swbform\">");
                    ret.append("\n<fieldset>");
                    ret.append("\n<legend>");
                    ret.append("\n<img src=\"" + path + "icon-foldera.gif\" border=\"0\" alt=\"\"/> " + folderTitle);
                    ret.append("\n</legend>");
                    ret.append("\n<table width=\"100%\"  border=\"0\">");
                    ret.append("\n<thead>");
                    ret.append("\n<tr>");
                    ret.append("\n<th width=\"20\">");
                    ret.append("\n");
                    ret.append("\n</th>");
                    ret.append("\n<th width=\"20\">");
                    ret.append("\n" + paramRequest.getLocaleString("msgVersion"));
                    ret.append("\n</th>");
                    ret.append("\n<th>");
                    ret.append("\n" + paramRequest.getLocaleString("msgComments"));
                    ret.append("\n</th>");
                    ret.append("\n<th>");
                    ret.append("\n" + paramRequest.getLocaleString("msgDate"));
                    ret.append("\n</th>");
                    ret.append("\n<th>");
                    ret.append("\n" + paramRequest.getLocaleString("msgVersionUser"));
                    ret.append("\n</th>");
                    ret.append("\n<th >");
                    ret.append("\n" + paramRequest.getLocaleString("msgView"));
                    ret.append("\n</th>");
                    ret.append("\n</tr>");
                    ret.append("\n</thead>");
                    String file = nf.getName();
                    String type = this.getFileName(file);
                    Node ndata = nf.getNode(JCR_CONTENT);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MMM/yyyy hh:mm:ss");
                    VersionHistory vhis = ndata.getVersionHistory();
                    VersionIterator it = vhis.getAllVersions();
                    ret.append("\n<tbody>");
                    while (it.hasNext()) {
                        Version version = it.nextVersion();
                        if (version.getName().equals("jcr:rootVersion")) continue;
                        String numversion = version.getName();
                        String[] lblvers = vhis.getVersionLabels(version);
                        numversion = lblvers == null || lblvers.length == 0 ? version.getName() : lblvers[0];
                        Node fnode = version.getNode(JCR_FROZEN_NODE);
                        String comment = fnode.getProperty(SWBFILEREPCOMMENT).getString();
                        String lastModified = sdf.format(version.getProperty("jcr:created").getDate().getTime());
                        User autor = user.getUserRepository().getUser(fnode.getProperty(SWBFILEREPUSERID).getString());
                        String fullname = "An\u00f3nimo";
                        if (autor != null) {
                            fullname = autor.getFullName();
                        }
                        ret.append("\n<tr>");
                        ret.append("\n<td width=\"20\">");
                        ret.append("\n<img border=\"0\" src=\"" + path + "" + type + "\" alt=\"" + this.getFileType(file) + "\" />");
                        ret.append("\n</td>");
                        ret.append("\n<td width=\"20\">");
                        ret.append("\n" + numversion);
                        ret.append("\n</td>");
                        ret.append("\n<td>");
                        ret.append("\n" + comment);
                        ret.append("\n</td>");
                        ret.append("\n<td>");
                        ret.append("\n" + lastModified);
                        ret.append("\n</td>");
                        ret.append("\n<td>");
                        ret.append("\n" + fullname);
                        ret.append("\n</td>");
                        SWBResourceURL urlgetfile = paramRequest.getRenderUrl();
                        urlgetfile.setMode(MODE_GETFILE);
                        urlgetfile.setParameter(PARAM_UUID, UUID);
                        urlgetfile.setParameter("repNS", this.IDREP);
                        urlgetfile.setParameter("version", numversion);
                        urlgetfile.setAction("inline");
                        urlgetfile.setCallMethod(3);
                        urlgetfile.setWindowState("maximized");
                        urlgetfile.setParameter("parentUUID", parentUUID);
                        ret.append("\n<td>");
                        ret.append("\n<a href=\"#\" onclick=\"window.location='" + urlgetfile + "';\" title=\"" + paramRequest.getLocaleString("msgViewFile") + "\"><img border=\"0\" src=\"" + path + "preview.gif\" alt=\"" + paramRequest.getLocaleString("msgAltViewVersion") + "\" /></a>");
                        ret.append("\n</td>");
                        ret.append("\n</tr>");
                    }
                    ret.append("\n</tbody>");
                    ret.append("\n</table>");
                    ret.append("\n</fieldset>");
                }
                catch (Exception e) {
                    log.error("Error al traer la lista de versiones.doAddForm.showFileVersions", (Throwable)e);
                }
            }
            ret.append("\n<fieldset>");
            SWBResourceURL urlb = paramRequest.getRenderUrl();
            urlb.setMode("view");
            urlb.setParameter("parentUUID", parentUUID);
            urlb.setParameter(PARAM_UUID, UUID);
            ret.append("\n<input type=\"button\"  name=\"cancel\" value=\"" + paramRequest.getLocaleString("msgBTNCancel") + "\" onclick=\"window.location='" + urlb.toString() + "'\" />\r\n");
            ret.append("\n</fieldset>");
            ret.append("\n</div>");
        }
        out.println(ret.toString());
    }

    public void doAdmin(HttpServletRequest request, HttpServletResponse response, SWBParamRequest paramRequest) throws SWBResourceException, IOException {
        response.setContentType("text/html; charset=ISO-8859-1");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        String strView = "-1";
        String strModify = "-1";
        String strAdmin = "-1";
        String strNotify = "";
        String strCheck = "checked";
        String strEnable = "";
        String id = this.getResourceBase().getId();
        PrintWriter out = response.getWriter();
        String accion = paramRequest.getAction();
        if (accion == null) {
            accion = "";
        }
        User user = paramRequest.getUser();
        WebPage wpage = paramRequest.getWebPage();
        WebSite wsite = this.getResourceBase().getWebSite();
        this.IDREP = this.docRepNS(request, response, paramRequest);
        boolean flag = false;
        try {
            if (this.getSee() != null) {
                strView = this.getSee();
                flag = true;
            }
            if (this.getModify() != null) {
                strModify = this.getModify();
                flag = true;
            }
            if (this.getAdmin() != null) {
                strAdmin = this.getAdmin();
                flag = true;
            }
        }
        catch (Exception e) {
            log.error("Error al revisar la configuraci\u00f3n inicial del repositorio de documentos.", (Throwable)e);
        }
        if (this.isUseFolders()) {
            strCheck = "checked";
            flag = true;
        } else {
            strCheck = "";
            flag = true;
        }
        out.println("<div class=\"swbform\">");
        if (accion.equals("edit")) {
            SWBResourceURL urlA = paramRequest.getActionUrl();
            urlA.setAction("admin_update");
            out.println("<form id=\"" + id + "_myform_repfile\"  name=\"" + id + "_myform_repfile\" action=\"" + urlA.toString() + "\" method=\"post\" onsubmit=\"submitForm('" + id + "_myform_repfile');return false;\">");
            out.println("<fieldset>");
            out.println("<legend>");
            out.println(paramRequest.getLocaleString("msgFileRepositoryRes"));
            out.println("</legend>");
            out.println("<table width=\"100%\" border=\"0\" >");
            out.println("<tr><td colspan=\"2\"><B>" + paramRequest.getLocaleString("msgRolesDefinitionLevel") + "</b></td></tr>");
            out.println("<tr><td align=\"right\" width=150>" + paramRequest.getLocaleString("msgView") + ":</td>");
            out.println("<td><select name=\"ver\">" + this.getSelectOptions("ver", wsite, paramRequest) + "</select></td></tr>");
            out.println("<tr><td align=\"right\" width=150>" + paramRequest.getLocaleString("msgModify") + ":</td>");
            out.println("<td><select name=\"modificar\">" + this.getSelectOptions("modificar", wsite, paramRequest) + "</select></td></tr>");
            out.println("<tr><td align=\"right\"  width=150>" + paramRequest.getLocaleString("msgAdministrate") + ":</td>");
            out.println("<td><select name=\"administrar\">" + this.getSelectOptions("administrar", wsite, paramRequest) + "</select></td></tr>");
            out.println("<tr><td align=\"right\"  width=150>" + paramRequest.getLocaleString("msgShowSubDirs") + ":</td>");
            out.println("<td><input type=\"checkbox\" name=\"showdirectory\" value=\"1\" " + strCheck + " " + strEnable + ">");
            out.println("</td></tr>");
            out.println("</table>");
            out.println("</fieldset>");
            out.println("<fieldset>");
            out.println("<button dojoType=\"dijit.form.Button\" type=\"submit\" id=\"" + id + "btn\" name=\"btn\" >" + paramRequest.getLocaleString("msgBTNAccept"));
            out.println("</button>");
            SWBResourceURL urlold = paramRequest.getRenderUrl();
            urlold.setAction("showold");
            out.println("<button dojoType=\"dijit.form.Button\" type=\"button\" name=\"btnold\" onclick=\"submitUrl('" + urlold + "',this.domNode); return false;\" >" + paramRequest.getLocaleString("msgBTNViewOldFiles") + "</button>");
            out.println("</fieldset>");
            out.println("<fieldset>");
            out.println("<br> * " + paramRequest.getLocaleString("msgNote") + ": " + paramRequest.getLocaleString("msgRolesDependent"));
            out.println("</fieldset>");
            out.println("</form>");
            if (flag) {
                if (strView.equals("-1")) {
                    strView = "0";
                }
                if (strModify.equals("-1")) {
                    strModify = "0";
                }
                if (strAdmin.equals("-1")) {
                    strAdmin = "0";
                }
            }
        } else if (accion.equals("showold")) {
            SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yyyy hh:mm:ss", new Locale(paramRequest.getUser().getLanguage()));
            String ns = this.docRepNS(request, response, paramRequest);
            Node nodeRep = null;
            Node nf = null;
            Node nfi = null;
            Session session = null;
            try {
                session = rep.login((Credentials)new SWBCredentials(user), ns);
                String swbresUUID = this.getResourceBase().getAttribute("repNode_uuid", "");
                out.println("<div class=\"swform\">");
                out.println("<fieldset>");
                out.println("<legend>");
                out.println(paramRequest.getLocaleString("msgFileRemovePermanently") + ":</td>");
                out.println("</legend>");
                SWBResourceURL urlShowOld = paramRequest.getActionUrl();
                urlShowOld.setMode("admin");
                urlShowOld.setAction("ShowOld");
                out.println("<form action=\"" + urlShowOld.toString() + "\" name=\"frmdelfile\" method=\"post\">");
                out.println("<table width=\"100%\" border=\"0\">");
                out.println("<tr><th>" + paramRequest.getLocaleString("msgTHFolder") + "</th><th>" + paramRequest.getLocaleString("msgTHFileName") + "</th><th>" + paramRequest.getLocaleString("msgTHCreated") + "</th><th>" + paramRequest.getLocaleString("msgTHEmialUser") + "</th><th>" + paramRequest.getLocaleString("msgTHAction") + "</th></tr>");
                if (!swbresUUID.equals("")) {
                    nodeRep = session.getNodeByUUID(swbresUUID);
                }
                if (nodeRep != null) {
                    String rowColor = "";
                    boolean cambiaColor = true;
                    NodeIterator itn = nodeRep.getNodes().nextNode().getNodes();
                    while (itn.hasNext()) {
                        nf = itn.nextNode();
                        if (!nf.getPrimaryNodeType().getName().equals(REP_FOLDER)) continue;
                        rowColor = "bgcolor=\"#EFEDEC\"";
                        if (!cambiaColor) {
                            rowColor = "";
                        }
                        cambiaColor = !cambiaColor;
                        boolean fdel = nf.getProperty(SWB_FILEREP_DELETED).getBoolean();
                        if (fdel) {
                            out.println("<tr " + rowColor + ">");
                            out.println("<td>" + nf.getName() + "</td>");
                            out.println("<td>folder</td>");
                            out.println("<td>" + df.format(nf.getProperty("jcr:created").getDate().getTime()) + "</td>");
                            User usrcreator = paramRequest.getUser().getUserRepository().getUser(this.getResourceBase().getCreator().getId());
                            out.println("<td><a href=\"mailto:" + usrcreator.getEmail() + "\">" + usrcreator.getEmail() + "</a></td>");
                            out.println("<td>");
                            SWBResourceURL urlrecover = paramRequest.getActionUrl();
                            urlrecover.setParameter(PARAM_UUID, nf.getUUID());
                            urlrecover.setParameter("repNS", ns);
                            urlrecover.setAction("admin_recover_folder");
                            SWBResourceURL urldel = paramRequest.getActionUrl();
                            urldel.setParameter(PARAM_UUID, nf.getUUID());
                            urldel.setParameter("repNS", ns);
                            urldel.setAction("admin_delete");
                            out.println("<a href=\"#\" onclick=\"submitUrl('" + urlrecover + "',this); return false;\"><img src=\"" + SWBPlatform.getContextPath() + "/swbadmin/images/recover.gif\" border=\"0\" title=\"" + paramRequest.getLocaleString("msgAltRestore") + "\" ></a>");
                            out.println("&nbsp;<a href=\"#\" onclick=\"submitUrl('" + urldel + "',this); return false;\"><img src=\"" + SWBPlatform.getContextPath() + "/swbadmin/images/trash_vacio.gif\" border=\"0\" title=\"" + paramRequest.getLocaleString("msgAltEliminate") + "\" ></a>");
                            out.println("</td>");
                            out.println("</tr>");
                        }
                        NodeIterator itf = nf.getNodes();
                        while (itf.hasNext()) {
                            nfi = itf.nextNode();
                            if (!nfi.getPrimaryNodeType().getName().equals(REP_FILE)) continue;
                            boolean fidel = false;
                            fidel = nfi.getProperty(SWB_FILEREP_DELETED).getBoolean();
                            if (!fidel) continue;
                            rowColor = "bgcolor=\"#EFEDEC\"";
                            if (!cambiaColor) {
                                rowColor = "";
                            }
                            cambiaColor = !cambiaColor;
                            out.println("<tr " + rowColor + ">");
                            out.println("<td>" + nf.getName() + "</td>");
                            out.println("<td>" + nfi.getName() + "</td>");
                            Node ndata = nfi.getNode(JCR_CONTENT);
                            String s_usrID = ndata.getProperty(SWBFILEREPUSERID).getString();
                            out.println("<td>" + df.format(ndata.getProperty(JCR_LASTMODIFIED).getDate().getTime()) + "</td>");
                            User usrcreator = paramRequest.getWebPage().getWebSite().getUserRepository().getUser(s_usrID);
                            out.println("<td><a href=\"mailto:" + usrcreator.getEmail() + "\">" + usrcreator.getEmail() + "</a></td>");
                            out.println("<td>");
                            SWBResourceURL urlrecover = paramRequest.getActionUrl();
                            urlrecover.setParameter(PARAM_UUID, nfi.getUUID());
                            urlrecover.setParameter("repNS", ns);
                            urlrecover.setAction("admin_recover");
                            SWBResourceURL urldel = paramRequest.getActionUrl();
                            urldel.setParameter(PARAM_UUID, nfi.getUUID());
                            urldel.setParameter("repNS", ns);
                            urldel.setAction("admin_delete");
                            out.println("<a href=\"#\" onclick=\"submitUrl('" + urlrecover + "',this); return false;\"><img src=\"" + SWBPlatform.getContextPath() + "/swbadmin/images/recover.gif\" border=\"0\" title=\"" + paramRequest.getLocaleString("msgAltRestore") + "\" ></a>");
                            out.println("&nbsp;<a href=\"#\" onclick=\"submitUrl('" + urldel + "',this); return false;\"><img src=\"" + SWBPlatform.getContextPath() + "/swbadmin/images/trash_vacio.gif\" border=\"0\" title=\"" + paramRequest.getLocaleString("msgAltEliminate") + "\" ></a>");
                            out.println("</td>");
                            out.println("</tr>");
                        }
                    }
                }
                out.println("</table>");
                out.println("</form>");
                out.println("</fieldset>");
                out.println("<fieldset>");
                SWBResourceURL ub = paramRequest.getRenderUrl();
                ub.setAction("edit");
                out.println("<button dojoType=\"dijit.form.Button\" type=\"button\" name=\"btn_back\" onclick=\"submitUrl('" + ub + "',this.domNode); return false;\">" + paramRequest.getLocaleString("btnBack") + "</button>");
                out.println("</fieldset>");
            }
            catch (Exception e) {
                log.error("Error al traer los folders/archivos eliminados. doAdmin.showold", (Throwable)e);
            }
        }
        out.println("</div>");
    }

    public String getSelectOptions(String type, WebSite wsite, SWBParamRequest paramRequest) {
        String strTemp = "";
        try {
            User user = paramRequest.getUser();
            String selectedItem = "";
            if (type.equals("ver")) {
                selectedItem = this.getSee();
            } else if (type.equals("modificar")) {
                selectedItem = this.getModify();
            } else if (type.equals("administrar")) {
                selectedItem = this.getAdmin();
            }
            strTemp = "<option value=\"-1\">" + paramRequest.getLocaleString("msgNoRolesAvailable") + "</option>";
            Iterator iRoles = wsite.getUserRepository().listRoles();
            StringBuffer strRules = new StringBuffer("");
            strRules.append("\n<option value=\"0\">" + paramRequest.getLocaleString("msgSelNone") + "</option>");
            strRules.append("\n<optgroup label=\"Roles\">");
            String slang = user.getLanguage();
            String stitle = "";
            while (iRoles.hasNext()) {
                Role oRole = (Role)iRoles.next();
                if (null == oRole || selectedItem == null) continue;
                stitle = "";
                stitle = oRole.getDisplayTitle(slang) != null ? oRole.getDisplayTitle(slang) : (oRole.getTitle(slang) != null ? oRole.getTitle(slang) : (oRole.getTitle() != null ? oRole.getTitle() : oRole.getId()));
                strRules.append("\n<option value=\"" + oRole.getURI() + "\" " + (selectedItem.equals(oRole.getURI()) ? "selected" : "") + ">" + stitle + "</option>");
            }
            strRules.append("\n</optgroup>");
            strRules.append("\n<optgroup label=\"User Groups\">");
            Iterator iugroups = wsite.getUserRepository().listUserGroups();
            while (iugroups.hasNext()) {
                UserGroup oUG = (UserGroup)iugroups.next();
                strRules.append("\n<option value=\"" + oUG.getURI() + "\" " + (selectedItem.equals(oUG.getURI()) ? "selected" : "") + ">" + oUG.getDisplayTitle(user.getLanguage()) + "</option>");
            }
            strRules.append("\n</optgroup>");
            if (strRules.toString().length() > 0) {
                strTemp = strRules.toString();
            }
        }
        catch (Exception e) {
            log.error("Error al cargar los roles del repositorio de usuarios.", (Throwable)e);
        }
        return strTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(HttpServletRequest request, SWBActionResponse response) throws SWBResourceException, IOException {
        String action = response.getAction();
        String id = request.getParameter("suri");
        String repNS = request.getParameter("repNS");
        if (null == action) {
            action = "";
        }
        User user = response.getUser();
        Session session = null;
        SWBCredentials credentials = new SWBCredentials(user);
        if ("admin_update".equals(action)) {
            String viewrole = request.getParameter("ver");
            String modifyrole = request.getParameter("modificar");
            String adminrole = request.getParameter("administrar");
            String notifynew = request.getParameter("notificationcreate");
            String nofiryupdate = request.getParameter("notificationupdate");
            String notifyremove = request.getParameter("notificationremove");
            boolean usefolders = request.getParameter("showdirectory") != null && request.getParameter("showdirectory").equals("1");
            this.setSee(viewrole);
            this.setModify(modifyrole);
            this.setAdmin(adminrole);
            this.setMsgcrated(notifynew);
            this.setMsgupdated(nofiryupdate);
            this.setMsgdeleted(notifyremove);
            this.setUseFolders(usefolders);
            try {
                this.getResourceBase().updateAttributesToDB();
            }
            catch (Exception exception) {
                // empty catch block
            }
            response.setMode("admin");
            response.setAction("edit");
        } else if ("admin_recover_folder".equals(action)) {
            String UUID = request.getParameter(PARAM_UUID);
            try {
                session = rep.login((Credentials)credentials, repNS);
                Node nodofolder = session.getNodeByUUID(UUID);
                if (nodofolder != null) {
                    boolean isDeleted = Boolean.FALSE;
                    if (nodofolder.getProperty(SWB_FILEREP_DELETED) != null) {
                        isDeleted = nodofolder.getProperty(SWB_FILEREP_DELETED).getBoolean();
                    }
                    if (isDeleted) {
                        nodofolder.setProperty(SWB_FILEREP_DELETED, Boolean.FALSE.booleanValue());
                        nodofolder.save();
                    }
                }
            }
            catch (Exception e) {
                log.error("Error al hacer el Folder Recover processAction.admin_recover_folder", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            response.setMode("admin");
            response.setAction("showold");
        } else if ("admin_recover".equals(action)) {
            String UUID = request.getParameter(PARAM_UUID);
            try {
                session = rep.login((Credentials)credentials, repNS);
                Node fnode = session.getNodeByUUID(UUID);
                Node nodofolder = fnode.getParent();
                if (nodofolder != null) {
                    boolean isDeleted = Boolean.FALSE;
                    if (nodofolder.getProperty(SWB_FILEREP_DELETED) != null) {
                        isDeleted = nodofolder.getProperty(SWB_FILEREP_DELETED).getBoolean();
                    }
                    if (isDeleted) {
                        nodofolder.setProperty(SWB_FILEREP_DELETED, Boolean.FALSE.booleanValue());
                        nodofolder.save();
                    }
                }
                if (!nodofolder.isCheckedOut()) {
                    fnode.checkout();
                }
                fnode.checkout();
                fnode.setProperty(SWB_FILEREP_DELETED, Boolean.FALSE.booleanValue());
                Node contenido = fnode.getNode(JCR_CONTENT);
                if (!contenido.isCheckedOut()) {
                    contenido.checkout();
                    contenido.save();
                }
                contenido.restore(contenido.getBaseVersion(), false);
                contenido.save();
                fnode.save();
                Version ver = contenido.checkin();
                VersionHistory history = ver.getContainingHistory();
                ver.remove();
                history.save();
            }
            catch (Exception e) {
                log.error("Error al hacer el File Recover processAction.admin_recover", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            response.setMode("admin");
            response.setAction("showold");
        } else if ("admin_delete".equals(action)) {
            String UUID = request.getParameter(PARAM_UUID);
            try {
                session = rep.login((Credentials)credentials, repNS);
                Node fnode = session.getNodeByUUID(UUID);
                fnode.remove();
                session.save();
            }
            catch (Exception e) {
                log.error("Error al eliminar el archivo processAction.admin_delete", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            response.setMode("admin");
            response.setAction("showold");
        } else if ("addfile".equals(action)) {
            String filename = null;
            String parentUUID = null;
            try {
                int pos;
                FileUpload fup = new FileUpload();
                fup.getFiles(request, null);
                repNS = fup.getValue("repNS");
                filename = fup.getFileName("repfdoc");
                String title = fup.getValue("repftitle");
                String description = fup.getValue("repfdescription");
                parentUUID = fup.getValue("parentUUID");
                if (parentUUID == null) {
                    parentUUID = this.resUUID;
                }
                if (filename.lastIndexOf(47) != -1) {
                    pos = filename.lastIndexOf(47);
                    filename = filename.substring(pos + 1);
                }
                if (filename.lastIndexOf(92) != -1) {
                    pos = filename.lastIndexOf(92);
                    filename = filename.substring(pos + 1);
                }
                byte[] bcont = fup.getFileData("repfdoc");
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                session = rep.login((Credentials)credentials, repNS);
                Node nodePage = session.getNodeByUUID(parentUUID);
                Node nodeFile = nodePage.addNode(filename, REP_FILE);
                nodeFile.setProperty("swb:title", title);
                nodeFile.setProperty("swb:description", description);
                nodeFile.setProperty(SWB_FILEREP_DELETED, Boolean.FALSE.booleanValue());
                Node nodeRes = nodeFile.addNode(JCR_CONTENT, "swbfilerep:RepositoryResource");
                nodeRes.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(bcont));
                nodeRes.addMixin("mix:versionable");
                nodeRes.setProperty("jcr:encoding", "");
                nodeRes.setProperty(JCR_LASTMODIFIED, cal);
                nodeRes.setProperty("jcr:mimeType", fup.getContentType());
                nodeRes.setProperty(SWBFILEREPCOMMENT, "Nuevo");
                nodeRes.setProperty(SWBFILEREPUSERID, user.getId());
                nodeRes.setProperty(SWBFILEREPFILESIZE, (long)bcont.length);
                nodePage.save();
                Version version = nodeRes.checkin();
                nodeFile.checkin();
                log.debug("Version created with number " + version.getName());
                session.save();
            }
            catch (Exception e) {
                log.error("ERROR al agregar un archivo al repositorio de documentos.", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            response.setRenderParameter("parentUUID", parentUUID);
            response.setMode("view");
        } else if ("addfolder".equals(action)) {
            String strTitle = request.getParameter("repftitle");
            String strDescription = request.getParameter("repfdescription");
            String pUUID = request.getParameter("parentUUID");
            if (pUUID == null) {
                pUUID = this.resUUID;
            }
            try {
                session = rep.login((Credentials)credentials, repNS);
                Node nodePage = session.getNodeByUUID(pUUID);
                Node nodeFolder = nodePage.addNode(REP_FOLDER, REP_FOLDER);
                nodeFolder.setProperty("swb:title", strTitle);
                nodeFolder.setProperty("swb:description", strDescription);
                nodeFolder.setProperty(SWBFILEREPUSERID, user.getId());
                nodeFolder.setProperty(SWB_FILEREP_DELETED, Boolean.FALSE.booleanValue());
                nodePage.save();
            }
            catch (Exception e) {
                log.error("Error al crear folder processAction.addFolder", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            response.setRenderParameter("parentUUID", pUUID);
            response.setMode("view");
        } else if ("removefile".equals(action)) {
            String pUUID = request.getParameter("parentUUID");
            if (pUUID == null) {
                pUUID = this.resUUID;
            }
            String UUID = request.getParameter(PARAM_UUID);
            try {
                session = rep.login((Credentials)credentials, repNS);
                Node fnode = session.getNodeByUUID(UUID);
                Node fc = fnode.getNode(JCR_CONTENT);
                if (!fnode.isCheckedOut()) {
                    fc.checkout();
                }
                fnode.checkout();
                fnode.setProperty(SWB_FILEREP_DELETED, Boolean.TRUE.booleanValue());
                fnode.save();
            }
            catch (Exception e) {
                log.error("Error al eliminar el archivo processAction.removeFile", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            if (null != pUUID) {
                response.setRenderParameter("parentUUID", pUUID);
            }
            response.setRenderParameter(PARAM_UUID, UUID);
            response.setMode("view");
        } else if ("removefolder".equals(action)) {
            String pUUID = request.getParameter("\u00b4parentUUID");
            String fUUID = request.getParameter(PARAM_UUID);
            try {
                session = rep.login((Credentials)credentials, repNS);
                Node fnode = session.getNodeByUUID(fUUID);
                fnode.setProperty(SWB_FILEREP_DELETED, Boolean.TRUE.booleanValue());
                NodeIterator nit = fnode.getNodes();
                while (nit.hasNext()) {
                    Node nodo = nit.nextNode();
                    Node fc = nodo.getNode(JCR_CONTENT);
                    if (!nodo.isCheckedOut()) {
                        fc.checkout();
                    }
                    nodo.checkout();
                    nodo.setProperty(SWB_FILEREP_DELETED, Boolean.TRUE.booleanValue());
                    nodo.save();
                }
                fnode.save();
            }
            catch (Exception e) {
                log.error("Error al eliminar el folder processAction.removeFolder", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            response.setRenderParameter("parentUUID", pUUID);
            response.setRenderParameter(PARAM_UUID, fUUID);
            response.setMode("view");
        } else if ("updatefile".equals(action)) {
            boolean isChecked = false;
            String strTitle = request.getParameter("repftitle");
            String strDescription = request.getParameter("repfdescription");
            String pUUID = request.getParameter("parentUUID");
            String UUID = request.getParameter(PARAM_UUID);
            if (pUUID == null) {
                pUUID = this.resUUID;
            }
            try {
                session = rep.login((Credentials)credentials, repNS);
                Node fnode = session.getNodeByUUID(UUID);
                Node contenido = fnode.getNode(JCR_CONTENT);
                if (!contenido.isCheckedOut()) {
                    contenido.checkout();
                    contenido.setProperty(SWBFILEREPUSERID, user.getId());
                    contenido.save();
                    fnode.checkout();
                    fnode.save();
                    isChecked = true;
                }
                fnode.setProperty("swb:title", strTitle);
                fnode.setProperty("swb:description", strDescription);
                if (isChecked) {
                    contenido.restore(contenido.getBaseVersion(), false);
                    contenido.save();
                    Version ver = contenido.checkin();
                    VersionHistory history = ver.getContainingHistory();
                    ver.remove();
                    history.save();
                    fnode.save();
                }
            }
            catch (Exception e) {
                log.error("Error al crear folder processAction.updateFile", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            response.setRenderParameter("parentUUID", pUUID);
            response.setRenderParameter(PARAM_UUID, UUID);
            response.setMode("view");
        } else if ("updatefolder".equals(action)) {
            String strTitle = request.getParameter("repftitle");
            String strDescription = request.getParameter("repfdescription");
            String pUUID = request.getParameter("parentUUID");
            String UUID = request.getParameter(PARAM_UUID);
            if (pUUID == null) {
                pUUID = this.resUUID;
            }
            try {
                session = rep.login((Credentials)credentials, repNS);
                Node fnode = session.getNodeByUUID(UUID);
                fnode.setProperty("swb:title", strTitle);
                fnode.setProperty("swb:description", strDescription);
                fnode.save();
            }
            catch (Exception e) {
                log.error("Error al crear folder processAction.updateFolder", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            response.setRenderParameter("parentUUID", pUUID);
            response.setMode("view");
        } else if ("check".equals(action)) {
            String faction = "";
            if (request.getParameter("faction") != null && request.getParameter("faction").trim().length() > 0) {
                faction = request.getParameter("faction");
            }
            if ("in".equals(faction)) {
                String filename = null;
                String parentUUID = null;
                try {
                    int pos;
                    FileUpload fup = new FileUpload();
                    fup.getFiles(request, null);
                    repNS = fup.getValue("repNS");
                    filename = fup.getFileName("fileversion");
                    String comentario = fup.getValue("commentversion");
                    if (comentario.trim().length() == 0) {
                        comentario = "Nueva versi\u00f3n";
                    }
                    if ((parentUUID = fup.getValue(PARAM_UUID)) == null) {
                        parentUUID = this.resUUID;
                    }
                    if (filename.lastIndexOf(47) != -1) {
                        pos = filename.lastIndexOf(47);
                        filename = filename.substring(pos + 1);
                    }
                    if (filename.lastIndexOf(92) != -1) {
                        pos = filename.lastIndexOf(92);
                        filename = filename.substring(pos + 1);
                    }
                    byte[] bcont = fup.getFileData("fileversion");
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(System.currentTimeMillis());
                    session = rep.login((Credentials)credentials, repNS);
                    Node nodeFile = session.getNodeByUUID(parentUUID);
                    Node nodeRes = nodeFile.getNode(JCR_CONTENT);
                    nodeRes.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(bcont));
                    nodeRes.setProperty("jcr:encoding", "");
                    nodeRes.setProperty(JCR_LASTMODIFIED, cal);
                    nodeRes.setProperty("jcr:mimeType", fup.getContentType());
                    nodeRes.setProperty(SWBFILEREPCOMMENT, comentario);
                    nodeRes.setProperty(SWBFILEREPUSERID, user.getId());
                    nodeRes.setProperty(SWBFILEREPFILESIZE, (long)bcont.length);
                    nodeFile.save();
                    nodeRes.save();
                    Version version = nodeRes.checkin();
                    log.debug("Version created with number " + version.getName());
                }
                catch (Exception e) {
                    log.error("ERROR al agregar un archivo al repositorio de documentos.", (Throwable)e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
                if (request.getParameter("parentUUID") != null) {
                    response.setRenderParameter("parentUUID", request.getParameter("parentUUID"));
                }
                response.setMode("view");
            } else if ("undo".equals(faction)) {
                String UUID = request.getParameter(PARAM_UUID);
                try {
                    session = rep.login((Credentials)credentials, repNS);
                    Node fnode = session.getNodeByUUID(UUID);
                    Node contenido = fnode.getNode(JCR_CONTENT);
                    contenido.restore(contenido.getBaseVersion(), false);
                    contenido.save();
                    Version ver = contenido.checkin();
                    VersionHistory history = ver.getContainingHistory();
                    ver.remove();
                    history.save();
                }
                catch (Exception e) {
                    log.error("Error al hacer el UndoCheckOut processAction.undo", (Throwable)e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
                if (request.getParameter("parentUUID") != null) {
                    response.setRenderParameter("parentUUID", request.getParameter("parentUUID"));
                }
            } else if ("out".equals(faction)) {
                String UUID = request.getParameter(PARAM_UUID);
                try {
                    session = rep.login((Credentials)credentials, repNS);
                    Node fnode = session.getNodeByUUID(UUID);
                    Node contenido = fnode.getNode(JCR_CONTENT);
                    contenido.checkout();
                    contenido.setProperty(SWBFILEREPUSERID, user.getId());
                    contenido.save();
                }
                catch (Exception e) {
                    log.error("Error al hacer check out del archivo. processAction.checkOut()", (Throwable)e);
                }
                response.setRenderParameter("fuuid", UUID);
                response.setRenderParameter("repNS", repNS);
                response.setRenderParameter("getfile", "true");
                response.setMode("view");
                if (request.getParameter("parentUUID") != null) {
                    response.setRenderParameter("parentUUID", request.getParameter("parentUUID"));
                }
            }
        }
        if (null != id) {
            response.setRenderParameter("suri", id);
        }
    }

    public void doEdit(HttpServletRequest request, HttpServletResponse response, SWBParamRequest paramRequest) throws SWBResourceException, IOException {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        PrintWriter out = response.getWriter();
        User user = paramRequest.getUser();
        String uuid = request.getParameter(PARAM_UUID);
        String ns = request.getParameter("repNS");
        String path = SWBPlatform.getContextPath() + "/swbadmin/images/repositoryfile/";
        String action = paramRequest.getAction();
        SWBCredentials credentials = new SWBCredentials(user);
        Session session = null;
        boolean checked = false;
        if ("checkin".equals(action)) {
            out.println("<script>include_dom('" + SWBPlatform.getContextPath() + "/swbadmin/js/repositoryfile.js');</script>");
            try {
                session = rep.login((Credentials)credentials, ns);
                Node nodo = session.getNodeByUUID(uuid);
                String filename = nodo.getName();
                String vernum = this.getLastVersionOfcontent(session, ns, uuid);
                Node nc = nodo.getNode(JCR_CONTENT);
                VersionHistory verhis = nodo.getVersionHistory();
                float fvnum = Float.parseFloat(vernum);
                float fvnum_short = fvnum + 0.1f;
                float fvnum_big = (int)fvnum_short + 1;
                SWBResourceURL urla = paramRequest.getActionUrl();
                urla.setParameter("faction", "in");
                urla.setAction("check");
                out.println("<div >");
                out.println("<form method=\"post\" action=\"" + urla + "\" enctype=\"multipart/form-data\" >");
                out.println("<input type=\"hidden\" name=\"UUID\" value=\"" + uuid + "\" />");
                out.println("<input type=\"hidden\" name=\"repNS\" value=\"" + ns + "\" />");
                out.println("<fieldset>");
                out.println("<legend>" + paramRequest.getLocaleString("msgVersionUpdate") + "</legend>");
                out.println("<table width=\"100%\" border=\"0\">");
                out.println("<tr>");
                out.println("<td>" + paramRequest.getLocaleString("msgTitle") + ":</td>");
                out.println("<td>" + nodo.getProperty("swb:title").getString() + "</td>");
                out.println("</tr>");
                out.println("<tr>");
                out.println("<td>" + paramRequest.getLocaleString("msgDescription") + ":</td>");
                out.println("<td>" + nodo.getProperty("swb:description").getString() + "</td>");
                out.println("</tr>");
                out.println("<tr>");
                out.println("<td>" + paramRequest.getLocaleString("msgFile") + ":</td>");
                out.println("<td>" + filename + " ver. " + vernum + "</td>");
                out.println("</tr>");
                out.println("<tr>");
                out.println("<td>" + paramRequest.getLocaleString("msgFileNewVerComm") + ":</td>");
                out.println("<td><textarea id=\"commentversion\" name=\"commentversion\" rows=\"5\" cols=\"20\"></textarea></td>");
                out.println("</tr>");
                out.println("<tr>");
                out.println("<td>" + paramRequest.getLocaleString("msgUpdatedFile") + ":</td>");
                out.println("<td><input type=\"file\" id=\"fileversion\" name=\"fileversion\" /></td>");
                out.println("</tr>");
                out.println("</table>");
                out.println("</fieldset>");
                out.println("<fieldset>");
                SWBResourceURL urlb = paramRequest.getRenderUrl();
                urlb.setMode("view");
                out.println("<input type=\"submit\" name=\"Actualizar\" value=\"" + paramRequest.getLocaleString("msgBTNUpdate") + "\"/>");
                out.println("<input type=\"button\" name=\"Cancelar\" onclick=\"window.location='" + urlb + "';\" value=\"" + paramRequest.getLocaleString("msgBTNCancel") + "\" />");
                out.println("</fieldset>");
                out.println("</form>");
                out.println("</div>");
            }
            catch (Exception e) {
                log.error("Error ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetFile(HttpServletRequest request, HttpServletResponse response, SWBParamRequest paramRequest) throws SWBResourceException, IOException {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        User user = paramRequest.getUser();
        String uuid = request.getParameter(PARAM_UUID);
        String uuidtoken = null;
        String ns = request.getParameter("repNS");
        String versionfile = request.getParameter("version");
        String filename = null;
        String qs = request.getRequestURI();
        if (uuid == null) {
            StringTokenizer stoken = new StringTokenizer(qs, "/");
            int c = stoken.countTokens();
            int contador = 0;
            while (stoken.hasMoreTokens()) {
                uuidtoken = stoken.nextToken();
                if (++contador != c - 1) continue;
            }
            if (stoken.hasMoreTokens()) {
                filename = stoken.nextToken();
            }
            if (filename.indexOf(".") > 0) {
                uuid = uuidtoken;
            }
        }
        if (ns == null) {
            ns = this.docRepNS(request, response, paramRequest);
        }
        String action = paramRequest.getAction();
        SWBCredentials credentials = new SWBCredentials(user);
        Session session = null;
        try {
            session = rep.login((Credentials)credentials, ns);
            Node nodo = session.getNodeByUUID(uuid);
            String faction = "";
            if (request.getParameter("faction") != null && request.getParameter("faction").trim().length() > 0) {
                faction = request.getParameter("faction");
            }
            filename = nodo.getName();
            String vernum = this.getLastVersionOfcontent(session, ns, uuid);
            if (versionfile != null && versionfile.trim().length() > 0) {
                vernum = versionfile;
            }
            String str_file = this.getContentFile(session, ns, uuid, vernum);
            Node nc = nodo.getNode(JCR_CONTENT);
            String mime = null;
            if (nc != null) {
                try {
                    mime = nc.getProperty("jcr:mimeType").getString();
                }
                catch (Exception e) {
                    mime = DEFAULT_MIME_TYPE;
                }
            }
            if (action != null && "inline".equals(action)) {
                response.setContentType(mime);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\";");
            }
            ServletOutputStream out = response.getOutputStream();
            SWBUtils.IO.copyStream((InputStream)SWBUtils.IO.getStreamFromString((String)str_file), (OutputStream)out);
        }
        catch (Exception e) {
            log.error("Error al obtener el archivo del Repositorio de documentos.", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public int getLevelUser(User user) {
        int level = 0;
        if (null == user) {
            return level;
        }
        String uriView = this.getSee() != null ? this.getSee() : "0";
        String uriModify = this.getModify() != null ? this.getModify() : "0";
        String uriAdmin = this.getAdmin() != null ? this.getAdmin() : "0";
        SemanticOntology ont = SWBPlatform.getSemanticMgr().getOntology();
        GenericObject gobj = null;
        try {
            gobj = ont.getGenericObject(uriAdmin);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UserGroup ugrp = null;
        Role urole = null;
        if (!uriAdmin.equals("0")) {
            if (gobj != null) {
                if (gobj instanceof UserGroup) {
                    ugrp = (UserGroup)gobj;
                    if (user.hasUserGroup(ugrp)) {
                        level = 3;
                    }
                } else if (gobj instanceof Role && user.hasRole(urole = (Role)gobj)) {
                    level = 3;
                }
            } else {
                level = 3;
            }
        } else {
            level = 3;
        }
        if (level == 0) {
            if (!uriModify.equals("0")) {
                gobj = ont.getGenericObject(uriModify);
                if (gobj != null) {
                    if (gobj instanceof UserGroup) {
                        ugrp = (UserGroup)gobj;
                        if (user.hasUserGroup(ugrp)) {
                            level = 2;
                        }
                    } else if (gobj instanceof Role && user.hasRole(urole = (Role)gobj)) {
                        level = 2;
                    }
                } else {
                    level = 2;
                }
            } else {
                level = 2;
            }
        }
        if (level == 0) {
            if (!uriView.equals("0")) {
                gobj = ont.getGenericObject(uriView);
                if (gobj != null) {
                    if (gobj instanceof UserGroup) {
                        ugrp = (UserGroup)gobj;
                        if (user.hasUserGroup(ugrp)) {
                            level = 1;
                        }
                    } else if (gobj instanceof Role && user.hasRole(urole = (Role)gobj)) {
                        level = 1;
                    }
                } else {
                    level = 1;
                }
            } else {
                level = 1;
            }
        }
        return level;
    }

    public String getFileType(String filename) {
        String file = "Document";
        String type = filename.toLowerCase();
        if (type.indexOf(".bmp") != -1) {
            file = "Image";
        } else if (type.indexOf(".pdf") != -1) {
            file = "Adobe Acrobat";
        } else if (type.indexOf(".xls") != -1 || type.indexOf(".xlsx") != -1) {
            file = "Microsoft Excel";
        } else if (type.indexOf(".html") != -1 || type.indexOf(".htm") != -1) {
            file = "HTML file";
        } else if (type.indexOf("jpg") != -1 || type.indexOf("jpeg") != -1) {
            file = "Image";
        } else if (type.indexOf(".ppt") != -1 || type.indexOf(".pptx") != -1) {
            file = "Microsoft Power Point";
        } else if (type.indexOf(".vsd") != -1) {
            file = "Microsoft Visio";
        } else if (type.indexOf(".mpp") != -1) {
            file = "Microsoft Project";
        } else if (type.indexOf(".mmap") != -1) {
            file = "Mind Manager";
        } else if (type.indexOf(".exe") != -1) {
            file = "Application";
        } else if (type.indexOf(".txt") != -1) {
            file = "Text file";
        } else if (type.indexOf(".properties") != -1) {
            file = "Properties file";
        } else if (type.indexOf(".doc") != -1 || type.indexOf(".docx") != -1) {
            file = "Microsoft Word";
        } else if (type.indexOf(".xml") != -1) {
            file = "XML file";
        } else if (type.indexOf(".gif") != -1 || type.indexOf(".png") != -1) {
            file = "Image";
        } else if (type.indexOf(".avi") != -1) {
            file = "Media file";
        } else if (type.indexOf(".mp3") != -1) {
            file = "Audio file";
        } else if (type.indexOf(".wav") != -1) {
            file = "Audio file";
        } else if (type.indexOf(".xsl") != -1) {
            file = "XSLT file";
        }
        return file;
    }

    public String getFileName(String filename) {
        String file = "ico_default2.gif";
        String type = filename.toLowerCase();
        if (type.indexOf(".bmp") != -1) {
            file = "ico_bmp.gif";
        } else if (type.indexOf(".pdf") != -1) {
            file = "ico_acrobat.gif";
        } else if (type.indexOf(".xls") != -1 || type.indexOf(".xlsx") != -1) {
            file = "ico_excel.gif";
        } else if (type.indexOf(".html") != -1 || type.indexOf(".htm") != -1) {
            file = "ico_html.gif";
        } else if (type.indexOf("jpg") != -1 || type.indexOf("jpeg") != -1) {
            file = "ico_jpeg.gif";
        } else if (type.indexOf(".ppt") != -1 || type.indexOf(".pptx") != -1) {
            file = "ico_powerpoint.gif";
        } else if (type.indexOf(".exe") != -1) {
            file = "ico_program.gif";
        } else if (type.indexOf(".txt") != -1 || type.indexOf(".properties") != -1) {
            file = "ico_text.gif";
        } else if (type.indexOf(".doc") != -1 || type.indexOf(".docx") != -1) {
            file = "ico_word.gif";
        } else if (type.indexOf(".xml") != -1 || type.indexOf(".xsl") != -1) {
            file = "ico_xml.gif";
        } else if (type.indexOf(".mmap") != -1) {
            file = "ico_mindmanager.GIF";
        } else if (type.indexOf(".gif") != -1) {
            file = "ico_gif.gif";
        } else if (type.indexOf(".avi") != -1) {
            file = "ico_video.gif";
        } else if (type.indexOf(".mp3") != -1) {
            file = "ico_audio.gif";
        } else if (type.indexOf(".wav") != -1) {
            file = "ico_audio.gif";
        }
        return file;
    }

    public String docRepNS(HttpServletRequest request, HttpServletResponse response, SWBParamRequest paramRequest) {
        String NS = this.IDREP;
        WebSite ws = paramRequest.getWebPage().getWebSite();
        try {
            String[] lws = rep.listWorkspaces();
            for (int i = 0; i < lws.length; ++i) {
                if (!lws[i].endsWith(ws.getId() + "_rep")) continue;
                NS = this.IDREP = lws[i];
                break;
            }
        }
        catch (Exception e) {
            log.error("Error al obtener el NameSpace del Repositorio de docuentos.", (Throwable)e);
        }
        return NS;
    }

    private String getLastVersionOfcontent(Session session, String repositoryName, String contentId) throws Exception {
        String getLastVersionOfcontent = null;
        ArrayList<Version> versions = new ArrayList<Version>();
        try {
            Node nodeContent = session.getNodeByUUID(contentId);
            Node resContent = nodeContent.getNode(JCR_CONTENT);
            VersionIterator it = resContent.getVersionHistory().getAllVersions();
            while (it.hasNext()) {
                Version version = it.nextVersion();
                if (version.getName().equals("jcr:rootVersion")) continue;
                versions.add(version);
            }
            for (Version version : versions) {
                if (getLastVersionOfcontent == null) {
                    getLastVersionOfcontent = version.getName();
                    continue;
                }
                try {
                    float currentVersion = Float.parseFloat(version.getName());
                    if (!(Float.parseFloat(getLastVersionOfcontent) < currentVersion)) continue;
                    getLastVersionOfcontent = version.getName();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        catch (ItemNotFoundException infe) {
            throw new Exception(CONTENT_NOT_FOUND, infe);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return getLastVersionOfcontent;
    }

    public String getContentFile(Session session, String repositoryName, String contentId, String version) throws Exception {
        try {
            Node nodeContent = session.getNodeByUUID(contentId);
            Node resContent = nodeContent.getNode(JCR_CONTENT);
            if (version != null && version.equals("*")) {
                String lastVersion = this.getLastVersionOfcontent(session, repositoryName, contentId);
                Version versionNode = resContent.getVersionHistory().getVersion(lastVersion);
                if (versionNode != null) {
                    Node frozenNode = versionNode.getNode(JCR_FROZEN_NODE);
                    String string = frozenNode.getProperty("jcr:data").getString();
                    return string;
                }
                String string = null;
                return string;
            }
            Version versionNode = resContent.getVersionHistory().getVersion(version);
            if (versionNode != null) {
                Node frozenNode = versionNode.getNode(JCR_FROZEN_NODE);
                String string = frozenNode.getProperty("jcr:data").getString();
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private String getLinkStyle() {
        StringBuilder ret = new StringBuilder();
        ret.append("\n<style type=\"text/css\">");
        ret.append("\n a:link {text-decoration: none}");
        ret.append("\n a:visited {text-decoration: none}");
        ret.append("\n a:active {text-decoration: none}");
        ret.append("\n a:hover {text-decoration: none}");
        ret.append("\n</style>");
        return ret.toString();
    }

    static {
        try {
            rep = new SWBRepository();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

