/*
 * Decompiled with CFR 0.152.
 */
package org.semanticwb.resources.filerepository.base;

import java.util.ArrayList;
import java.util.Iterator;
import org.semanticwb.SWBPlatform;
import org.semanticwb.model.Descriptiveable;
import org.semanticwb.model.GenericIterator;
import org.semanticwb.model.SWBModel;
import org.semanticwb.platform.SemanticClass;
import org.semanticwb.platform.SemanticLiteral;
import org.semanticwb.platform.SemanticObject;
import org.semanticwb.platform.SemanticProperty;
import org.semanticwb.repository.Folder;
import org.semanticwb.repository.Referenceable;
import org.semanticwb.repository.Traceable;
import org.semanticwb.resources.filerepository.RepositoryNode;

public class RepositoryNodeBase
extends Folder
implements Referenceable,
Descriptiveable,
Traceable {
    public static final SemanticProperty swb_title = SWBPlatform.getSemanticMgr().getVocabulary().getSemanticProperty("http://www.semanticwebbuilder.org/swb4/ontology#title");
    public static final SemanticProperty swbfilerep_hasUserGroupId = SWBPlatform.getSemanticMgr().getVocabulary().getSemanticProperty("http://www.semanticwebbuilder.org/filerepository#hasUserGroupId");
    public static final SemanticProperty jcr_uuid = SWBPlatform.getSemanticMgr().getVocabulary().getSemanticProperty("http://www.jcp.org/jcr/1.0#uuid");
    public static final SemanticProperty swbfilerep_hasUserId = SWBPlatform.getSemanticMgr().getVocabulary().getSemanticProperty("http://www.semanticwebbuilder.org/filerepository#hasUserId");
    public static final SemanticProperty swbfilerep_hasRoleId = SWBPlatform.getSemanticMgr().getVocabulary().getSemanticProperty("http://www.semanticwebbuilder.org/filerepository#hasRoleId");
    public static final SemanticProperty swb_description = SWBPlatform.getSemanticMgr().getVocabulary().getSemanticProperty("http://www.semanticwebbuilder.org/swb4/ontology#description");
    public static final SemanticClass swbfilerep_RepositoryNode = SWBPlatform.getSemanticMgr().getVocabulary().getSemanticClass("http://www.semanticwebbuilder.org/filerepository#RepositoryNode");
    public static final SemanticClass sclass = SWBPlatform.getSemanticMgr().getVocabulary().getSemanticClass("http://www.semanticwebbuilder.org/filerepository#RepositoryNode");

    public RepositoryNodeBase(SemanticObject base) {
        super(base);
    }

    public static Iterator<RepositoryNode> listRepositoryNodes(SWBModel model) {
        Iterator it = model.getSemanticObject().getModel().listInstancesOfClass(sclass);
        return new GenericIterator(it, true);
    }

    public static Iterator<RepositoryNode> listRepositoryNodes() {
        Iterator it = sclass.listInstances();
        return new GenericIterator(it, true);
    }

    public static RepositoryNode getRepositoryNode(String id, SWBModel model) {
        return (RepositoryNode)model.getSemanticObject().getModel().getGenericObject(model.getSemanticObject().getModel().getObjectUri(id, sclass), sclass);
    }

    public static RepositoryNode createRepositoryNode(String id, SWBModel model) {
        return (RepositoryNode)model.getSemanticObject().getModel().createGenericObject(model.getSemanticObject().getModel().getObjectUri(id, sclass), sclass);
    }

    public static void removeRepositoryNode(String id, SWBModel model) {
        model.getSemanticObject().getModel().removeSemanticObject(model.getSemanticObject().getModel().getObjectUri(id, sclass));
    }

    public static boolean hasRepositoryNode(String id, SWBModel model) {
        return RepositoryNodeBase.getRepositoryNode(id, model) != null;
    }

    public String getTitle() {
        return this.getSemanticObject().getProperty(swb_title);
    }

    public void setTitle(String title) {
        this.getSemanticObject().setProperty(swb_title, title);
    }

    public String getTitle(String lang) {
        return this.getSemanticObject().getProperty(swb_title, null, lang);
    }

    public String getDisplayTitle(String lang) {
        return this.getSemanticObject().getLocaleProperty(swb_title, lang);
    }

    public void setTitle(String title, String lang) {
        this.getSemanticObject().setProperty(swb_title, title, lang);
    }

    public Iterator<String> listUserGroupIds() {
        ArrayList<String> values = new ArrayList<String>();
        Iterator it = this.getSemanticObject().listLiteralProperties(swbfilerep_hasUserGroupId);
        while (it.hasNext()) {
            SemanticLiteral literal = (SemanticLiteral)it.next();
            values.add(literal.getString());
        }
        return values.iterator();
    }

    public void addUserGroupId(String usergroupid) {
        this.getSemanticObject().setProperty(swbfilerep_hasUserGroupId, usergroupid);
    }

    public void removeAllUserGroupId() {
        this.getSemanticObject().removeProperty(swbfilerep_hasUserGroupId);
    }

    public void removeUserGroupId(String usergroupid) {
        this.getSemanticObject().removeProperty(swbfilerep_hasUserGroupId, usergroupid);
    }

    public String getUuid() {
        return this.getSemanticObject().getProperty(jcr_uuid);
    }

    public void setUuid(String uuid) {
        this.getSemanticObject().setProperty(jcr_uuid, uuid);
    }

    public Iterator<String> listUserIds() {
        ArrayList<String> values = new ArrayList<String>();
        Iterator it = this.getSemanticObject().listLiteralProperties(swbfilerep_hasUserId);
        while (it.hasNext()) {
            SemanticLiteral literal = (SemanticLiteral)it.next();
            values.add(literal.getString());
        }
        return values.iterator();
    }

    public void addUserId(String userid) {
        this.getSemanticObject().setProperty(swbfilerep_hasUserId, userid);
    }

    public void removeAllUserId() {
        this.getSemanticObject().removeProperty(swbfilerep_hasUserId);
    }

    public void removeUserId(String userid) {
        this.getSemanticObject().removeProperty(swbfilerep_hasUserId, userid);
    }

    public Iterator<String> listRoleIds() {
        ArrayList<String> values = new ArrayList<String>();
        Iterator it = this.getSemanticObject().listLiteralProperties(swbfilerep_hasRoleId);
        while (it.hasNext()) {
            SemanticLiteral literal = (SemanticLiteral)it.next();
            values.add(literal.getString());
        }
        return values.iterator();
    }

    public void addRoleId(String roleid) {
        this.getSemanticObject().setProperty(swbfilerep_hasRoleId, roleid);
    }

    public void removeAllRoleId() {
        this.getSemanticObject().removeProperty(swbfilerep_hasRoleId);
    }

    public void removeRoleId(String roleid) {
        this.getSemanticObject().removeProperty(swbfilerep_hasRoleId, roleid);
    }

    public String getDescription() {
        return this.getSemanticObject().getProperty(swb_description);
    }

    public void setDescription(String description) {
        this.getSemanticObject().setProperty(swb_description, description);
    }

    public String getDescription(String lang) {
        return this.getSemanticObject().getProperty(swb_description, null, lang);
    }

    public String getDisplayDescription(String lang) {
        return this.getSemanticObject().getLocaleProperty(swb_description, lang);
    }

    public void setDescription(String description, String lang) {
        this.getSemanticObject().setProperty(swb_description, description, lang);
    }
}

