/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import org.simdjson.BitIndexes;
import org.simdjson.BlockReader;
import org.simdjson.JsonIterator;
import org.simdjson.JsonValue;
import org.simdjson.SchemaBasedJsonIterator;
import org.simdjson.StructuralIndexer;
import org.simdjson.Utf8Validator;

public class SimdJsonParser {
    private static final int STEP_SIZE = 64;
    private static final int PADDING = 64;
    private static final int DEFAULT_CAPACITY = 0x2200000;
    private static final int DEFAULT_MAX_DEPTH = 1024;
    private final BlockReader reader;
    private final StructuralIndexer indexer;
    private final BitIndexes bitIndexes;
    private final JsonIterator jsonIterator;
    private final SchemaBasedJsonIterator schemaBasedJsonIterator;
    private final byte[] paddedBuffer;

    public SimdJsonParser() {
        this(0x2200000, 1024);
    }

    public SimdJsonParser(int capacity, int maxDepth) {
        this.bitIndexes = new BitIndexes(capacity);
        byte[] stringBuffer = new byte[capacity];
        this.jsonIterator = new JsonIterator(this.bitIndexes, stringBuffer, capacity, maxDepth, 64);
        this.schemaBasedJsonIterator = new SchemaBasedJsonIterator(this.bitIndexes, stringBuffer, 64);
        this.paddedBuffer = new byte[capacity];
        this.reader = new BlockReader(64);
        this.indexer = new StructuralIndexer(this.bitIndexes);
    }

    public <T> T parse(byte[] buffer, int len, Class<T> expectedType) {
        this.stage0(buffer);
        byte[] padded = this.padIfNeeded(buffer, len);
        this.reset(padded, len);
        this.stage1(padded);
        return this.schemaBasedJsonIterator.walkDocument(padded, len, expectedType);
    }

    public JsonValue parse(byte[] buffer, int len) {
        this.stage0(buffer);
        byte[] padded = this.padIfNeeded(buffer, len);
        this.reset(padded, len);
        this.stage1(padded);
        return this.jsonIterator.walkDocument(padded, len);
    }

    private byte[] padIfNeeded(byte[] buffer, int len) {
        if (buffer.length - len < 64) {
            System.arraycopy(buffer, 0, this.paddedBuffer, 0, len);
            return this.paddedBuffer;
        }
        return buffer;
    }

    private void reset(byte[] buffer, int len) {
        this.indexer.reset();
        this.reader.reset(buffer, len);
        this.bitIndexes.reset();
        this.jsonIterator.reset();
    }

    private void stage0(byte[] buffer) {
        Utf8Validator.validate(buffer);
    }

    private void stage1(byte[] buffer) {
        while (this.reader.hasFullBlock()) {
            int blockIndex = this.reader.getBlockIndex();
            this.indexer.step(buffer, blockIndex, blockIndex);
            this.reader.advance();
        }
        this.indexer.step(this.reader.remainder(), 0, this.reader.getBlockIndex());
        this.reader.advance();
        this.indexer.finish(this.reader.getBlockIndex());
    }
}

