/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import jdk.incubator.vector.ByteVector;
import org.simdjson.CharacterUtils;
import org.simdjson.IntegerUtils;
import org.simdjson.JsonParsingException;
import org.simdjson.StructuralIndexer;

class StringParser {
    private static final byte BACKSLASH = 92;
    private static final byte QUOTE = 34;
    private static final int BYTES_PROCESSED = StructuralIndexer.BYTE_SPECIES.vectorByteSize();
    private static final int MIN_HIGH_SURROGATE = 55296;
    private static final int MAX_HIGH_SURROGATE = 56319;
    private static final int MIN_LOW_SURROGATE = 56320;
    private static final int MAX_LOW_SURROGATE = 57343;

    StringParser() {
    }

    int parseString(byte[] buffer, int idx, byte[] stringBuffer, int stringBufferIdx) {
        int dst = this.doParseString(buffer, idx, stringBuffer, stringBufferIdx + 4);
        int len = dst - stringBufferIdx - 4;
        IntegerUtils.toBytes(len, stringBuffer, stringBufferIdx);
        return dst;
    }

    int parseString(byte[] buffer, int idx, byte[] stringBuffer) {
        return this.doParseString(buffer, idx, stringBuffer, 0);
    }

    private int doParseString(byte[] buffer, int idx, byte[] stringBuffer, int offset) {
        long quoteBits;
        int src = idx + 1;
        int dst = offset;
        while (true) {
            ByteVector srcVec = ByteVector.fromArray(StructuralIndexer.BYTE_SPECIES, (byte[])buffer, (int)src);
            srcVec.intoArray(stringBuffer, dst);
            long backslashBits = srcVec.eq((byte)92).toLong();
            quoteBits = srcVec.eq((byte)34).toLong();
            if (this.hasQuoteFirst(backslashBits, quoteBits)) break;
            if (this.hasBackslash(backslashBits, quoteBits)) {
                int backslashDist = Long.numberOfTrailingZeros(backslashBits);
                byte escapeChar = buffer[src + backslashDist + 1];
                if (escapeChar == 117) {
                    dst += backslashDist;
                    int codePoint = CharacterUtils.hexToInt(buffer, (src += backslashDist) + 2);
                    src += 6;
                    if (codePoint >= 55296 && codePoint <= 56319) {
                        codePoint = this.parseLowSurrogate(buffer, src, codePoint);
                        src += 6;
                    } else if (codePoint >= 56320 && codePoint <= 57343) {
                        throw new JsonParsingException("Invalid code point. The range U+DC00\u2013U+DFFF is reserved for low surrogate.");
                    }
                    dst += this.storeCodePointInStringBuffer(codePoint, dst, stringBuffer);
                    continue;
                }
                stringBuffer[dst + backslashDist] = CharacterUtils.escape(escapeChar);
                src += backslashDist + 2;
                dst += backslashDist + 1;
                continue;
            }
            src += BYTES_PROCESSED;
            dst += BYTES_PROCESSED;
        }
        return dst += Long.numberOfTrailingZeros(quoteBits);
    }

    char parseChar(byte[] buffer, int startIdx) {
        char character;
        int idx = startIdx + 1;
        if (buffer[idx] == 92) {
            byte escapeChar = buffer[idx + 1];
            if (escapeChar == 117) {
                int codePoint = CharacterUtils.hexToInt(buffer, idx + 2);
                if (codePoint >= 55296 && codePoint <= 57343) {
                    throw new JsonParsingException("Invalid code point. Should be within the range U+0000\u2013U+D777 or U+E000\u2013U+FFFF.");
                }
                if (codePoint < 0) {
                    throw new JsonParsingException("Invalid unicode escape sequence.");
                }
                character = (char)codePoint;
                idx += 6;
            } else {
                character = (char)CharacterUtils.escape(escapeChar);
                idx += 2;
            }
        } else if (buffer[idx] >= 0) {
            character = (char)buffer[idx];
            ++idx;
        } else if ((buffer[idx] & 0xE0) == 192) {
            int codePoint = (buffer[idx] & 0x1F) << 6 | buffer[idx + 1] & 0x3F;
            character = (char)codePoint;
            idx += 2;
        } else if ((buffer[idx] & 0xF0) == 224) {
            int codePoint = (buffer[idx] & 0xF) << 12 | (buffer[idx + 1] & 0x3F) << 6 | buffer[idx + 2] & 0x3F;
            character = (char)codePoint;
            idx += 3;
        } else {
            throw new JsonParsingException("String cannot be deserialized to a char. Expected a single 16-bit code unit character.");
        }
        if (buffer[idx] != 34) {
            throw new JsonParsingException("String cannot be deserialized to a char. Expected a single-character string.");
        }
        return character;
    }

    private int parseLowSurrogate(byte[] buffer, int src, int codePoint) {
        if ((buffer[src] << 8 | buffer[src + 1]) != 23669) {
            throw new JsonParsingException("Low surrogate should start with '\\u'");
        }
        int codePoint2 = CharacterUtils.hexToInt(buffer, src + 2);
        int lowBit = codePoint2 - 56320;
        if (lowBit >> 10 == 0) {
            return (codePoint - 55296 << 10 | lowBit) + 65536;
        }
        throw new JsonParsingException("Invalid code point. Low surrogate should be in the range U+DC00\u2013U+DFFF.");
    }

    private int storeCodePointInStringBuffer(int codePoint, int dst, byte[] stringBuffer) {
        if (codePoint < 0) {
            throw new JsonParsingException("Invalid unicode escape sequence.");
        }
        if (codePoint <= 127) {
            stringBuffer[dst] = (byte)codePoint;
            return 1;
        }
        if (codePoint <= 2047) {
            stringBuffer[dst] = (byte)((codePoint >> 6) + 192);
            stringBuffer[dst + 1] = (byte)((codePoint & 0x3F) + 128);
            return 2;
        }
        if (codePoint <= 65535) {
            stringBuffer[dst] = (byte)((codePoint >> 12) + 224);
            stringBuffer[dst + 1] = (byte)((codePoint >> 6 & 0x3F) + 128);
            stringBuffer[dst + 2] = (byte)((codePoint & 0x3F) + 128);
            return 3;
        }
        if (codePoint <= 0x10FFFF) {
            stringBuffer[dst] = (byte)((codePoint >> 18) + 240);
            stringBuffer[dst + 1] = (byte)((codePoint >> 12 & 0x3F) + 128);
            stringBuffer[dst + 2] = (byte)((codePoint >> 6 & 0x3F) + 128);
            stringBuffer[dst + 3] = (byte)((codePoint & 0x3F) + 128);
            return 4;
        }
        throw new IllegalStateException("Code point is greater than 0x110000.");
    }

    private boolean hasQuoteFirst(long backslashBits, long quoteBits) {
        return (backslashBits - 1L & quoteBits) != 0L;
    }

    private boolean hasBackslash(long backslashBits, long quoteBits) {
        return (quoteBits - 1L & backslashBits) != 0L;
    }
}

