/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorShape;
import jdk.incubator.vector.VectorSpecies;
import org.simdjson.BitIndexes;
import org.simdjson.CharactersClassifier;
import org.simdjson.JsonCharacterBlock;
import org.simdjson.JsonParsingException;
import org.simdjson.JsonStringBlock;
import org.simdjson.JsonStringScanner;

class StructuralIndexer {
    static final VectorSpecies<Integer> INT_SPECIES;
    static final VectorSpecies<Byte> BYTE_SPECIES;
    static final int N_CHUNKS;
    private final JsonStringScanner stringScanner = new JsonStringScanner();
    private final CharactersClassifier classifier = new CharactersClassifier();
    private final BitIndexes bitIndexes;
    private long prevStructurals = 0L;
    private long unescapedCharsError = 0L;
    private long prevScalar = 0L;

    private static void assertSupportForSpecies(VectorSpecies<?> species) {
        if (species.vectorShape() != VectorShape.S_256_BIT && species.vectorShape() != VectorShape.S_512_BIT) {
            throw new IllegalArgumentException("Unsupported vector species: " + species);
        }
    }

    StructuralIndexer(BitIndexes bitIndexes) {
        this.bitIndexes = bitIndexes;
    }

    void step(byte[] buffer, int offset, int blockIndex) {
        switch (N_CHUNKS) {
            case 1: {
                this.step1(buffer, offset, blockIndex);
                break;
            }
            case 2: {
                this.step2(buffer, offset, blockIndex);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported vector width: " + N_CHUNKS * 64);
            }
        }
    }

    private void step1(byte[] buffer, int offset, int blockIndex) {
        ByteVector chunk0 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_512, (byte[])buffer, (int)offset);
        JsonStringBlock strings = this.stringScanner.next(chunk0);
        JsonCharacterBlock characters = this.classifier.classify(chunk0);
        long unescaped = this.lteq(chunk0, (byte)31);
        this.finishStep(characters, strings, unescaped, blockIndex);
    }

    private void step2(byte[] buffer, int offset, int blockIndex) {
        ByteVector chunk0 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])buffer, (int)offset);
        ByteVector chunk1 = ByteVector.fromArray((VectorSpecies)ByteVector.SPECIES_256, (byte[])buffer, (int)(offset + 32));
        JsonStringBlock strings = this.stringScanner.next(chunk0, chunk1);
        JsonCharacterBlock characters = this.classifier.classify(chunk0, chunk1);
        long unescaped = this.lteq(chunk0, chunk1, (byte)31);
        this.finishStep(characters, strings, unescaped, blockIndex);
    }

    private void finishStep(JsonCharacterBlock characters, JsonStringBlock strings, long unescaped, int blockIndex) {
        long scalar = characters.scalar();
        long nonQuoteScalar = scalar & (strings.quote() ^ 0xFFFFFFFFFFFFFFFFL);
        long followsNonQuoteScalar = nonQuoteScalar << 1 | this.prevScalar;
        this.prevScalar = nonQuoteScalar >>> 63;
        long potentialScalarStart = scalar & (followsNonQuoteScalar ^ 0xFFFFFFFFFFFFFFFFL);
        long potentialStructuralStart = characters.op() | potentialScalarStart;
        this.bitIndexes.write(blockIndex, this.prevStructurals);
        this.prevStructurals = potentialStructuralStart & (strings.stringTail() ^ 0xFFFFFFFFFFFFFFFFL);
        this.unescapedCharsError |= strings.nonQuoteInsideString(unescaped);
    }

    private long lteq(ByteVector chunk0, byte scalar) {
        return chunk0.compare(VectorOperators.UNSIGNED_LE, scalar).toLong();
    }

    private long lteq(ByteVector chunk0, ByteVector chunk1, byte scalar) {
        long r0 = chunk0.compare(VectorOperators.UNSIGNED_LE, scalar).toLong();
        long r1 = chunk1.compare(VectorOperators.UNSIGNED_LE, scalar).toLong();
        return r0 | r1 << 32;
    }

    void finish(int blockIndex) {
        this.bitIndexes.write(blockIndex, this.prevStructurals);
        this.bitIndexes.finish();
        this.stringScanner.finish();
        if (this.unescapedCharsError != 0L) {
            throw new JsonParsingException("Unescaped characters. Within strings, there are characters that should be escaped.");
        }
    }

    void reset() {
        this.stringScanner.reset();
        this.prevStructurals = 0L;
        this.unescapedCharsError = 0L;
        this.prevScalar = 0L;
    }

    static {
        String species;
        switch (species = System.getProperty("org.simdjson.species", "preferred")) {
            case "preferred": {
                BYTE_SPECIES = ByteVector.SPECIES_PREFERRED;
                INT_SPECIES = IntVector.SPECIES_PREFERRED;
                break;
            }
            case "512": {
                BYTE_SPECIES = ByteVector.SPECIES_512;
                INT_SPECIES = IntVector.SPECIES_512;
                break;
            }
            case "256": {
                BYTE_SPECIES = ByteVector.SPECIES_256;
                INT_SPECIES = IntVector.SPECIES_256;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported vector species: " + species);
            }
        }
        N_CHUNKS = 64 / BYTE_SPECIES.vectorByteSize();
        StructuralIndexer.assertSupportForSpecies(BYTE_SPECIES);
        StructuralIndexer.assertSupportForSpecies(INT_SPECIES);
    }
}

