/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.util.Arrays;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorShuffle;
import jdk.incubator.vector.VectorSpecies;
import org.simdjson.JsonParsingException;
import org.simdjson.StructuralIndexer;

class Utf8Validator {
    private static final VectorSpecies<Byte> VECTOR_SPECIES = StructuralIndexer.BYTE_SPECIES;
    private static final ByteVector INCOMPLETE_CHECK = Utf8Validator.getIncompleteCheck();
    private static final VectorShuffle<Integer> SHIFT_FOUR_BYTES_FORWARD = VectorShuffle.iota(StructuralIndexer.INT_SPECIES, (int)(StructuralIndexer.INT_SPECIES.elementSize() - 1), (int)1, (boolean)true);
    private static final ByteVector LOW_NIBBLE_MASK = ByteVector.broadcast(VECTOR_SPECIES, (long)15L);
    private static final ByteVector ALL_ASCII_MASK = ByteVector.broadcast(VECTOR_SPECIES, (byte)-128);

    Utf8Validator() {
    }

    static void validate(byte[] inputBytes) {
        int idx;
        long previousIncomplete = 0L;
        long errors = 0L;
        int previousFourUtf8Bytes = 0;
        for (idx = 0; idx < VECTOR_SPECIES.loopBound(inputBytes.length); idx += VECTOR_SPECIES.vectorByteSize()) {
            ByteVector utf8Vector = ByteVector.fromArray(VECTOR_SPECIES, (byte[])inputBytes, (int)idx);
            if (Utf8Validator.isAscii(utf8Vector)) {
                errors |= previousIncomplete;
            } else {
                previousIncomplete = Utf8Validator.isIncomplete(utf8Vector);
                IntVector fourBytesPrevious = Utf8Validator.fourBytesPreviousSlice(utf8Vector, previousFourUtf8Bytes);
                ByteVector firstCheck = Utf8Validator.firstTwoByteSequenceCheck(utf8Vector.reinterpretAsInts(), fourBytesPrevious);
                ByteVector secondCheck = Utf8Validator.lastTwoByteSequenceCheck(utf8Vector.reinterpretAsInts(), fourBytesPrevious, firstCheck);
                errors |= secondCheck.compare(VectorOperators.NE, 0L).toLong();
            }
            previousFourUtf8Bytes = utf8Vector.reinterpretAsInts().lane(StructuralIndexer.INT_SPECIES.length() - 1);
        }
        VectorMask remainingBytes = VECTOR_SPECIES.indexInRange(idx, inputBytes.length);
        ByteVector lastVectorChunk = ByteVector.fromArray(VECTOR_SPECIES, (byte[])inputBytes, (int)idx, (VectorMask)remainingBytes);
        if (!Utf8Validator.isAscii(lastVectorChunk)) {
            previousIncomplete = Utf8Validator.isIncomplete(lastVectorChunk);
            IntVector fourBytesPrevious = Utf8Validator.fourBytesPreviousSlice(lastVectorChunk, previousFourUtf8Bytes);
            ByteVector firstCheck = Utf8Validator.firstTwoByteSequenceCheck(lastVectorChunk.reinterpretAsInts(), fourBytesPrevious);
            ByteVector secondCheck = Utf8Validator.lastTwoByteSequenceCheck(lastVectorChunk.reinterpretAsInts(), fourBytesPrevious, firstCheck);
            errors |= secondCheck.compare(VectorOperators.NE, 0L).toLong();
        }
        if ((errors | previousIncomplete) != 0L) {
            throw new JsonParsingException("Invalid UTF8");
        }
    }

    private static IntVector fourBytesPreviousSlice(ByteVector vectorChunk, int previousFourUtf8Bytes) {
        return vectorChunk.reinterpretAsInts().rearrange(SHIFT_FOUR_BYTES_FORWARD).withLane(0, previousFourUtf8Bytes);
    }

    private static ByteVector previousVectorSlice(IntVector utf8Vector, IntVector fourBytesPrevious, int numOfPreviousBytes) {
        return utf8Vector.lanewise(VectorOperators.LSHL, 8 * numOfPreviousBytes).or((Vector)fourBytesPrevious.lanewise(VectorOperators.LSHR, 8 * (4 - numOfPreviousBytes))).reinterpretAsBytes();
    }

    private static ByteVector firstTwoByteSequenceCheck(IntVector utf8Vector, IntVector fourBytesPrevious) {
        ByteVector oneBytePrevious = Utf8Validator.previousVectorSlice(utf8Vector, fourBytesPrevious, 1);
        ByteVector byte2HighNibbles = utf8Vector.lanewise(VectorOperators.LSHR, 4).reinterpretAsBytes().and((Vector)LOW_NIBBLE_MASK);
        ByteVector byte1HighNibbles = oneBytePrevious.reinterpretAsInts().lanewise(VectorOperators.LSHR, 4).reinterpretAsBytes().and((Vector)LOW_NIBBLE_MASK);
        ByteVector byte1LowNibbles = oneBytePrevious.and((Vector)LOW_NIBBLE_MASK);
        ByteVector byte1HighState = byte1HighNibbles.selectFrom((Vector)LookupTable.byte1High);
        ByteVector byte1LowState = byte1LowNibbles.selectFrom((Vector)LookupTable.byte1Low);
        ByteVector byte2HighState = byte2HighNibbles.selectFrom((Vector)LookupTable.byte2High);
        return byte1HighState.and((Vector)byte1LowState).and((Vector)byte2HighState);
    }

    private static ByteVector lastTwoByteSequenceCheck(IntVector utf8Vector, IntVector fourBytesPrevious, ByteVector firstCheck) {
        ByteVector twoBytesPrevious = Utf8Validator.previousVectorSlice(utf8Vector, fourBytesPrevious, 2);
        VectorMask is3ByteLead = twoBytesPrevious.compare(VectorOperators.UNSIGNED_GT, (byte)-33);
        ByteVector threeBytesPrevious = Utf8Validator.previousVectorSlice(utf8Vector, fourBytesPrevious, 3);
        VectorMask is4ByteLead = threeBytesPrevious.compare(VectorOperators.UNSIGNED_GT, (byte)-17);
        return firstCheck.add((byte)-128, is3ByteLead.or(is4ByteLead));
    }

    private static ByteVector getIncompleteCheck() {
        int vectorBytes = VECTOR_SPECIES.vectorByteSize();
        byte[] eofArray = new byte[vectorBytes];
        Arrays.fill(eofArray, (byte)-1);
        eofArray[vectorBytes - 3] = -16;
        eofArray[vectorBytes - 2] = -32;
        eofArray[vectorBytes - 1] = -64;
        return ByteVector.fromArray(VECTOR_SPECIES, (byte[])eofArray, (int)0);
    }

    private static long isIncomplete(ByteVector utf8Vector) {
        return utf8Vector.compare(VectorOperators.UNSIGNED_GE, (Vector)INCOMPLETE_CHECK).toLong();
    }

    private static boolean isAscii(ByteVector utf8Vector) {
        return utf8Vector.and((Vector)ALL_ASCII_MASK).compare(VectorOperators.EQ, 0L).allTrue();
    }

    private static class LookupTable {
        static final byte TOO_SHORT = 1;
        static final byte TOO_LONG = 2;
        static final byte OVERLONG_3BYTE = 4;
        static final byte TOO_LARGE = 8;
        static final byte SURROGATE = 16;
        static final byte OVERLONG_2BYTE = 32;
        static final byte TOO_LARGE_1000 = 64;
        static final byte OVERLONG_4BYTE = 64;
        static final byte TWO_CONTINUATIONS = -128;
        private static final ByteVector byte1High = LookupTable.getByte1HighLookup();
        private static final ByteVector byte1Low = LookupTable.getByte1LowLookup();
        private static final ByteVector byte2High = LookupTable.getByte2HighLookup();

        private LookupTable() {
        }

        private static ByteVector getByte1HighLookup() {
            byte[] byte1HighArray = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, -128, -128, -128, -128, 33, 1, 21, 73};
            return LookupTable.alignArrayToVector(byte1HighArray);
        }

        private static ByteVector alignArrayToVector(byte[] arrayValues) {
            byte[] alignedArray = new byte[VECTOR_SPECIES.vectorByteSize()];
            System.arraycopy(arrayValues, 0, alignedArray, 0, arrayValues.length);
            return ByteVector.fromArray(VECTOR_SPECIES, (byte[])alignedArray, (int)0);
        }

        private static ByteVector getByte1LowLookup() {
            int CARRY = -125;
            byte[] byte1LowArray = new byte[]{-25, -93, -125, -125, -117, -53, -53, -53, -53, -53, -53, -53, -53, -37, -53, -53};
            return LookupTable.alignArrayToVector(byte1LowArray);
        }

        private static ByteVector getByte2HighLookup() {
            byte[] byte2HighArray = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, -26, -82, -70, -70, 1, 1, 1, 1};
            return LookupTable.alignArrayToVector(byte2HighArray);
        }
    }
}

