/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

class BitIndexes {
    private final int[] indexes;
    private int writeIdx;
    private int readIdx;

    BitIndexes(int capacity) {
        this.indexes = new int[capacity];
    }

    void write(int blockIndex, long bits) {
        int i;
        if (bits == 0L) {
            return;
        }
        int idx = blockIndex - 64;
        int cnt = Long.bitCount(bits);
        for (i = 0; i < 8; ++i) {
            this.indexes[i + this.writeIdx] = idx + Long.numberOfTrailingZeros(bits);
            bits = this.clearLowestBit(bits);
        }
        if (cnt > 8) {
            for (i = 8; i < 16; ++i) {
                this.indexes[i + this.writeIdx] = idx + Long.numberOfTrailingZeros(bits);
                bits = this.clearLowestBit(bits);
            }
            if (cnt > 16) {
                i = 16;
                do {
                    this.indexes[i + this.writeIdx] = idx + Long.numberOfTrailingZeros(bits);
                    bits = this.clearLowestBit(bits);
                } while (++i < cnt);
            }
        }
        this.writeIdx += cnt;
    }

    private long clearLowestBit(long bits) {
        return bits & bits - 1L;
    }

    void advance() {
        ++this.readIdx;
    }

    int getAndAdvance() {
        assert (this.readIdx <= this.writeIdx);
        return this.indexes[this.readIdx++];
    }

    int getLast() {
        return this.indexes[this.writeIdx - 1];
    }

    int advanceAndGet() {
        assert (this.readIdx + 1 <= this.writeIdx);
        return this.indexes[++this.readIdx];
    }

    int peek() {
        assert (this.readIdx <= this.writeIdx);
        return this.indexes[this.readIdx];
    }

    boolean hasNext() {
        return this.writeIdx > this.readIdx;
    }

    boolean isEnd() {
        return this.writeIdx == this.readIdx;
    }

    boolean isPastEnd() {
        return this.readIdx > this.writeIdx;
    }

    void finish() {
        this.indexes[this.writeIdx] = 0;
    }

    void reset() {
        this.writeIdx = 0;
        this.readIdx = 0;
    }
}

