/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import org.simdjson.ExponentParser;
import org.simdjson.NumberParserTables;

class DoubleParser {
    private static final int FAST_PATH_MAX_DIGIT_COUNT = 19;
    private static final int FAST_PATH_MIN_POWER_OF_TEN = -342;
    private static final int FAST_PATH_MAX_POWER_OF_TEN = 308;
    private static final double[] POWERS_OF_TEN = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final long MAX_LONG_REPRESENTED_AS_DOUBLE_EXACTLY = 0x1FFFFFFFFFFFFFL;
    private static final int IEEE64_EXPONENT_BIAS = 1023;
    private static final int IEEE64_SIGN_BIT_INDEX = 63;
    private static final int IEEE64_SIGNIFICAND_EXPLICIT_BIT_COUNT = 52;
    private static final int IEEE64_SIGNIFICAND_SIZE_IN_BITS = 53;
    private static final int IEEE64_MAX_FINITE_NUMBER_EXPONENT = 1023;
    private static final int IEEE64_MIN_FINITE_NUMBER_EXPONENT = -1022;
    private static final int IEEE64_SUBNORMAL_EXPONENT = -1023;
    private static final int SLOW_PATH_MAX_DIGIT_COUNT = 800;
    private static final int SLOW_PATH_MAX_SHIFT = 60;
    private static final byte[] SLOW_PATH_SHIFTS = new byte[]{0, 3, 6, 9, 13, 16, 19, 23, 26, 29, 33, 36, 39, 43, 46, 49, 53, 56, 59};
    private static final long MULTIPLICATION_MASK = 511L;
    private final SlowPathDecimal slowPathDecimal = new SlowPathDecimal();
    private final ExponentParser exponentParser = new ExponentParser();

    DoubleParser() {
    }

    double parse(byte[] buffer, int offset, boolean negative, int digitsStartIdx, int digitCount, long digits, long exponent) {
        if (DoubleParser.shouldBeHandledBySlowPath(buffer, digitsStartIdx, digitCount)) {
            return this.slowlyParseDouble(buffer, offset);
        }
        return DoubleParser.computeDouble(negative, digits, exponent);
    }

    private static boolean shouldBeHandledBySlowPath(byte[] buffer, int startDigitsIdx, int digitCount) {
        if (digitCount <= 19) {
            return false;
        }
        int start = startDigitsIdx;
        while (buffer[start] == 48 || buffer[start] == 46) {
            ++start;
        }
        int significantDigitCount = digitCount - (start - startDigitsIdx);
        return significantDigitCount > 19;
    }

    private static double computeDouble(boolean negative, long significand10, long exp10) {
        long secondUpper;
        if (Math.abs(exp10) < (long)POWERS_OF_TEN.length && Long.compareUnsigned(significand10, 0x1FFFFFFFFFFFFFL) <= 0) {
            double result = significand10;
            result = exp10 < 0L ? (result /= POWERS_OF_TEN[(int)(-exp10)]) : (result *= POWERS_OF_TEN[(int)exp10]);
            return negative ? -result : result;
        }
        if (exp10 < -342L || significand10 == 0L) {
            return DoubleParser.zero(negative);
        }
        if (exp10 > 308L) {
            return DoubleParser.infinity(negative);
        }
        int lz = Long.numberOfLeadingZeros(significand10);
        int powersOfFiveTableIndex = 2 * (int)(exp10 - -342L);
        long upper = Math.unsignedMultiplyHigh(significand10 <<= lz, NumberParserTables.POWERS_OF_FIVE[powersOfFiveTableIndex]);
        long lower = significand10 * NumberParserTables.POWERS_OF_FIVE[powersOfFiveTableIndex];
        if ((upper & 0x1FFL) == 511L && Long.compareUnsigned(secondUpper = Math.unsignedMultiplyHigh(significand10, NumberParserTables.POWERS_OF_FIVE[powersOfFiveTableIndex + 1]), lower += secondUpper) > 0) {
            ++upper;
        }
        long upperBit = upper >>> 63;
        long upperShift = upperBit + 9L;
        long significand2 = upper >>> (int)upperShift;
        long exp2 = (217706L * exp10 >> 16) + 63L - (long)lz + upperBit;
        if (exp2 < -1022L) {
            if (exp2 <= -1086L) {
                return DoubleParser.zero(negative);
            }
            significand2 >>= (int)(-1022L - exp2);
            significand2 += significand2 & 1L;
            exp2 = (significand2 >>= 1) < 0x10000000000000L ? -1023L : -1022L;
            return DoubleParser.toDouble(negative, significand2, exp2);
        }
        if (exp10 >= -4L && exp10 <= 23L && significand2 << (int)upperShift == upper && Long.compareUnsigned(lower, 1L) <= 0 && (significand2 & 3L) == 1L) {
            significand2 &= 0xFFFFFFFFFFFFFFFEL;
        }
        significand2 += significand2 & 1L;
        if ((significand2 >>= 1) == 0x20000000000000L) {
            significand2 >>= 1;
            ++exp2;
        }
        if (exp2 > 1023L) {
            return DoubleParser.infinity(negative);
        }
        return DoubleParser.toDouble(negative, significand2, exp2);
    }

    private static double toDouble(boolean negative, long significand2, long exp2) {
        long bits = significand2;
        bits &= 0xFFEFFFFFFFFFFFFFL;
        bits = negative ? bits | Long.MIN_VALUE : (bits |= exp2 + 1023L << 52);
        return Double.longBitsToDouble(bits);
    }

    private static double infinity(boolean negative) {
        return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    private static double zero(boolean negative) {
        return negative ? -0.0 : 0.0;
    }

    private double slowlyParseDouble(byte[] buffer, int offset) {
        int shift;
        SlowPathDecimal decimal = this.slowPathDecimal;
        decimal.reset();
        decimal.negative = buffer[offset] == 45;
        int currentIdx = decimal.negative ? offset + 1 : offset;
        long exp10 = 0L;
        currentIdx = this.skipZeros(buffer, currentIdx);
        currentIdx = this.parseDigits(buffer, decimal, currentIdx);
        if (buffer[currentIdx] == 46) {
            int firstIdxAfterPeriod = ++currentIdx;
            if (decimal.digitCount == 0) {
                currentIdx = this.skipZeros(buffer, currentIdx);
            }
            currentIdx = this.parseDigits(buffer, decimal, currentIdx);
            exp10 = firstIdxAfterPeriod - currentIdx;
        }
        int currentIdxMovingBackwards = currentIdx - 1;
        int trailingZeros = 0;
        while (buffer[currentIdxMovingBackwards] == 48 || buffer[currentIdxMovingBackwards] == 46) {
            if (buffer[currentIdxMovingBackwards] == 48) {
                ++trailingZeros;
            }
            --currentIdxMovingBackwards;
        }
        exp10 += (long)decimal.digitCount;
        decimal.digitCount -= trailingZeros;
        if (decimal.digitCount > 800) {
            decimal.digitCount = 800;
            decimal.truncated = true;
        }
        if (ExponentParser.isExponentIndicator(buffer[currentIdx])) {
            exp10 = this.exponentParser.parse(buffer, ++currentIdx, exp10).exponent();
        }
        if (exp10 <= -324L) {
            return DoubleParser.zero(decimal.negative);
        }
        if (exp10 >= 310L) {
            return DoubleParser.infinity(decimal.negative);
        }
        decimal.exp10 = (int)exp10;
        int exp2 = 0;
        while (decimal.exp10 > 0) {
            shift = DoubleParser.resolveShiftDistanceBasedOnExponent10(decimal.exp10);
            decimal.shiftRight(shift);
            exp2 += shift;
        }
        while (decimal.exp10 <= 0) {
            if (decimal.exp10 == 0) {
                if (decimal.digits[0] >= 5) break;
                shift = decimal.digits[0] < 2 ? 2 : 1;
            } else {
                shift = DoubleParser.resolveShiftDistanceBasedOnExponent10(-decimal.exp10);
            }
            decimal.shiftLeft(shift);
            exp2 -= shift;
        }
        --exp2;
        while (-1022 > exp2) {
            int n = -1022 - exp2;
            if (n > 60) {
                n = 60;
            }
            decimal.shiftRight(n);
            exp2 += n;
        }
        decimal.shiftLeft(53);
        long significand2 = decimal.computeSignificand();
        if (significand2 >= 0x20000000000000L) {
            significand2 >>= 1;
            ++exp2;
        }
        if (significand2 < 0x10000000000000L) {
            exp2 = -1023;
        }
        if (exp2 > 1023) {
            return DoubleParser.infinity(decimal.negative);
        }
        return DoubleParser.toDouble(decimal.negative, significand2, exp2);
    }

    private static int resolveShiftDistanceBasedOnExponent10(int exp10) {
        return exp10 < SLOW_PATH_SHIFTS.length ? SLOW_PATH_SHIFTS[exp10] : 60;
    }

    private int skipZeros(byte[] buffer, int currentIdx) {
        while (buffer[currentIdx] == 48) {
            ++currentIdx;
        }
        return currentIdx;
    }

    private int parseDigits(byte[] buffer, SlowPathDecimal decimal, int currentIdx) {
        while (DoubleParser.isDigit(buffer[currentIdx])) {
            if (decimal.digitCount < 800) {
                decimal.digits[decimal.digitCount] = DoubleParser.convertCharacterToDigit(buffer[currentIdx]);
            }
            ++decimal.digitCount;
            ++currentIdx;
        }
        return currentIdx;
    }

    private static byte convertCharacterToDigit(byte b) {
        return (byte)(b - 48);
    }

    private static boolean isDigit(byte b) {
        return b >= 48 && b <= 57;
    }

    private static class SlowPathDecimal {
        final byte[] digits = new byte[800];
        int digitCount;
        int exp10;
        boolean truncated;
        boolean negative;

        private SlowPathDecimal() {
        }

        long computeSignificand() {
            if (this.digitCount == 0 || this.exp10 < 0) {
                return 0L;
            }
            long significand = 0L;
            for (int i = 0; i < this.exp10; ++i) {
                significand = 10L * significand + (long)(i < this.digitCount ? this.digits[i] : 0);
            }
            boolean roundUp = false;
            if (this.exp10 < this.digitCount) {
                boolean bl = roundUp = this.digits[this.exp10] >= 5;
                if (this.digits[this.exp10] == 5 && this.exp10 + 1 == this.digitCount) {
                    roundUp = this.truncated || (significand & 1L) == 1L;
                }
            }
            return roundUp ? (significand = significand + 1L) : significand;
        }

        void shiftLeft(int shift) {
            long remainder;
            long quotient;
            if (this.digitCount == 0) {
                return;
            }
            int numberOfAdditionalDigits = this.calculateNumberOfAdditionalDigitsAfterLeftShift(shift);
            int writeIndex = this.digitCount - 1 + numberOfAdditionalDigits;
            long n = 0L;
            for (int readIndex = this.digitCount - 1; readIndex >= 0; --readIndex) {
                quotient = Long.divideUnsigned(n += (long)this.digits[readIndex] << shift, 10L);
                remainder = Long.remainderUnsigned(n, 10L);
                if (writeIndex < 800) {
                    this.digits[writeIndex] = (byte)remainder;
                } else if (remainder > 0L) {
                    this.truncated = true;
                }
                n = quotient;
                --writeIndex;
            }
            while (Long.compareUnsigned(n, 0L) > 0) {
                quotient = Long.divideUnsigned(n, 10L);
                remainder = Long.remainderUnsigned(n, 10L);
                if (writeIndex < 800) {
                    this.digits[writeIndex] = (byte)remainder;
                } else if (remainder > 0L) {
                    this.truncated = true;
                }
                n = quotient;
                --writeIndex;
            }
            this.digitCount += numberOfAdditionalDigits;
            if (this.digitCount > 800) {
                this.digitCount = 800;
            }
            this.exp10 += numberOfAdditionalDigits;
            this.trimTrailingZeros();
        }

        private int calculateNumberOfAdditionalDigitsAfterLeftShift(int shift) {
            int a = NumberParserTables.NUMBER_OF_ADDITIONAL_DIGITS_AFTER_LEFT_SHIFT[shift];
            int b = NumberParserTables.NUMBER_OF_ADDITIONAL_DIGITS_AFTER_LEFT_SHIFT[shift + 1];
            int newDigitCount = a >> 11;
            int pow5OffsetA = 0x7FF & a;
            int pow5OffsetB = 0x7FF & b;
            int n = pow5OffsetB - pow5OffsetA;
            for (int i = 0; i < n; ++i) {
                if (i >= this.digitCount) {
                    return newDigitCount - 1;
                }
                if (this.digits[i] < NumberParserTables.POWER_OF_FIVE_DIGITS[pow5OffsetA + i]) {
                    return newDigitCount - 1;
                }
                if (this.digits[i] <= NumberParserTables.POWER_OF_FIVE_DIGITS[pow5OffsetA + i]) continue;
                return newDigitCount;
            }
            return newDigitCount;
        }

        void shiftRight(int shift) {
            byte newDigit;
            int readIndex = 0;
            int writeIndex = 0;
            long n = 0L;
            while (n >>> shift == 0L) {
                if (readIndex < this.digitCount) {
                    n = 10L * n + (long)this.digits[readIndex++];
                    continue;
                }
                if (n == 0L) {
                    return;
                }
                while (n >>> shift == 0L) {
                    n = 10L * n;
                    ++readIndex;
                }
                break block0;
            }
            this.exp10 -= readIndex - 1;
            long mask = (1L << shift) - 1L;
            while (readIndex < this.digitCount) {
                newDigit = (byte)(n >>> shift);
                n = 10L * (n & mask) + (long)this.digits[readIndex++];
                this.digits[writeIndex++] = newDigit;
            }
            while (Long.compareUnsigned(n, 0L) > 0) {
                newDigit = (byte)(n >>> shift);
                n = 10L * (n & mask);
                if (writeIndex < 800) {
                    this.digits[writeIndex++] = newDigit;
                    continue;
                }
                if (newDigit <= 0) continue;
                this.truncated = true;
            }
            this.digitCount = writeIndex;
            this.trimTrailingZeros();
        }

        private void trimTrailingZeros() {
            while (this.digitCount > 0 && this.digits[this.digitCount - 1] == 0) {
                --this.digitCount;
            }
        }

        private void reset() {
            this.digitCount = 0;
            this.exp10 = 0;
            this.truncated = false;
        }
    }
}

