/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.simdjson.ClassResolver;
import org.simdjson.ConstructorArgument;
import org.simdjson.ConstructorArgumentsMap;
import org.simdjson.JsonParsingException;
import org.simdjson.annotations.JsonFieldName;

class ResolvedClass {
    private final ResolvedClassCategory classCategory;
    private final Class<?> rawClass;
    private final ResolvedClass elementClass;
    private final Constructor<?> constructor;
    private final ConstructorArgumentsMap argumentsMap;

    ResolvedClass(Type targetType, ClassResolver classResolver) {
        if (targetType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)targetType;
            this.rawClass = (Class)parameterizedType.getRawType();
            this.elementClass = ResolvedClass.resolveElementClass(parameterizedType, classResolver);
        } else {
            this.rawClass = (Class)targetType;
            this.elementClass = ResolvedClass.resolveElementClass(this.rawClass, classResolver);
        }
        this.classCategory = ResolvedClass.resolveClassType(this.rawClass);
        if (this.classCategory == ResolvedClassCategory.CUSTOM) {
            ResolvedClass.checkIfCustomClassIsSupported(this.rawClass);
            this.constructor = this.rawClass.getDeclaredConstructors()[0];
            this.constructor.setAccessible(true);
            Parameter[] parameters = this.constructor.getParameters();
            this.argumentsMap = new ConstructorArgumentsMap(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                Type parameterType = parameters[i].getAnnotatedType().getType();
                String fieldName = ResolvedClass.resolveFieldName(parameters[i], this.rawClass);
                byte[] fieldNameBytes = fieldName.getBytes(StandardCharsets.UTF_8);
                this.argumentsMap.put(fieldNameBytes, new ConstructorArgument(i, classResolver.resolveClass(parameterType)));
            }
        } else {
            this.constructor = null;
            this.argumentsMap = null;
        }
    }

    private static ResolvedClass resolveElementClass(ParameterizedType parameterizedType, ClassResolver classResolver) {
        if (parameterizedType.getRawType() != List.class) {
            throw new JsonParsingException("Parametrized types other than java.util.List are not supported.");
        }
        return classResolver.resolveClass(parameterizedType.getActualTypeArguments()[0]);
    }

    private static ResolvedClass resolveElementClass(Class<?> cls, ClassResolver classResolver) {
        if (cls == List.class) {
            throw new JsonParsingException("Undefined list element type.");
        }
        if (cls.componentType() != null) {
            return classResolver.resolveClass((Type)((Object)cls.componentType()));
        }
        return null;
    }

    private static ResolvedClassCategory resolveClassType(Class<?> cls) {
        if (Iterable.class.isAssignableFrom(cls) && cls != List.class) {
            throw new JsonParsingException("Unsupported class: " + cls.getName() + ". For JSON arrays at the root, use Java arrays. For inner JSON arrays, use either Java arrays or java.util.List.");
        }
        if (cls.isArray()) {
            return ResolvedClassCategory.ARRAY;
        }
        for (ResolvedClassCategory t : ResolvedClassCategory.values()) {
            if (t.cclass != cls) continue;
            return t;
        }
        return ResolvedClassCategory.CUSTOM;
    }

    private static void checkIfCustomClassIsSupported(Class<?> cls) {
        int modifiers = cls.getModifiers();
        if (cls.isMemberClass() && !Modifier.isStatic(modifiers)) {
            throw new JsonParsingException("Unsupported class: " + cls.getName() + ". Inner non-static classes are not supported.");
        }
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            throw new JsonParsingException("Unsupported class: " + cls.getName() + ". Interfaces and abstract classes are not supported.");
        }
        Constructor<?>[] constructors = cls.getDeclaredConstructors();
        if (constructors.length > 1) {
            throw new JsonParsingException("Class: " + cls.getName() + " has more than one constructor.");
        }
        if (constructors.length == 0) {
            throw new JsonParsingException("Class: " + cls.getName() + " doesn't have any constructor.");
        }
    }

    private static String resolveFieldName(Parameter parameter, Class<?> targetClass) {
        JsonFieldName annotation = parameter.getAnnotation(JsonFieldName.class);
        if (annotation != null) {
            return annotation.value();
        }
        if (!targetClass.isRecord()) {
            throw new JsonParsingException("Some of " + targetClass.getName() + "'s constructor arguments are not annotated with @JsonFieldName.");
        }
        return parameter.getName();
    }

    ConstructorArgumentsMap getArgumentsMap() {
        return this.argumentsMap;
    }

    Constructor<?> getConstructor() {
        return this.constructor;
    }

    ResolvedClassCategory getClassCategory() {
        return this.classCategory;
    }

    ResolvedClass getElementClass() {
        return this.elementClass;
    }

    Class<?> getRawClass() {
        return this.rawClass;
    }

    static enum ResolvedClassCategory {
        BOOLEAN_PRIMITIVE(Boolean.TYPE, new boolean[0]),
        BOOLEAN(Boolean.class, new Boolean[0]),
        BYTE_PRIMITIVE(Byte.TYPE, new byte[0]),
        BYTE(Byte.class, new Byte[0]),
        CHAR_PRIMITIVE(Character.TYPE, new char[0]),
        CHAR(Character.class, new Character[0]),
        SHORT_PRIMITIVE(Short.TYPE, new short[0]),
        SHORT(Short.class, new Short[0]),
        INT_PRIMITIVE(Integer.TYPE, new int[0]),
        INT(Integer.class, new Integer[0]),
        LONG_PRIMITIVE(Long.TYPE, new long[0]),
        LONG(Long.class, new Long[0]),
        DOUBLE_PRIMITIVE(Double.TYPE, new double[0]),
        DOUBLE(Double.class, new Double[0]),
        FLOAT_PRIMITIVE(Float.TYPE, new float[0]),
        FLOAT(Float.class, new Float[0]),
        STRING(String.class, new String[0]),
        CUSTOM(null, null),
        ARRAY(null, null),
        LIST(List.class, null);

        private final Class<?> cclass;
        private final Object emptyArray;

        private ResolvedClassCategory(Class<?> cclass, Object emptyArray) {
            this.cclass = cclass;
            this.emptyArray = emptyArray;
        }

        Object getEmptyArray() {
            return this.emptyArray;
        }
    }
}

