/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.simdjson.BitIndexes;
import org.simdjson.ClassResolver;
import org.simdjson.ConstructorArgument;
import org.simdjson.ConstructorArgumentsMap;
import org.simdjson.JsonParsingException;
import org.simdjson.OnDemandJsonIterator;
import org.simdjson.ResolvedClass;

class SchemaBasedJsonIterator {
    private static final int INITIAL_ARRAY_SIZE = 16;
    private final ClassResolver classResolver;
    private final OnDemandJsonIterator jsonIterator;
    private final byte[] stringBuffer;

    SchemaBasedJsonIterator(BitIndexes bitIndexes, byte[] stringBuffer, int padding) {
        this.jsonIterator = new OnDemandJsonIterator(bitIndexes, padding);
        this.classResolver = new ClassResolver();
        this.stringBuffer = stringBuffer;
    }

    <T> T walkDocument(byte[] padded, int len, Class<T> expectedType) {
        this.jsonIterator.init(padded, len);
        this.classResolver.reset();
        ResolvedClass resolvedExpectedClass = this.classResolver.resolveClass(expectedType);
        return (T)(switch (resolvedExpectedClass.getClassCategory()) {
            default -> throw new MatchException(null, null);
            case ResolvedClass.ResolvedClassCategory.BOOLEAN_PRIMITIVE -> this.jsonIterator.getRootNonNullBoolean();
            case ResolvedClass.ResolvedClassCategory.BOOLEAN -> this.jsonIterator.getRootBoolean();
            case ResolvedClass.ResolvedClassCategory.BYTE_PRIMITIVE -> this.jsonIterator.getRootNonNullByte();
            case ResolvedClass.ResolvedClassCategory.BYTE -> this.jsonIterator.getRootByte();
            case ResolvedClass.ResolvedClassCategory.SHORT_PRIMITIVE -> this.jsonIterator.getRootNonNullShort();
            case ResolvedClass.ResolvedClassCategory.SHORT -> this.jsonIterator.getRootShort();
            case ResolvedClass.ResolvedClassCategory.INT_PRIMITIVE -> this.jsonIterator.getRootNonNullInt();
            case ResolvedClass.ResolvedClassCategory.INT -> this.jsonIterator.getRootInt();
            case ResolvedClass.ResolvedClassCategory.LONG_PRIMITIVE -> this.jsonIterator.getRootNonNullLong();
            case ResolvedClass.ResolvedClassCategory.LONG -> this.jsonIterator.getRootLong();
            case ResolvedClass.ResolvedClassCategory.FLOAT_PRIMITIVE -> Float.valueOf(this.jsonIterator.getRootNonNullFloat());
            case ResolvedClass.ResolvedClassCategory.FLOAT -> this.jsonIterator.getRootFloat();
            case ResolvedClass.ResolvedClassCategory.DOUBLE_PRIMITIVE -> this.jsonIterator.getRootNonNullDouble();
            case ResolvedClass.ResolvedClassCategory.DOUBLE -> this.jsonIterator.getRootDouble();
            case ResolvedClass.ResolvedClassCategory.CHAR_PRIMITIVE -> Character.valueOf(this.jsonIterator.getRootNonNullChar());
            case ResolvedClass.ResolvedClassCategory.CHAR -> this.jsonIterator.getRootChar();
            case ResolvedClass.ResolvedClassCategory.STRING -> this.getRootString();
            case ResolvedClass.ResolvedClassCategory.ARRAY -> this.getRootArray(resolvedExpectedClass.getElementClass());
            case ResolvedClass.ResolvedClassCategory.CUSTOM -> this.getRootObject(resolvedExpectedClass);
            case ResolvedClass.ResolvedClassCategory.LIST -> throw new JsonParsingException("Lists at the root are not supported. Consider using an array instead.");
        });
    }

    private Object getRootObject(ResolvedClass expectedClass) {
        OnDemandJsonIterator.IteratorResult result = this.jsonIterator.startIteratingRootObject();
        Object object = this.getObject(expectedClass, result);
        this.jsonIterator.assertNoMoreJsonValues();
        return object;
    }

    private Object getObject(ResolvedClass expectedClass) {
        OnDemandJsonIterator.IteratorResult result = this.jsonIterator.startIteratingObject();
        return this.getObject(expectedClass, result);
    }

    private Object getObject(ResolvedClass expectedClass, OnDemandJsonIterator.IteratorResult result) {
        if (result == OnDemandJsonIterator.IteratorResult.NOT_EMPTY) {
            ConstructorArgumentsMap argumentsMap = expectedClass.getArgumentsMap();
            Object[] args = new Object[argumentsMap.getArgumentCount()];
            int parentDepth = this.jsonIterator.getDepth() - 1;
            this.collectArguments(argumentsMap, args);
            this.jsonIterator.skipChild(parentDepth);
            return this.createObject(expectedClass, args);
        }
        if (result == OnDemandJsonIterator.IteratorResult.EMPTY) {
            ConstructorArgumentsMap argumentsMap = expectedClass.getArgumentsMap();
            Object[] args = new Object[argumentsMap.getArgumentCount()];
            return this.createObject(expectedClass, args);
        }
        return null;
    }

    private Object createObject(ResolvedClass expectedClass, Object[] args) {
        try {
            return expectedClass.getConstructor().newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JsonParsingException("Failed to construct an instance of " + expectedClass.getRawClass().getName(), e);
        }
    }

    private void collectArguments(ConstructorArgumentsMap argumentsMap, Object[] args) {
        int collected = 0;
        int argLen = args.length;
        boolean hasFields = true;
        while (collected < argLen && hasFields) {
            int fieldNameLen = this.jsonIterator.getFieldName(this.stringBuffer);
            this.jsonIterator.moveToFieldValue();
            ConstructorArgument argument = argumentsMap.get(this.stringBuffer, fieldNameLen);
            if (argument != null) {
                ResolvedClass argumentClass = argument.resolvedClass();
                this.collectArgument(argumentClass, args, argument);
                ++collected;
            } else {
                this.jsonIterator.skipChild();
            }
            hasFields = this.jsonIterator.nextObjectField();
        }
    }

    private void collectArgument(ResolvedClass argumentClass, Object[] args, ConstructorArgument argument) {
        int n = argument.idx();
        args[n] = switch (argumentClass.getClassCategory()) {
            default -> throw new MatchException(null, null);
            case ResolvedClass.ResolvedClassCategory.BOOLEAN_PRIMITIVE -> this.jsonIterator.getNonNullBoolean();
            case ResolvedClass.ResolvedClassCategory.BOOLEAN -> this.jsonIterator.getBoolean();
            case ResolvedClass.ResolvedClassCategory.BYTE_PRIMITIVE -> this.jsonIterator.getNonNullByte();
            case ResolvedClass.ResolvedClassCategory.BYTE -> this.jsonIterator.getByte();
            case ResolvedClass.ResolvedClassCategory.SHORT_PRIMITIVE -> this.jsonIterator.getNonNullShort();
            case ResolvedClass.ResolvedClassCategory.SHORT -> this.jsonIterator.getShort();
            case ResolvedClass.ResolvedClassCategory.INT_PRIMITIVE -> this.jsonIterator.getNonNullInt();
            case ResolvedClass.ResolvedClassCategory.INT -> this.jsonIterator.getInt();
            case ResolvedClass.ResolvedClassCategory.LONG_PRIMITIVE -> this.jsonIterator.getNonNullLong();
            case ResolvedClass.ResolvedClassCategory.LONG -> this.jsonIterator.getLong();
            case ResolvedClass.ResolvedClassCategory.FLOAT_PRIMITIVE -> Float.valueOf(this.jsonIterator.getNonNullFloat());
            case ResolvedClass.ResolvedClassCategory.FLOAT -> this.jsonIterator.getFloat();
            case ResolvedClass.ResolvedClassCategory.DOUBLE_PRIMITIVE -> this.jsonIterator.getNonNullDouble();
            case ResolvedClass.ResolvedClassCategory.DOUBLE -> this.jsonIterator.getDouble();
            case ResolvedClass.ResolvedClassCategory.CHAR_PRIMITIVE -> Character.valueOf(this.jsonIterator.getNonNullChar());
            case ResolvedClass.ResolvedClassCategory.CHAR -> this.jsonIterator.getChar();
            case ResolvedClass.ResolvedClassCategory.STRING -> this.getString();
            case ResolvedClass.ResolvedClassCategory.ARRAY -> this.getArray(argumentClass.getElementClass());
            case ResolvedClass.ResolvedClassCategory.LIST -> this.getList(argumentClass.getElementClass());
            case ResolvedClass.ResolvedClassCategory.CUSTOM -> this.getObject(argument.resolvedClass());
        };
    }

    private List<Object> getList(ResolvedClass elementType) {
        OnDemandJsonIterator.IteratorResult result = this.jsonIterator.startIteratingArray();
        if (result == OnDemandJsonIterator.IteratorResult.EMPTY) {
            return Collections.emptyList();
        }
        if (result == OnDemandJsonIterator.IteratorResult.NULL) {
            return null;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        boolean hasElements = true;
        switch (elementType.getClassCategory()) {
            case BOOLEAN: {
                while (hasElements) {
                    list.add(this.jsonIterator.getBoolean());
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case BYTE: {
                while (hasElements) {
                    list.add(this.jsonIterator.getByte());
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case CHAR: {
                while (hasElements) {
                    list.add(this.jsonIterator.getChar());
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case SHORT: {
                while (hasElements) {
                    list.add(this.jsonIterator.getShort());
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case INT: {
                while (hasElements) {
                    list.add(this.jsonIterator.getInt());
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case LONG: {
                while (hasElements) {
                    list.add(this.jsonIterator.getLong());
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case DOUBLE: {
                while (hasElements) {
                    list.add(this.jsonIterator.getDouble());
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case FLOAT: {
                while (hasElements) {
                    list.add(this.jsonIterator.getFloat());
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case STRING: {
                while (hasElements) {
                    list.add(this.getString());
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case CUSTOM: {
                while (hasElements) {
                    list.add(this.getObject(elementType));
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case ARRAY: {
                while (hasElements) {
                    list.add(this.getArray(elementType.getElementClass()));
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            case LIST: {
                while (hasElements) {
                    list.add(this.getList(elementType.getElementClass()));
                    hasElements = this.jsonIterator.nextArrayElement();
                }
                break;
            }
            default: {
                throw new JsonParsingException("Unsupported array element type: " + elementType.getRawClass().getName());
            }
        }
        return list;
    }

    private Object getRootArray(ResolvedClass elementType) {
        OnDemandJsonIterator.IteratorResult result = this.jsonIterator.startIteratingRootArray();
        Object array = this.getArray(elementType, result);
        this.jsonIterator.assertNoMoreJsonValues();
        return array;
    }

    private Object getArray(ResolvedClass elementType) {
        OnDemandJsonIterator.IteratorResult result = this.jsonIterator.startIteratingArray();
        return this.getArray(elementType, result);
    }

    private Object getArray(ResolvedClass elementType, OnDemandJsonIterator.IteratorResult result) {
        if (result == OnDemandJsonIterator.IteratorResult.EMPTY) {
            ResolvedClass.ResolvedClassCategory classCategory = elementType.getClassCategory();
            return classCategory.getEmptyArray() != null ? classCategory.getEmptyArray() : Array.newInstance(elementType.getRawClass(), 0);
        }
        if (result == OnDemandJsonIterator.IteratorResult.NULL) {
            return null;
        }
        return switch (elementType.getClassCategory()) {
            default -> throw new MatchException(null, null);
            case ResolvedClass.ResolvedClassCategory.BOOLEAN_PRIMITIVE -> this.getPrimitiveBooleanArray();
            case ResolvedClass.ResolvedClassCategory.BOOLEAN -> this.getBooleanArray();
            case ResolvedClass.ResolvedClassCategory.BYTE_PRIMITIVE -> (Object)this.getBytePrimitiveArray();
            case ResolvedClass.ResolvedClassCategory.BYTE -> (Object)this.getByteArray();
            case ResolvedClass.ResolvedClassCategory.CHAR_PRIMITIVE -> (Object)this.getCharPrimitiveArray();
            case ResolvedClass.ResolvedClassCategory.CHAR -> (Object)this.getCharArray();
            case ResolvedClass.ResolvedClassCategory.SHORT_PRIMITIVE -> (Object)this.getShortPrimitiveArray();
            case ResolvedClass.ResolvedClassCategory.SHORT -> (Object)this.getShortArray();
            case ResolvedClass.ResolvedClassCategory.INT_PRIMITIVE -> (Object)this.getIntPrimitiveArray();
            case ResolvedClass.ResolvedClassCategory.INT -> (Object)this.getIntArray();
            case ResolvedClass.ResolvedClassCategory.LONG_PRIMITIVE -> (Object)this.getLongPrimitiveArray();
            case ResolvedClass.ResolvedClassCategory.LONG -> (Object)this.getLongArray();
            case ResolvedClass.ResolvedClassCategory.DOUBLE_PRIMITIVE -> (Object)this.getDoublePrimitiveArray();
            case ResolvedClass.ResolvedClassCategory.DOUBLE -> (Object)this.getDoubleArray();
            case ResolvedClass.ResolvedClassCategory.FLOAT_PRIMITIVE -> (Object)this.getFloatPrimitiveArray();
            case ResolvedClass.ResolvedClassCategory.FLOAT -> (Object)this.getFloatArray();
            case ResolvedClass.ResolvedClassCategory.STRING -> (Object)this.getStringArray();
            case ResolvedClass.ResolvedClassCategory.CUSTOM -> (Object)this.getCustomObjectArray(elementType);
            case ResolvedClass.ResolvedClassCategory.ARRAY -> (Object)this.getArrayOfArrays(elementType);
            case ResolvedClass.ResolvedClassCategory.LIST -> throw new JsonParsingException("Arrays of lists are not supported.");
        };
    }

    private Object getFloatArray() {
        Float[] array = new Float[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Float[] copy = new Float[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getFloat();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Float[] copy = new Float[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object getFloatPrimitiveArray() {
        float[] array = new float[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                float[] copy = new float[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getNonNullFloat();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            float[] copy = new float[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object getDoubleArray() {
        Double[] array = new Double[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Double[] copy = new Double[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getDouble();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Double[] copy = new Double[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object getDoublePrimitiveArray() {
        double[] array = new double[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                double[] copy = new double[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getNonNullDouble();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            double[] copy = new double[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object getLongPrimitiveArray() {
        long[] array = new long[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                long[] copy = new long[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getNonNullLong();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            long[] copy = new long[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object getLongArray() {
        Long[] array = new Long[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Long[] copy = new Long[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getLong();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Long[] copy = new Long[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object getShortPrimitiveArray() {
        short[] array = new short[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                short[] copy = new short[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getNonNullShort();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            short[] copy = new short[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object getShortArray() {
        Short[] array = new Short[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Short[] copy = new Short[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getShort();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Short[] copy = new Short[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object[] getCustomObjectArray(ResolvedClass elementType) {
        Object[] array = (Object[])Array.newInstance(elementType.getRawClass(), 16);
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Object[] copy = (Object[])Array.newInstance(elementType.getRawClass(), newCapacity);
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.getObject(elementType);
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Object[] copy = (Object[])Array.newInstance(elementType.getRawClass(), size);
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object[] getArrayOfArrays(ResolvedClass elementType) {
        Object[] array = (Object[])Array.newInstance(elementType.getRawClass(), 16);
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Object[] copy = (Object[])Array.newInstance(elementType.getRawClass(), newCapacity);
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.getArray(elementType.getElementClass());
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Object[] copy = (Object[])Array.newInstance(elementType.getRawClass(), size);
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Integer[] getIntArray() {
        Integer[] array = new Integer[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Integer[] copy = new Integer[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getInt();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Integer[] copy = new Integer[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private int[] getIntPrimitiveArray() {
        int[] array = new int[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                int[] copy = new int[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getNonNullInt();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            int[] copy = new int[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object getCharArray() {
        Character[] array = new Character[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Character[] copy = new Character[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getChar();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Character[] copy = new Character[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private char[] getCharPrimitiveArray() {
        char[] array = new char[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                char[] copy = new char[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getNonNullChar();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            char[] copy = new char[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Object getByteArray() {
        Byte[] array = new Byte[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Byte[] copy = new Byte[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getByte();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Byte[] copy = new Byte[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private byte[] getBytePrimitiveArray() {
        byte[] array = new byte[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                byte[] copy = new byte[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getNonNullByte();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            byte[] copy = new byte[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private Boolean[] getBooleanArray() {
        Boolean[] array = new Boolean[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                Boolean[] copy = new Boolean[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getBoolean();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            Boolean[] copy = new Boolean[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private boolean[] getPrimitiveBooleanArray() {
        boolean[] array = new boolean[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                boolean[] copy = new boolean[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.jsonIterator.getNonNullBoolean();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            boolean[] copy = new boolean[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private String[] getStringArray() {
        String[] array = new String[16];
        int size = 0;
        boolean hasElements = true;
        while (hasElements) {
            int oldCapacity = array.length;
            if (size == oldCapacity) {
                int newCapacity = SchemaBasedJsonIterator.calculateNewCapacity(oldCapacity);
                String[] copy = new String[newCapacity];
                System.arraycopy(array, 0, copy, 0, oldCapacity);
                array = copy;
            }
            array[size++] = this.getString();
            hasElements = this.jsonIterator.nextArrayElement();
        }
        if (size != array.length) {
            String[] copy = new String[size];
            System.arraycopy(array, 0, copy, 0, size);
            array = copy;
        }
        return array;
    }

    private static int calculateNewCapacity(int oldCapacity) {
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        int minCapacity = oldCapacity + 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        return newCapacity;
    }

    private String getString() {
        int len = this.jsonIterator.getString(this.stringBuffer);
        if (len == -1) {
            return null;
        }
        return new String(this.stringBuffer, 0, len, StandardCharsets.UTF_8);
    }

    private String getRootString() {
        int len = this.jsonIterator.getRootString(this.stringBuffer);
        if (len == -1) {
            return null;
        }
        return new String(this.stringBuffer, 0, len, StandardCharsets.UTF_8);
    }
}

