/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.util.Arrays;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorShuffle;
import org.simdjson.JsonParsingException;
import org.simdjson.VectorUtils;

class Utf8Validator {
    private static final byte TOO_SHORT = 1;
    private static final byte TOO_LONG = 2;
    private static final byte OVERLONG_3BYTE = 4;
    private static final byte TOO_LARGE = 8;
    private static final byte SURROGATE = 16;
    private static final byte OVERLONG_2BYTE = 32;
    private static final byte TOO_LARGE_1000 = 64;
    private static final byte OVERLONG_4BYTE = 64;
    private static final byte TWO_CONTINUATIONS = -128;
    private static final byte MAX_2_LEADING_BYTE = -33;
    private static final byte MAX_3_LEADING_BYTE = -17;
    private static final int TWO_BYTES_SIZE = 16;
    private static final int THREE_BYTES_SIZE = 24;
    private static final ByteVector BYTE_1_HIGH_LOOKUP = Utf8Validator.createByte1HighLookup();
    private static final ByteVector BYTE_1_LOW_LOOKUP = Utf8Validator.createByte1LowLookup();
    private static final ByteVector BYTE_2_HIGH_LOOKUP = Utf8Validator.createByte2HighLookup();
    private static final ByteVector INCOMPLETE_CHECK = Utf8Validator.createIncompleteCheck();
    private static final byte LOW_NIBBLE_MASK = 15;
    private static final byte ALL_ASCII_MASK = -128;
    private static final VectorShuffle<Integer> FOUR_BYTES_FORWARD_SHIFT = VectorShuffle.iota(VectorUtils.INT_SPECIES, (int)(VectorUtils.INT_SPECIES.elementSize() - 1), (int)1, (boolean)true);
    private static final int STEP_SIZE = VectorUtils.BYTE_SPECIES.vectorByteSize();

    Utf8Validator() {
    }

    static void validate(byte[] buffer, int length) {
        int offset;
        long previousIncomplete = 0L;
        long errors = 0L;
        int previousFourUtf8Bytes = 0;
        int loopBound = VectorUtils.BYTE_SPECIES.loopBound(length);
        for (offset = 0; offset < loopBound; offset += STEP_SIZE) {
            ByteVector chunk = ByteVector.fromArray(VectorUtils.BYTE_SPECIES, (byte[])buffer, (int)offset);
            IntVector chunkAsInts = chunk.reinterpretAsInts();
            if (chunk.and((byte)-128).compare(VectorOperators.EQ, 0L).allTrue()) {
                errors |= previousIncomplete;
            } else {
                previousIncomplete = chunk.compare(VectorOperators.UGE, (Vector)INCOMPLETE_CHECK).toLong();
                IntVector chunkWithPreviousFourBytes = chunkAsInts.rearrange(FOUR_BYTES_FORWARD_SHIFT).withLane(0, previousFourUtf8Bytes);
                ByteVector previousOneByte = chunkAsInts.lanewise(VectorOperators.LSHL, 8).or((Vector)chunkWithPreviousFourBytes.lanewise(VectorOperators.LSHR, 24)).reinterpretAsBytes();
                ByteVector byte2HighNibbles = chunkAsInts.lanewise(VectorOperators.LSHR, 4).reinterpretAsBytes().and((byte)15);
                ByteVector byte1HighNibbles = previousOneByte.reinterpretAsInts().lanewise(VectorOperators.LSHR, 4).reinterpretAsBytes().and((byte)15);
                ByteVector byte1LowNibbles = previousOneByte.and((byte)15);
                ByteVector byte1HighState = byte1HighNibbles.selectFrom((Vector)BYTE_1_HIGH_LOOKUP);
                ByteVector byte1LowState = byte1LowNibbles.selectFrom((Vector)BYTE_1_LOW_LOOKUP);
                ByteVector byte2HighState = byte2HighNibbles.selectFrom((Vector)BYTE_2_HIGH_LOOKUP);
                ByteVector firstCheck = byte1HighState.and((Vector)byte1LowState).and((Vector)byte2HighState);
                ByteVector previousTwoBytes = chunkAsInts.lanewise(VectorOperators.LSHL, 16).or((Vector)chunkWithPreviousFourBytes.lanewise(VectorOperators.LSHR, 16)).reinterpretAsBytes();
                VectorMask is3ByteLead = previousTwoBytes.compare(VectorOperators.UGT, (byte)-33);
                ByteVector previousThreeBytes = chunkAsInts.lanewise(VectorOperators.LSHL, 24).or((Vector)chunkWithPreviousFourBytes.lanewise(VectorOperators.LSHR, 8)).reinterpretAsBytes();
                VectorMask is4ByteLead = previousThreeBytes.compare(VectorOperators.UGT, (byte)-17);
                ByteVector secondCheck = firstCheck.add((byte)-128, is3ByteLead.or(is4ByteLead));
                errors |= secondCheck.compare(VectorOperators.NE, 0L).toLong();
            }
            previousFourUtf8Bytes = chunkAsInts.lane(VectorUtils.INT_SPECIES.length() - 1);
        }
        VectorMask remainingBytes = VectorUtils.BYTE_SPECIES.indexInRange(offset, length);
        ByteVector chunk = ByteVector.fromArray(VectorUtils.BYTE_SPECIES, (byte[])buffer, (int)offset, (VectorMask)remainingBytes);
        if (!chunk.and((byte)-128).compare(VectorOperators.EQ, 0L).allTrue()) {
            IntVector chunkAsInts = chunk.reinterpretAsInts();
            previousIncomplete = chunk.compare(VectorOperators.UGE, (Vector)INCOMPLETE_CHECK).toLong();
            IntVector chunkWithPreviousFourBytes = chunkAsInts.rearrange(FOUR_BYTES_FORWARD_SHIFT).withLane(0, previousFourUtf8Bytes);
            ByteVector previousOneByte = chunkAsInts.lanewise(VectorOperators.LSHL, 8).or((Vector)chunkWithPreviousFourBytes.lanewise(VectorOperators.LSHR, 24)).reinterpretAsBytes();
            ByteVector byte2HighNibbles = chunkAsInts.lanewise(VectorOperators.LSHR, 4).reinterpretAsBytes().and((byte)15);
            ByteVector byte1HighNibbles = previousOneByte.reinterpretAsInts().lanewise(VectorOperators.LSHR, 4).reinterpretAsBytes().and((byte)15);
            ByteVector byte1LowNibbles = previousOneByte.and((byte)15);
            ByteVector byte1HighState = byte1HighNibbles.selectFrom((Vector)BYTE_1_HIGH_LOOKUP);
            ByteVector byte1LowState = byte1LowNibbles.selectFrom((Vector)BYTE_1_LOW_LOOKUP);
            ByteVector byte2HighState = byte2HighNibbles.selectFrom((Vector)BYTE_2_HIGH_LOOKUP);
            ByteVector firstCheck = byte1HighState.and((Vector)byte1LowState).and((Vector)byte2HighState);
            ByteVector previousTwoBytes = chunkAsInts.lanewise(VectorOperators.LSHL, 16).or((Vector)chunkWithPreviousFourBytes.lanewise(VectorOperators.LSHR, 16)).reinterpretAsBytes();
            VectorMask is3ByteLead = previousTwoBytes.compare(VectorOperators.UGT, (byte)-33);
            ByteVector previousThreeBytes = chunkAsInts.lanewise(VectorOperators.LSHL, 24).or((Vector)chunkWithPreviousFourBytes.lanewise(VectorOperators.LSHR, 8)).reinterpretAsBytes();
            VectorMask is4ByteLead = previousThreeBytes.compare(VectorOperators.UGT, (byte)-17);
            ByteVector secondCheck = firstCheck.add((byte)-128, is3ByteLead.or(is4ByteLead));
            errors |= secondCheck.compare(VectorOperators.NE, 0L).toLong();
        }
        if ((errors | previousIncomplete) != 0L) {
            throw new JsonParsingException("The input is not valid UTF-8");
        }
    }

    private static ByteVector createIncompleteCheck() {
        int vectorByteSize = VectorUtils.BYTE_SPECIES.vectorByteSize();
        byte[] eofArray = new byte[vectorByteSize];
        Arrays.fill(eofArray, (byte)-1);
        eofArray[vectorByteSize - 3] = -16;
        eofArray[vectorByteSize - 2] = -32;
        eofArray[vectorByteSize - 1] = -64;
        return ByteVector.fromArray(VectorUtils.BYTE_SPECIES, (byte[])eofArray, (int)0);
    }

    private static ByteVector createByte1HighLookup() {
        byte[] byte1HighArray = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, -128, -128, -128, -128, 33, 1, 21, 73};
        return Utf8Validator.alignArrayToVector(byte1HighArray);
    }

    private static ByteVector createByte1LowLookup() {
        int CARRY = -125;
        byte[] byte1LowArray = new byte[]{-25, -93, -125, -125, -117, -53, -53, -53, -53, -53, -53, -53, -53, -37, -53, -53};
        return Utf8Validator.alignArrayToVector(byte1LowArray);
    }

    private static ByteVector createByte2HighLookup() {
        byte[] byte2HighArray = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, -26, -82, -70, -70, 1, 1, 1, 1};
        return Utf8Validator.alignArrayToVector(byte2HighArray);
    }

    private static ByteVector alignArrayToVector(byte[] arrayValues) {
        byte[] alignedArray = new byte[VectorUtils.BYTE_SPECIES.vectorByteSize()];
        System.arraycopy(arrayValues, 0, alignedArray, 0, arrayValues.length);
        return ByteVector.fromArray(VectorUtils.BYTE_SPECIES, (byte[])alignedArray, (int)0);
    }
}

