/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.mail.dkim;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.iharder.Base64;
import net.markenwerk.utils.mail.dkim.DkimAcceptanceException;
import net.markenwerk.utils.mail.dkim.DkimException;
import net.markenwerk.utils.mail.dkim.DkimSigningException;

public final class DomainKey {
    private static final String RSA_MODE = "RSA/ECB/NoPadding";
    private static final String DKIM_VERSION = "DKIM1";
    private static final String RSA_KEY_TYPE = "rsa";
    private static final String EMAIL_SERVICE_TYPE = "email";
    private final long timestamp = System.currentTimeMillis();
    private final Pattern granularity;
    private final Set<String> serviceTypes;
    private final RSAPublicKey publicKey;
    private final Map<Character, String> tags;

    public DomainKey(Map<Character, String> tags) throws DkimException {
        this.tags = Collections.unmodifiableMap(tags);
        if (!DKIM_VERSION.equals(this.getTagValue('v', DKIM_VERSION))) {
            throw new DkimException("Incompatible version v=" + this.getTagValue('v') + ".");
        }
        this.granularity = this.getGranularityPattern(this.getTagValue('g', "*"));
        if (!RSA_KEY_TYPE.equals(this.getTagValue('k', RSA_KEY_TYPE))) {
            throw new DkimException("Incompatible key type k=" + this.getTagValue('k') + ".");
        }
        this.serviceTypes = this.getServiceTypes(this.getTagValue('s', "*"));
        if (!this.serviceTypes.contains("*") && !this.serviceTypes.contains(EMAIL_SERVICE_TYPE)) {
            throw new DkimException("Incompatible service type s=" + this.getTagValue('s') + ".");
        }
        String privateKeyTagValue = this.getTagValue('p');
        if (null == privateKeyTagValue) {
            throw new DkimException("No public key available.");
        }
        this.publicKey = this.getPublicKey(privateKeyTagValue);
    }

    private Set<String> getServiceTypes(String serviceTypesTagValue) {
        HashSet<String> serviceTypes = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(serviceTypesTagValue, ":", false);
        while (tokenizer.hasMoreElements()) {
            serviceTypes.add(tokenizer.nextToken().trim());
        }
        return serviceTypes;
    }

    private String getTagValue(char tag) {
        return this.getTagValue(tag, null);
    }

    private String getTagValue(char tag, String fallback) {
        String tagValue = this.tags.get(Character.valueOf(tag));
        return null == tagValue ? fallback : tagValue;
    }

    private RSAPublicKey getPublicKey(String privateKeyTagValue) throws DkimException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decode((String)privateKeyTagValue));
            return (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new DkimException("RSA algorithm not found by JVM");
        }
        catch (IOException e) {
            throw new DkimException("The public key " + privateKeyTagValue + " couldn't be read.");
        }
        catch (InvalidKeySpecException e) {
            throw new DkimException("The public key " + privateKeyTagValue + " couldn't be decoded.");
        }
    }

    private Pattern getGranularityPattern(String granularity) {
        StringTokenizer tokenizer = new StringTokenizer(granularity, "*", true);
        StringBuffer pattern = new StringBuffer();
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if ("*".equals(token)) {
                pattern.append(".*");
                continue;
            }
            pattern.append(Pattern.quote(token));
        }
        return Pattern.compile(pattern.toString());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Pattern getGranularity() {
        return this.granularity;
    }

    public Set<String> getServiceTypes() {
        return this.serviceTypes;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public Map<Character, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "Entry [timestamp=" + this.timestamp + ", tags=" + this.tags + "]";
    }

    public void check(String identity, RSAPrivateKey privateKey) throws DkimSigningException {
        String localPart;
        String string = localPart = null == identity ? "" : identity.substring(0, identity.indexOf(64));
        if (!this.granularity.matcher(localPart).matches()) {
            throw new DkimAcceptanceException("Incompatible identity (" + identity + ") for granularity g=" + this.getTagValue('g') + " ");
        }
        try {
            Cipher cipher = Cipher.getInstance(RSA_MODE);
            byte[] originalMessage = new byte[this.publicKey.getModulus().bitLength() / 8];
            int n = originalMessage.length;
            for (int i = 0; i < n; ++i) {
                originalMessage[i] = (byte)i;
            }
            cipher.init(1, privateKey);
            byte[] encryptedMessage = cipher.doFinal(originalMessage);
            cipher.init(2, this.publicKey);
            byte[] decryptedMessage = cipher.doFinal(encryptedMessage);
            if (!Arrays.equals(originalMessage, decryptedMessage)) {
                throw new DkimAcceptanceException("Incompatible private key for public key p=" + this.getTagValue('p') + " ");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new DkimSigningException("No JCE provider supports RSA/ECB/NoPadding ciphers.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new DkimSigningException("No JCE provider supports RSA/ECB/NoPadding ciphers.", e);
        }
        catch (InvalidKeyException e) {
            throw new DkimSigningException("Performing RSA cryptography failed.", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new DkimSigningException("Performing RSA cryptography failed.", e);
        }
        catch (BadPaddingException e) {
            throw new DkimSigningException("Performing RSA cryptography failed.", e);
        }
    }
}

