/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.simplejavamail.email.EqualsHelper;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public class AttachmentResource {
    private final String name;
    private final DataSource dataSource;

    public AttachmentResource(@Nullable String name, @Nonnull DataSource dataSource) {
        this.name = name;
        this.dataSource = Preconditions.checkNonEmptyArgument(dataSource, "dataSource");
    }

    @Nonnull
    public String readAllData() throws IOException {
        return this.readAllData(Charset.forName("UTF-8"));
    }

    @Nonnull
    public String readAllData(@Nonnull Charset charset) throws IOException {
        Preconditions.checkNonEmptyArgument(charset, "charset");
        return MiscUtil.readInputStreamToString(this.dataSource.getInputStream(), charset);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && EqualsHelper.equalsAttachmentResource(this, (AttachmentResource)o);
    }

    @Nonnull
    public String toString() {
        return "AttachmentResource{\n\t\tname='" + this.name + '\'' + ",\n\t\tdataSource.name=" + this.dataSource.getName() + ",\n\t\tdataSource.getContentType=" + this.dataSource.getContentType() + "\n\t}";
    }
}

