/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.socks.socks5client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.mailer.internal.socks.common.SocksException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SocksCommandSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocksCommandSender.class);
    private static final byte SOCKS_VERSION = 5;
    private static final int ADDRESS_TYPE_IPV4 = 1;
    private static final int ADDRESS_TYPE_DOMAIN_NAME = 3;
    private static final int ADDRESS_TYPE_IPV6 = 4;
    private static final int COMMAND_CONNECT = 1;
    private static final int LENGTH_OF_IPV4 = 4;
    private static final int LENGTH_OF_IPV6 = 16;
    private static final int RESERVED = 0;
    private static final byte ATYPE_IPV4 = 1;
    private static final byte ATYPE_DOMAINNAME = 3;
    private static final byte ATYPE_IPV6 = 4;
    private static final int REP_SUCCEEDED = 0;

    SocksCommandSender() {
    }

    public static void send(Socket socket, InetAddress address, int port) throws IOException {
        SocksCommandSender.send(socket, new InetSocketAddress(address, port));
    }

    public static void send(Socket socket, SocketAddress socketAddress) throws IOException {
        byte[] bufferSent;
        int addressType;
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        InetSocketAddress address = (InetSocketAddress)socketAddress;
        byte[] bytesOfAddress = address.getAddress().getAddress();
        int ADDRESS_LENGTH = bytesOfAddress.length;
        int port = address.getPort();
        if (ADDRESS_LENGTH == 4) {
            addressType = 1;
            bufferSent = new byte[10];
        } else if (ADDRESS_LENGTH == 16) {
            addressType = 4;
            bufferSent = new byte[22];
        } else {
            throw new SocksException("Address error");
        }
        bufferSent[0] = 5;
        bufferSent[1] = 1;
        bufferSent[2] = 0;
        bufferSent[3] = addressType;
        System.arraycopy(bytesOfAddress, 0, bufferSent, 4, ADDRESS_LENGTH);
        bufferSent[4 + ADDRESS_LENGTH] = (byte)((port & 0xFF00) >> 8);
        bufferSent[5 + ADDRESS_LENGTH] = (byte)(port & 0xFF);
        outputStream.write(bufferSent);
        outputStream.flush();
        LOGGER.trace("{}", (Object)MiscUtil.buildLogString(bufferSent, false));
        SocksCommandSender.checkServerReply(inputStream);
    }

    public static void send(Socket socket, String host, int port) throws IOException {
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        int lengthOfHost = host.getBytes(Charset.forName("UTF-8")).length;
        byte[] bufferSent = new byte[7 + lengthOfHost];
        bufferSent[0] = 5;
        bufferSent[1] = 1;
        bufferSent[2] = 0;
        bufferSent[3] = 3;
        bufferSent[4] = (byte)lengthOfHost;
        byte[] bytesOfHost = host.getBytes(Charset.forName("UTF-8"));
        System.arraycopy(bytesOfHost, 0, bufferSent, 5, lengthOfHost);
        bufferSent[5 + host.length()] = (byte)((port & 0xFF00) >> 8);
        bufferSent[6 + host.length()] = (byte)(port & 0xFF);
        outputStream.write(bufferSent);
        outputStream.flush();
        LOGGER.trace("{}", (Object)MiscUtil.buildLogString(bufferSent, false));
        SocksCommandSender.checkServerReply(inputStream);
    }

    private static void checkServerReply(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int temp = 0;
        for (int i = 0; i < 4; ++i) {
            temp = inputStream.read();
            byteArrayOutputStream.write(temp);
        }
        byte addressType = (byte)temp;
        switch (addressType) {
            case 1: {
                int i;
                for (i = 0; i < 6; ++i) {
                    byteArrayOutputStream.write(inputStream.read());
                }
                break;
            }
            case 3: {
                int i;
                temp = inputStream.read();
                byteArrayOutputStream.write(temp);
                for (i = 0; i < temp + 2; ++i) {
                    byteArrayOutputStream.write(inputStream.read());
                }
                break;
            }
            case 4: {
                int i;
                for (i = 0; i < 18; ++i) {
                    byteArrayOutputStream.write(inputStream.read());
                }
                break;
            }
            default: {
                throw new SocksException("Address type not support, type value: " + addressType);
            }
        }
        byte[] receivedData = byteArrayOutputStream.toByteArray();
        LOGGER.trace("{}", (Object)MiscUtil.buildLogString(receivedData, true));
        byte[] portBytes = new byte[2];
        if (receivedData[3] == 1) {
            byte[] addressBytes = new byte[4];
            System.arraycopy(receivedData, 4, addressBytes, 0, addressBytes.length);
            int a = MiscUtil.toInt(addressBytes[0]);
            int b = MiscUtil.toInt(addressBytes[1]);
            int c = MiscUtil.toInt(addressBytes[2]);
            int d = MiscUtil.toInt(addressBytes[3]);
            portBytes[0] = receivedData[8];
            portBytes[1] = receivedData[9];
            LOGGER.debug("Server replied:Address as IPv4:{}.{}.{}.{}, port:{}", new Object[]{a, b, c, d, MiscUtil.toInt(portBytes[0]) << 8 | MiscUtil.toInt(portBytes[1])});
        } else if (receivedData[3] == 3) {
            int size = receivedData[4];
            byte[] addressBytes = new byte[size &= 0xFF];
            System.arraycopy(receivedData, 4, addressBytes, 0, size);
            portBytes[0] = receivedData[4 + size];
            portBytes[1] = receivedData[5 + size];
            LOGGER.debug("Server replied:Address as host:{}, port:{}", (Object)new String(addressBytes, Charset.forName("UTF-8")), (Object)(MiscUtil.toInt(portBytes[0]) << 8 | MiscUtil.toInt(portBytes[1])));
        } else if (receivedData[3] == 4) {
            byte[] addressBytes = new byte[16];
            System.arraycopy(receivedData, 4, addressBytes, 0, addressBytes.length);
            LOGGER.debug("Server replied:Address as IPv6:{}", (Object)new String(addressBytes, Charset.forName("UTF-8")));
        }
        byte serverReply = receivedData[1];
        if (serverReply != 0) {
            throw SocksException.serverReplyException(serverReply);
        }
        LOGGER.debug("SOCKS server response success");
    }
}

