/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.SeparatedList;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class ObjectLiteralTreeImpl
extends JavaScriptTree
implements ObjectLiteralTree {
    private SyntaxToken openCurlyBrace;
    private final SeparatedList<Tree> properties;
    private SyntaxToken closeCurlyBrace;
    private TypeSet types = TypeSet.emptyTypeSet();

    public ObjectLiteralTreeImpl(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        super(Tree.Kind.OBJECT_LITERAL);
        this.openCurlyBrace = openCurlyBrace;
        this.closeCurlyBrace = closeCurlyBrace;
        this.properties = new SeparatedList(ListUtils.EMPTY_LIST, ListUtils.EMPTY_LIST);
        this.addChildren(openCurlyBrace, closeCurlyBrace);
    }

    public ObjectLiteralTreeImpl(SeparatedList<Tree> properties) {
        super(Tree.Kind.OBJECT_LITERAL);
        this.properties = properties;
        for (AstNode child : properties.getChildren()) {
            this.addChild(child);
        }
        properties.clearChildren();
    }

    public ObjectLiteralTreeImpl complete(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.closeCurlyBrace = closeCurlyBrace;
        this.prependChildren(openCurlyBrace);
        this.addChild(closeCurlyBrace);
        return this;
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public SeparatedList<Tree> properties() {
        return this.properties;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OBJECT_LITERAL;
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    public void addType(Type type) {
        this.types.add(type);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openCurlyBrace), this.properties.iterator(), (Iterator)Iterators.singletonIterator((Object)this.closeCurlyBrace));
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitObjectLiteral(this);
    }
}

