/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class PairPropertyTreeImpl
extends JavaScriptTree
implements PairPropertyTree {
    private final ExpressionTree key;
    private final SyntaxToken operator;
    private final ExpressionTree value;

    public PairPropertyTreeImpl(ExpressionTree key, InternalSyntaxToken operator, ExpressionTree value) {
        super(Tree.Kind.PAIR_PROPERTY);
        this.key = key;
        this.operator = operator;
        this.value = value;
        this.addChildren((AstNode)key, operator, (AstNode)value);
    }

    @Override
    public ExpressionTree key() {
        return this.key;
    }

    @Override
    @Nullable
    public SyntaxToken colonToken() {
        return this.operator;
    }

    @Override
    public ExpressionTree value() {
        return this.value;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PAIR_PROPERTY;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.key, this.value});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitPairProperty(this);
    }

    @Override
    public TypeSet types() {
        return TypeSet.emptyTypeSet();
    }
}

