/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex;

import com.googlecode.d2j.Field;
import com.googlecode.d2j.node.DexClassNode;
import com.googlecode.d2j.node.DexFieldNode;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import java.util.HashMap;

public class DexFix {
    private static final int ACC_STATIC_FINAL = 24;

    public static void fixStaticFinalFieldValue(DexFileNode dex) {
        if (dex.clzs != null) {
            for (DexClassNode classNode : dex.clzs) {
                DexFix.fixStaticFinalFieldValue(classNode);
            }
        }
    }

    public static void fixStaticFinalFieldValue(final DexClassNode classNode) {
        if (classNode.fields == null) {
            return;
        }
        final HashMap<String, DexFieldNode> fs = new HashMap<String, DexFieldNode>();
        final HashMap<String, DexFieldNode> shouldNotBeAssigned = new HashMap<String, DexFieldNode>();
        for (DexFieldNode fn : classNode.fields) {
            if ((fn.access & 0x18) != 24) continue;
            if (fn.cst == null) {
                char t = fn.field.getType().charAt(0);
                if (t == 'L' || t == '[') continue;
                fs.put(fn.field.getName() + ":" + fn.field.getType(), fn);
                continue;
            }
            if (!DexFix.isPrimitiveZero(fn.field.getType(), fn.cst)) continue;
            shouldNotBeAssigned.put(fn.field.getName() + ":" + fn.field.getType(), fn);
        }
        if (fs.isEmpty() && shouldNotBeAssigned.isEmpty()) {
            return;
        }
        DexMethodNode node = null;
        if (classNode.methods != null) {
            for (DexMethodNode mn : classNode.methods) {
                if (!mn.method.getName().equals("<clinit>")) continue;
                node = mn;
                break;
            }
        }
        if (node != null) {
            if (node.codeNode != null) {
                node.codeNode.accept(new DexCodeVisitor(){

                    @Override
                    public void visitFieldStmt(Op op, int a, int b, Field field) {
                        switch (op) {
                            case SPUT: 
                            case SPUT_BOOLEAN: 
                            case SPUT_BYTE: 
                            case SPUT_CHAR: 
                            case SPUT_OBJECT: 
                            case SPUT_SHORT: 
                            case SPUT_WIDE: {
                                if (!field.getOwner().equals(classNode.className)) break;
                                String key = field.getName() + ":" + field.getType();
                                fs.remove(key);
                                DexFieldNode dn = (DexFieldNode)shouldNotBeAssigned.get(key);
                                if (dn == null) break;
                                dn.cst = null;
                                break;
                            }
                        }
                    }
                });
            } else {
                return;
            }
        }
        for (DexFieldNode fn : fs.values()) {
            fn.cst = DexFix.getDefaultValueOfType(fn.field.getType().charAt(0));
        }
    }

    private static Object getDefaultValueOfType(char t) {
        switch (t) {
            case 'B': {
                return (byte)0;
            }
            case 'Z': {
                return Boolean.FALSE;
            }
            case 'S': {
                return (short)0;
            }
            case 'C': {
                return Character.valueOf('\u0000');
            }
            case 'I': {
                return 0;
            }
            case 'F': {
                return Float.valueOf(0.0f);
            }
            case 'J': {
                return 0L;
            }
            case 'D': {
                return 0.0;
            }
        }
        return null;
    }

    static boolean isPrimitiveZero(String desc, Object value) {
        if (value != null && desc != null && desc.length() > 0) {
            switch (desc.charAt(0)) {
                case 'Z': {
                    return (Boolean)value == false;
                }
                case 'C': {
                    return ((Character)value).charValue() == '\u0000';
                }
                case 'B': {
                    return (Byte)value == 0;
                }
                case 'S': {
                    return (Short)value == 0;
                }
                case 'I': {
                    return (Integer)value == 0;
                }
                case 'F': {
                    return ((Float)value).floatValue() == 0.0f;
                }
                case 'J': {
                    return (Long)value == 0L;
                }
                case 'D': {
                    return (Double)value == 0.0;
                }
            }
        }
        return false;
    }
}

