/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.io;

import com.googlecode.d2j.dex.writer.io.DataOut;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferOut
implements DataOut {
    public final ByteBuffer buffer;

    public ByteBufferOut(ByteBuffer buffer) {
        this.buffer = buffer;
        buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void begin(String s2) {
    }

    @Override
    public void bytes(String s2, byte[] bs) {
        this.buffer.put(bs);
    }

    @Override
    public void bytes(String string, byte[] buf, int offset, int size) {
        this.buffer.put(buf, offset, size);
    }

    public void doUleb128(int value) {
        for (int remaining = value >>> 7; remaining != 0; remaining >>>= 7) {
            this.buffer.put((byte)(value & 0x7F | 0x80));
            value = remaining;
        }
        this.buffer.put((byte)(value & 0x7F));
    }

    @Override
    public void end() {
    }

    @Override
    public int offset() {
        return this.buffer.position();
    }

    @Override
    public void sbyte(String s2, int b) {
        this.buffer.put((byte)b);
    }

    @Override
    public void sint(String s2, int i) {
        this.buffer.putInt(i);
    }

    @Override
    public void skip(String s2, int n) {
        this.buffer.position(this.buffer.position() + n);
    }

    @Override
    public void skip4(String s2) {
        this.buffer.putInt(0);
    }

    @Override
    public void sleb128(String s2, int value) {
        int end;
        int remaining = value >> 7;
        boolean hasMore = true;
        int n = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            this.buffer.put((byte)(value & 0x7F | (hasMore ? 128 : 0)));
            value = remaining;
            remaining >>= 7;
        }
    }

    @Override
    public void sshort(String s2, int i) {
        this.buffer.putShort((short)i);
    }

    @Override
    public void ubyte(String s2, int b) {
        this.buffer.put((byte)b);
    }

    @Override
    public void uint(String s2, int i) {
        this.buffer.putInt(i);
    }

    @Override
    public void uleb128(String s2, int value) {
        this.doUleb128(value);
    }

    @Override
    public void uleb128p1(String s2, int i) {
        this.doUleb128(i + 1);
    }

    @Override
    public void ushort(String s2, int i) {
        this.buffer.putShort((short)i);
    }
}

