/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.jasmin;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.util.Printer;

public class JasminDumper
implements Opcodes {
    private static Set<String> ACCESS_KWS = new HashSet<String>(Arrays.asList("abstract", "private", "protected", "public", "enum", "final", "interface", "static", "strictfp", "native", "super"));
    protected PrintWriter pw;
    protected final Map<Label, String> labelNames = new HashMap<Label, String>();

    public JasminDumper(PrintWriter pw) {
        this.pw = pw;
    }

    static void printIdAfterAccess(PrintWriter out, String id) {
        if (ACCESS_KWS.contains(id)) {
            out.print("\"");
            out.print(id);
            out.print("\"");
        } else {
            out.print(id);
        }
    }

    public void dump(ClassNode cn) {
        this.labelNames.clear();
        this.pw.print(".bytecode ");
        this.pw.print(cn.version & 0xFFFF);
        this.pw.print('.');
        this.pw.println(cn.version >>> 16);
        this.println(".source ", cn.sourceFile);
        this.pw.print(".class");
        this.pw.print(this.access_clz(cn.access));
        this.pw.print(' ');
        JasminDumper.printIdAfterAccess(this.pw, cn.name);
        this.pw.println();
        if (cn.superName != null) {
            this.pw.print(".super ");
            JasminDumper.printIdAfterAccess(this.pw, cn.superName);
            this.pw.println();
        }
        for (String itf : cn.interfaces) {
            this.pw.print(".implements ");
            JasminDumper.printIdAfterAccess(this.pw, itf);
            this.pw.println();
        }
        if (cn.signature != null) {
            this.println(".signature ", '\"' + cn.signature + '\"');
        }
        if (cn.outerClass != null) {
            this.pw.print(".enclosing method ");
            this.pw.print(cn.outerClass);
            if (cn.outerMethod != null) {
                this.pw.print('/');
                this.pw.print(cn.outerMethod);
                this.pw.println(cn.outerMethodDesc);
            } else {
                this.pw.println();
            }
        }
        if ((cn.access & 0x20000) != 0) {
            this.pw.println(".deprecated");
        }
        if (cn.visibleAnnotations != null) {
            for (AnnotationNode an : cn.visibleAnnotations) {
                this.printAnnotation(an, 1, -1);
            }
        }
        if (cn.invisibleAnnotations != null) {
            for (AnnotationNode an : cn.invisibleAnnotations) {
                this.printAnnotation(an, 2, -1);
            }
        }
        this.println(".debug ", cn.sourceDebug == null ? null : '\"' + cn.sourceDebug + '\"');
        for (InnerClassNode in : cn.innerClasses) {
            this.pw.print(".inner class");
            this.pw.print(this.access_clz(in.access & 0xFFFFFFDF));
            if (in.innerName != null) {
                this.pw.print(' ');
                JasminDumper.printIdAfterAccess(this.pw, in.innerName);
            }
            if (in.name != null) {
                this.pw.print(" inner ");
                this.pw.print(in.name);
            }
            if (in.outerName != null) {
                this.pw.print(" outer ");
                this.pw.print(in.outerName);
            }
            this.pw.println();
        }
        for (FieldNode fn : cn.fields) {
            boolean annotations = false;
            if (fn.visibleAnnotations != null && fn.visibleAnnotations.size() > 0) {
                annotations = true;
            }
            if (fn.invisibleAnnotations != null && fn.invisibleAnnotations.size() > 0) {
                annotations = true;
            }
            boolean deprecated = (fn.access & 0x20000) != 0;
            this.pw.print("\n.field");
            this.pw.print(this.access_fld(fn.access));
            this.pw.print(' ');
            JasminDumper.printIdAfterAccess(this.pw, fn.name);
            this.pw.print(' ');
            this.pw.print(fn.desc);
            if (fn.value instanceof String) {
                StringBuilder buf = new StringBuilder();
                Printer.appendString(buf, (String)fn.value);
                this.pw.print(" = ");
                this.pw.print(buf.toString());
            } else if (fn.value != null) {
                this.pw.print(" = ");
                this.print(fn.value);
            }
            this.pw.println();
            if (fn.signature != null) {
                this.pw.print(".signature \"");
                this.pw.print(fn.signature);
                this.pw.println("\"");
            }
            if (deprecated) {
                this.pw.println(".deprecated");
            }
            if (fn.visibleAnnotations != null) {
                for (AnnotationNode an : fn.visibleAnnotations) {
                    this.printAnnotation(an, 1, -1);
                }
            }
            if (fn.invisibleAnnotations != null) {
                for (AnnotationNode an : fn.invisibleAnnotations) {
                    this.printAnnotation(an, 2, -1);
                }
            }
            if (fn.signature == null && !deprecated && !annotations) continue;
            this.pw.println(".end field");
        }
        for (MethodNode mn : cn.methods) {
            this.pw.print("\n.method");
            this.pw.print(this.access_mtd(mn.access));
            this.pw.print(' ');
            JasminDumper.printIdAfterAccess(this.pw, mn.name);
            this.pw.println(mn.desc);
            if (mn.signature != null) {
                this.pw.print(".signature \"");
                this.pw.print(mn.signature);
                this.pw.println("\"");
            }
            if (mn.annotationDefault != null) {
                this.pw.println(".annotation default");
                this.printAnnotationValue(mn.annotationDefault);
                this.pw.println(".end annotation");
            }
            if (mn.visibleAnnotations != null) {
                for (AnnotationNode an : mn.visibleAnnotations) {
                    this.printAnnotation(an, 1, -1);
                }
            }
            if (mn.invisibleAnnotations != null) {
                for (AnnotationNode an : mn.invisibleAnnotations) {
                    this.printAnnotation(an, 2, -1);
                }
            }
            if (mn.visibleParameterAnnotations != null) {
                for (int j = 0; j < mn.visibleParameterAnnotations.length; ++j) {
                    List<AnnotationNode> pas = mn.visibleParameterAnnotations[j];
                    if (pas == null) continue;
                    for (AnnotationNode an : pas) {
                        this.printAnnotation(an, 1, j + 1);
                    }
                }
            }
            if (mn.invisibleParameterAnnotations != null) {
                for (int j = 0; j < mn.invisibleParameterAnnotations.length; ++j) {
                    List<AnnotationNode> pas = mn.invisibleParameterAnnotations[j];
                    if (pas == null) continue;
                    for (AnnotationNode an : pas) {
                        this.printAnnotation(an, 2, j + 1);
                    }
                }
            }
            for (String ex : mn.exceptions) {
                this.println(".throws ", ex);
            }
            if ((mn.access & 0x20000) != 0) {
                this.pw.println(".deprecated");
            }
            if (mn.instructions != null && mn.instructions.size() > 0) {
                this.labelNames.clear();
                if (mn.tryCatchBlocks != null) {
                    for (TryCatchBlockNode tcb : mn.tryCatchBlocks) {
                        this.pw.print(".catch ");
                        this.pw.print(tcb.type == null ? "all" : ("all".equals(tcb.type) ? "\\u0097ll" : tcb.type));
                        this.pw.print(" from ");
                        this.print(tcb.start);
                        this.pw.print(" to ");
                        this.print(tcb.end);
                        this.pw.print(" using ");
                        this.print(tcb.handler);
                        this.pw.println();
                    }
                }
                for (int j = 0; j < mn.instructions.size(); ++j) {
                    AbstractInsnNode in = mn.instructions.get(j);
                    if (in.getType() != 15 && in.getType() != 14) {
                        if (in.getType() == 8) {
                            this.pw.print("  ");
                        } else {
                            this.pw.print("    ");
                        }
                    }
                    in.accept(new MethodVisitor(262144){

                        @Override
                        public void visitInsn(int opcode) {
                            JasminDumper.this.print(opcode);
                            JasminDumper.this.pw.println();
                        }

                        @Override
                        public void visitIntInsn(int opcode, int operand) {
                            JasminDumper.this.print(opcode);
                            if (opcode == 188) {
                                switch (operand) {
                                    case 4: {
                                        JasminDumper.this.pw.println(" boolean");
                                        break;
                                    }
                                    case 5: {
                                        JasminDumper.this.pw.println(" char");
                                        break;
                                    }
                                    case 6: {
                                        JasminDumper.this.pw.println(" float");
                                        break;
                                    }
                                    case 7: {
                                        JasminDumper.this.pw.println(" double");
                                        break;
                                    }
                                    case 8: {
                                        JasminDumper.this.pw.println(" byte");
                                        break;
                                    }
                                    case 9: {
                                        JasminDumper.this.pw.println(" short");
                                        break;
                                    }
                                    case 10: {
                                        JasminDumper.this.pw.println(" int");
                                        break;
                                    }
                                    default: {
                                        JasminDumper.this.pw.println(" long");
                                        break;
                                    }
                                }
                            } else {
                                JasminDumper.this.pw.print(' ');
                                JasminDumper.this.pw.println(operand);
                            }
                        }

                        @Override
                        public void visitVarInsn(int opcode, int var) {
                            JasminDumper.this.print(opcode);
                            JasminDumper.this.pw.print(' ');
                            JasminDumper.this.pw.println(var);
                        }

                        @Override
                        public void visitTypeInsn(int opcode, String type) {
                            JasminDumper.this.print(opcode);
                            JasminDumper.this.pw.print(' ');
                            JasminDumper.this.pw.println(type);
                        }

                        @Override
                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            JasminDumper.this.print(opcode);
                            JasminDumper.this.pw.print(' ');
                            JasminDumper.this.pw.print(owner);
                            JasminDumper.this.pw.print('/');
                            JasminDumper.this.pw.print(name);
                            JasminDumper.this.pw.print(' ');
                            JasminDumper.this.pw.println(desc);
                        }

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            JasminDumper.this.print(opcode);
                            JasminDumper.this.pw.print(' ');
                            JasminDumper.this.pw.print(owner);
                            JasminDumper.this.pw.print('/');
                            JasminDumper.this.pw.print(name);
                            JasminDumper.this.pw.print(desc);
                            if (opcode == 185) {
                                JasminDumper.this.pw.print(' ');
                                JasminDumper.this.pw.print((Type.getArgumentsAndReturnSizes(desc) >> 2) - 1);
                            }
                            JasminDumper.this.pw.println();
                        }

                        @Override
                        public void visitJumpInsn(int opcode, Label label) {
                            JasminDumper.this.print(opcode);
                            JasminDumper.this.pw.print(' ');
                            JasminDumper.this.print(label);
                            JasminDumper.this.pw.println();
                        }

                        @Override
                        public void visitLabel(Label label) {
                            JasminDumper.this.print(label);
                            JasminDumper.this.pw.println(':');
                        }

                        @Override
                        public void visitLdcInsn(Object cst) {
                            if (cst instanceof Integer || cst instanceof Float) {
                                JasminDumper.this.pw.print("ldc_w ");
                                JasminDumper.this.print(cst);
                            } else if (cst instanceof Long || cst instanceof Double) {
                                JasminDumper.this.pw.print("ldc2_w ");
                                JasminDumper.this.print(cst);
                            } else {
                                JasminDumper.this.pw.print("ldc ");
                                if (cst instanceof Type) {
                                    JasminDumper.this.pw.print(((Type)cst).getInternalName());
                                } else {
                                    JasminDumper.this.print(cst);
                                }
                            }
                            JasminDumper.this.pw.println();
                        }

                        @Override
                        public void visitIincInsn(int var, int increment) {
                            JasminDumper.this.pw.print("iinc ");
                            JasminDumper.this.pw.print(var);
                            JasminDumper.this.pw.print(' ');
                            JasminDumper.this.pw.println(increment);
                        }

                        @Override
                        public void visitTableSwitchInsn(int min2, int max, Label dflt, Label ... labels) {
                            JasminDumper.this.pw.print("tableswitch ");
                            JasminDumper.this.pw.println(min2);
                            for (Label label : labels) {
                                JasminDumper.this.pw.print("      ");
                                JasminDumper.this.print(label);
                                JasminDumper.this.pw.println();
                            }
                            JasminDumper.this.pw.print("      default : ");
                            JasminDumper.this.print(dflt);
                            JasminDumper.this.pw.println();
                        }

                        @Override
                        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                            JasminDumper.this.pw.println("lookupswitch");
                            for (int i = 0; i < keys.length; ++i) {
                                JasminDumper.this.pw.print("      ");
                                JasminDumper.this.pw.print(keys[i]);
                                JasminDumper.this.pw.print(" : ");
                                JasminDumper.this.print(labels[i]);
                                JasminDumper.this.pw.println();
                            }
                            JasminDumper.this.pw.print("      default : ");
                            JasminDumper.this.print(dflt);
                            JasminDumper.this.pw.println();
                        }

                        @Override
                        public void visitMultiANewArrayInsn(String desc, int dims) {
                            JasminDumper.this.pw.print("multianewarray ");
                            JasminDumper.this.pw.print(desc);
                            JasminDumper.this.pw.print(' ');
                            JasminDumper.this.pw.println(dims);
                        }

                        @Override
                        public void visitLineNumber(int line, Label start) {
                            JasminDumper.this.pw.print(".line ");
                            JasminDumper.this.pw.println(line);
                        }
                    });
                }
                if (mn.localVariables != null) {
                    for (LocalVariableNode lv : mn.localVariables) {
                        this.pw.print("  .var ");
                        this.pw.print(lv.index);
                        this.pw.print(" is '");
                        this.pw.print(lv.name);
                        this.pw.print("' ");
                        this.pw.print(lv.desc);
                        if (lv.signature != null) {
                            this.pw.print(" signature \"");
                            this.pw.print(lv.signature);
                            this.pw.print("\"");
                        }
                        this.pw.print(" from ");
                        this.print(lv.start);
                        this.pw.print(" to ");
                        this.print(lv.end);
                        this.pw.println();
                    }
                }
                this.println("  .limit locals ", Integer.toString(mn.maxLocals));
                this.println("  .limit stack ", Integer.toString(mn.maxStack));
            }
            this.pw.println(".end method");
        }
    }

    protected void println(String directive, String arg) {
        if (arg != null) {
            this.pw.print(directive);
            this.pw.println(arg);
        }
    }

    protected String access_clz(int access) {
        StringBuilder b = new StringBuilder();
        if ((access & 1) != 0) {
            b.append(" public");
        }
        if ((access & 2) != 0) {
            b.append(" private");
        }
        if ((access & 4) != 0) {
            b.append(" protected");
        }
        if ((access & 0x10) != 0) {
            b.append(" final");
        }
        if ((access & 0x20) != 0) {
            b.append(" super");
        }
        if ((access & 0x400) != 0) {
            b.append(" abstract");
        }
        if ((access & 0x200) != 0) {
            b.append(" interface");
        }
        if ((access & 0x1000) != 0) {
            b.append(" synthetic");
        }
        if ((access & 0x2000) != 0) {
            b.append(" annotation");
        }
        if ((access & 0x4000) != 0) {
            b.append(" enum");
        }
        return b.toString();
    }

    protected String access_fld(int access) {
        StringBuilder b = new StringBuilder();
        if ((access & 1) != 0) {
            b.append(" public");
        }
        if ((access & 2) != 0) {
            b.append(" private");
        }
        if ((access & 4) != 0) {
            b.append(" protected");
        }
        if ((access & 8) != 0) {
            b.append(" static");
        }
        if ((access & 0x10) != 0) {
            b.append(" final");
        }
        if ((access & 0x40) != 0) {
            b.append(" volatile");
        }
        if ((access & 0x80) != 0) {
            b.append(" transient");
        }
        if ((access & 0x1000) != 0) {
            b.append(" synthetic");
        }
        if ((access & 0x4000) != 0) {
            b.append(" enum");
        }
        return b.toString();
    }

    protected String access_mtd(int access) {
        StringBuilder b = new StringBuilder();
        if ((access & 1) != 0) {
            b.append(" public");
        }
        if ((access & 2) != 0) {
            b.append(" private");
        }
        if ((access & 4) != 0) {
            b.append(" protected");
        }
        if ((access & 8) != 0) {
            b.append(" static");
        }
        if ((access & 0x10) != 0) {
            b.append(" final");
        }
        if ((access & 0x20) != 0) {
            b.append(" synchronized");
        }
        if ((access & 0x40) != 0) {
            b.append(" bridge");
        }
        if ((access & 0x80) != 0) {
            b.append(" varargs");
        }
        if ((access & 0x100) != 0) {
            b.append(" native");
        }
        if ((access & 0x400) != 0) {
            b.append(" abstract");
        }
        if ((access & 0x800) != 0) {
            b.append(" strict");
        }
        if ((access & 0x1000) != 0) {
            b.append(" synthetic");
        }
        return b.toString();
    }

    protected void print(int opcode) {
        this.pw.print(Printer.OPCODES[opcode].toLowerCase());
    }

    protected void print(Object cst) {
        if (cst instanceof String) {
            StringBuilder buf = new StringBuilder();
            Printer.appendString(buf, (String)cst);
            this.pw.print(buf.toString());
        } else if (cst instanceof Float) {
            Float f = (Float)cst;
            if (!f.isNaN() && !f.isInfinite()) {
                this.pw.print(cst + "F");
            } else if (f.isNaN()) {
                this.pw.print("floatnan");
            } else {
                double v = f.floatValue();
                if (v == Double.POSITIVE_INFINITY) {
                    this.pw.print("+floatinfinity");
                } else {
                    this.pw.print("-floatinfinity");
                }
            }
        } else if (cst instanceof Double) {
            Double d = (Double)cst;
            if (!d.isNaN() && !d.isInfinite()) {
                this.pw.print(cst + "D");
            } else if (d.isNaN()) {
                this.pw.print("doublenan");
            } else {
                double v = d;
                if (v == Double.POSITIVE_INFINITY) {
                    this.pw.print("+doubleinfinity");
                } else {
                    this.pw.print("-doubleinfinity");
                }
            }
        } else if (cst instanceof Long) {
            this.pw.print(cst + "L");
        } else {
            this.pw.print(cst);
        }
    }

    protected void print(Label l) {
        String name = this.labelNames.get(l);
        if (name == null) {
            name = "L" + this.labelNames.size();
            this.labelNames.put(l, name);
        }
        this.pw.print(name);
    }

    protected void print(LabelNode l) {
        this.print(l.getLabel());
    }

    protected void printAnnotation(AnnotationNode n, int visible, int param) {
        this.pw.print(".annotation ");
        if (visible > 0) {
            if (param == -1) {
                this.pw.print(visible == 1 ? "visible " : "invisible ");
            } else {
                this.pw.print(visible == 1 ? "visibleparam " : "invisibleparam ");
                this.pw.print(param);
                this.pw.print(' ');
            }
            this.pw.print(n.desc);
        }
        this.pw.println();
        if (n.values != null) {
            for (int i = 0; i < n.values.size(); i += 2) {
                this.pw.print(n.values.get(i));
                this.pw.print(' ');
                this.printAnnotationValue(n.values.get(i + 1));
            }
        }
        this.pw.println(".end annotation");
    }

    protected void printAnnotationValue(Object value) {
        if (value instanceof String[]) {
            this.pw.print("e ");
            this.pw.print(((String[])value)[0]);
            this.pw.print(" = ");
            this.pw.print(((String[])value)[1]);
            this.pw.println();
        } else if (value instanceof AnnotationNode) {
            this.pw.print("@ ");
            this.pw.print(((AnnotationNode)value).desc);
            this.pw.print(" = ");
            this.printAnnotation((AnnotationNode)value, 0, -1);
        } else if (value instanceof byte[]) {
            byte[] v;
            this.pw.print("[B = ");
            for (byte element : v = (byte[])value) {
                this.pw.print(element);
                this.pw.print(' ');
            }
            this.pw.println();
        } else if (value instanceof boolean[]) {
            boolean[] v;
            this.pw.print("[Z = ");
            for (boolean element : v = (boolean[])value) {
                this.pw.print(element ? (char)'1' : '0');
                this.pw.print(' ');
            }
            this.pw.println();
        } else if (value instanceof short[]) {
            short[] v;
            this.pw.print("[S = ");
            for (short element : v = (short[])value) {
                this.pw.print(element);
                this.pw.print(' ');
            }
            this.pw.println();
        } else if (value instanceof char[]) {
            char[] v;
            this.pw.print("[C = ");
            for (char element : v = (char[])value) {
                this.pw.print(new Integer(element));
                this.pw.print(' ');
            }
            this.pw.println();
        } else if (value instanceof int[]) {
            int[] v;
            this.pw.print("[I = ");
            for (int element : v = (int[])value) {
                this.pw.print(element);
                this.pw.print(' ');
            }
            this.pw.println();
        } else if (value instanceof long[]) {
            long[] v;
            this.pw.print("[J = ");
            for (long element : v = (long[])value) {
                this.pw.print(element);
                this.pw.print(' ');
            }
            this.pw.println();
        } else if (value instanceof float[]) {
            float[] v;
            this.pw.print("[F = ");
            for (float element : v = (float[])value) {
                this.print(new Float(element));
                this.pw.print(' ');
            }
            this.pw.println();
        } else if (value instanceof double[]) {
            double[] v;
            this.pw.print("[D = ");
            for (double element : v = (double[])value) {
                this.print(new Double(element));
                this.pw.print(' ');
            }
            this.pw.println();
        } else if (value instanceof List) {
            List l = (List)value;
            if (l.size() > 0) {
                Object o = l.get(0);
                if (o instanceof String[]) {
                    this.pw.print("[e ");
                    this.pw.print(((String[])o)[0]);
                    this.pw.print(" = ");
                } else if (o instanceof AnnotationNode) {
                    this.pw.print("[& ");
                    this.pw.print(((AnnotationNode)o).desc);
                    this.pw.print(" = ");
                    this.pw.print("[@ = ");
                } else if (o instanceof String) {
                    this.pw.print("[s = ");
                } else if (o instanceof Byte) {
                    this.pw.print("[B = ");
                } else if (o instanceof Boolean) {
                    this.pw.print("[Z = ");
                } else if (o instanceof Character) {
                    this.pw.print("[C = ");
                } else if (o instanceof Short) {
                    this.pw.print("[S = ");
                } else if (o instanceof Type) {
                    this.pw.print("[c = ");
                } else if (o instanceof Integer) {
                    this.pw.print("[I = ");
                } else if (o instanceof Float) {
                    this.pw.print("[F = ");
                } else if (o instanceof Long) {
                    this.pw.print("[J = ");
                } else if (o instanceof Double) {
                    this.pw.print("[D = ");
                }
                for (Object aL : l) {
                    this.printAnnotationArrayValue(aL);
                    this.pw.print(' ');
                }
            } else {
                this.pw.print("; empty array annotation value");
            }
            this.pw.println();
        } else if (value instanceof String) {
            this.pw.print("s = ");
            this.print(value);
            this.pw.println();
        } else if (value instanceof Byte) {
            this.pw.print("B = ");
            this.pw.println(((Byte)value).intValue());
        } else if (value instanceof Boolean) {
            this.pw.print("Z = ");
            this.pw.println((Boolean)value != false ? 1 : 0);
        } else if (value instanceof Character) {
            this.pw.print("C = ");
            this.pw.println(new Integer(((Character)value).charValue()));
        } else if (value instanceof Short) {
            this.pw.print("S = ");
            this.pw.println(((Short)value).intValue());
        } else if (value instanceof Type) {
            this.pw.print("c = ");
            this.pw.println(((Type)value).getDescriptor());
        } else if (value instanceof Integer) {
            this.pw.print("I = ");
            this.print(value);
            this.pw.println();
        } else if (value instanceof Float) {
            this.pw.print("F = ");
            this.print(value);
            this.pw.println();
        } else if (value instanceof Long) {
            this.pw.print("J = ");
            this.print(value);
            this.pw.println();
        } else if (value instanceof Double) {
            this.pw.print("D = ");
            this.print(value);
            this.pw.println();
        } else {
            throw new RuntimeException();
        }
    }

    protected void printAnnotationArrayValue(Object value) {
        if (value instanceof String[]) {
            this.print(((String[])value)[1]);
        } else if (value instanceof AnnotationNode) {
            this.printAnnotation((AnnotationNode)value, 0, -1);
        } else if (value instanceof String) {
            this.print(value);
        } else if (value instanceof Byte) {
            this.pw.print(((Byte)value).intValue());
        } else if (value instanceof Boolean) {
            this.pw.print((Boolean)value != false ? 1 : 0);
        } else if (value instanceof Character) {
            this.pw.print(new Integer(((Character)value).charValue()));
        } else if (value instanceof Short) {
            this.pw.print(((Short)value).intValue());
        } else if (value instanceof Type) {
            this.pw.print(((Type)value).getDescriptor());
        } else {
            this.print(value);
        }
    }

    protected void printFrameType(Object type) {
        if (type == Opcodes.TOP) {
            this.pw.print("Top");
        } else if (type == Opcodes.INTEGER) {
            this.pw.print("Integer");
        } else if (type == Opcodes.FLOAT) {
            this.pw.print("Float");
        } else if (type == Opcodes.LONG) {
            this.pw.print("Long");
        } else if (type == Opcodes.DOUBLE) {
            this.pw.print("Double");
        } else if (type == Opcodes.NULL) {
            this.pw.print("Null");
        } else if (type == Opcodes.UNINITIALIZED_THIS) {
            this.pw.print("UninitializedThis");
        } else if (type instanceof Label) {
            this.pw.print("Uninitialized ");
            this.print((Label)type);
        } else {
            this.pw.print("Object ");
            this.pw.print(type);
        }
    }
}

