/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.reader.zip.ZipUtil;
import com.googlecode.d2j.smali.BaksmaliDexFileVisitor;
import com.googlecode.d2j.smali.BaksmaliDumper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;

public class Baksmali {
    boolean noDebug = false;
    boolean parameterRegisters = true;
    DexFileReader reader;
    boolean useLocals = false;

    private Baksmali() {
    }

    public static Baksmali from(byte[] in) throws IOException {
        return Baksmali.from(new DexFileReader(in));
    }

    public static Baksmali from(ByteBuffer in) throws IOException {
        return Baksmali.from(new DexFileReader(in));
    }

    public static Baksmali from(DexFileReader reader) {
        return new Baksmali(reader);
    }

    public static Baksmali from(File in) throws IOException {
        return Baksmali.from(ZipUtil.readDex(in));
    }

    public static Baksmali from(Path in) throws IOException {
        return Baksmali.from(ZipUtil.readDex(in));
    }

    public static Baksmali from(InputStream in) throws IOException {
        return Baksmali.from(ZipUtil.readDex(in));
    }

    public static Baksmali from(String in) throws IOException {
        return Baksmali.from(new File(in));
    }

    private Baksmali(DexFileReader reader) {
        this.reader = reader;
    }

    public Baksmali noDebug() {
        this.noDebug = true;
        return this;
    }

    public Baksmali noParameterRegisters() {
        this.parameterRegisters = false;
        return this;
    }

    public void to(File dir) {
        this.to(dir.toPath());
    }

    public void to(Path base) {
        BaksmaliDumper bs = new BaksmaliDumper(this.parameterRegisters, this.useLocals);
        this.reader.accept(new BaksmaliDexFileVisitor(base, bs), this.noDebug ? 4 : 0);
    }

    public Baksmali useLocals() {
        this.useLocals = true;
        return this;
    }
}

