/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.MethodHandle;
import com.googlecode.d2j.Proto;
import com.googlecode.d2j.node.DexDebugNode;
import com.googlecode.d2j.reader.InstructionFormat;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.smali.BaksmaliDumper;
import com.googlecode.d2j.util.Out;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexDebugVisitor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class BaksmaliCodeDumper
extends DexCodeVisitor {
    private boolean useParameterRegisters;
    private boolean useLocals;
    private int nextLabelNumber;
    private Out out;
    final int startParamR;
    final Set<DexLabel> usedLabel;
    final Map<DexLabel, List<DexDebugNode.DexDebugOpNode>> debugLabelMap;
    List<Map.Entry<DexLabel, Object>> appendLast = new ArrayList<Map.Entry<DexLabel, Object>>();
    DexDebugVisitor debugDumper = new DexDebugVisitor(){

        @Override
        public void visitStartLocal(int reg, DexLabel label, String name, String type, String signature) {
            super.visitStartLocal(reg, label, name, type, signature);
            if (signature == null) {
                BaksmaliCodeDumper.this.out.s(".local %s, %s:%s", BaksmaliCodeDumper.this.reg(reg), BaksmaliDumper.escapeValue(name), type);
            } else {
                BaksmaliCodeDumper.this.out.s(".local %s, %s:%s, %s", BaksmaliCodeDumper.this.reg(reg), BaksmaliDumper.escapeValue(name), type, BaksmaliDumper.escapeValue(signature));
            }
        }

        @Override
        public void visitPrologue(DexLabel dexLabel) {
            BaksmaliCodeDumper.this.out.s(".prologue");
        }

        @Override
        public void visitEpiogue(DexLabel dexLabel) {
            BaksmaliCodeDumper.this.out.s(".epiogue");
        }

        @Override
        public void visitLineNumber(int line, DexLabel label) {
            BaksmaliCodeDumper.this.out.s(".line %d", line);
        }

        @Override
        public void visitEndLocal(int reg, DexLabel label) {
            BaksmaliCodeDumper.this.out.s(".end local %s", BaksmaliCodeDumper.this.reg(reg));
        }

        @Override
        public void visitRestartLocal(int reg, DexLabel label) {
            BaksmaliCodeDumper.this.out.s(".restart local %s", BaksmaliCodeDumper.this.reg(reg));
        }
    };

    public BaksmaliCodeDumper(Out out, boolean useParameterRegisters, boolean useLocals, int nextLabelNumber, int startParamR, Set<DexLabel> usedLabel, Map<DexLabel, List<DexDebugNode.DexDebugOpNode>> debugLabelMap) {
        this.out = out;
        this.useParameterRegisters = useParameterRegisters;
        this.useLocals = useLocals;
        this.nextLabelNumber = nextLabelNumber;
        this.startParamR = startParamR;
        this.usedLabel = usedLabel;
        this.debugLabelMap = debugLabelMap;
    }

    String reg(int rdx) {
        if (this.useParameterRegisters && rdx >= this.startParamR) {
            return "p" + (rdx - this.startParamR);
        }
        return "v" + rdx;
    }

    @Override
    public void visitFillArrayDataStmt(Op op, int ra, Object array) {
        DexLabel dx = new DexLabel();
        dx.displayName = "L" + this.nextLabelNumber++;
        this.usedLabel.add(dx);
        this.out.s("%s %s, %s", op.displayName, this.reg(ra), this.xLabel(dx));
        this.appendLast.add(new AbstractMap.SimpleEntry<DexLabel, Object>(dx, array));
    }

    @Override
    public void visitConstStmt(Op op, int ra, Object value) {
        switch (op) {
            case CONST_WIDE_16: {
                Long v = (Long)value;
                value = (int)v.shortValue();
                break;
            }
            case CONST_WIDE_HIGH16: {
                Long v = (Long)value;
                value = (int)((short)(v >> 48));
                break;
            }
            case CONST_WIDE_32: {
                Long v = (Long)value;
                value = v.intValue();
                break;
            }
            case CONST_HIGH16: {
                Integer v = (Integer)value;
                value = v >> 16;
                break;
            }
        }
        this.out.s("%s %s, %s", op.displayName, this.reg(ra), BaksmaliDumper.escapeValue(value));
        super.visitConstStmt(op, ra, value);
    }

    @Override
    public void visitEnd() {
        for (Map.Entry<DexLabel, Object> e : this.appendLast) {
            int b;
            int a;
            int a2;
            int i;
            this.visitLabel(e.getKey());
            Object v = e.getValue();
            if (v instanceof SparseSwitchStmt) {
                SparseSwitchStmt ss = (SparseSwitchStmt)v;
                this.out.s(".sparse-switch");
                this.out.push();
                for (int i2 = 0; i2 < ss.cases.length; ++i2) {
                    this.out.s("%d -> %s", ss.cases[i2], this.xLabel(ss.labels[i2]));
                }
                this.out.pop();
                this.out.s(".end sparse-switch");
                continue;
            }
            if (v instanceof PackedSwitchStmt) {
                PackedSwitchStmt ps = (PackedSwitchStmt)v;
                this.out.s(".packed-switch %d", ps.first_case);
                this.out.push();
                for (DexLabel label : ps.labels) {
                    this.out.s(this.xLabel(label));
                }
                this.out.pop();
                this.out.s(".end packed-switch");
                continue;
            }
            Object array = e.getValue();
            if (array instanceof byte[]) {
                this.out.s(".array-data 1");
                this.out.push();
                byte[] vs = (byte[])array;
                for (i = 0; i < vs.length; ++i) {
                    this.out.s(BaksmaliDumper.escapeValue(vs[i]));
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (array instanceof short[]) {
                this.out.s(".array-data 2");
                this.out.push();
                short[] vs = (short[])array;
                for (i = 0; i < vs.length; ++i) {
                    a2 = vs[i];
                    this.out.s("%s %s", BaksmaliDumper.escapeValue((byte)(a2 & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a2 >> 8)));
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (array instanceof int[]) {
                this.out.s(".array-data 4");
                this.out.push();
                int[] vs = (int[])array;
                for (i = 0; i < vs.length; ++i) {
                    a2 = vs[i];
                    this.out.s("%s %s %s %s", BaksmaliDumper.escapeValue((byte)(a2 & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a2 >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & a2 >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & a2 >> 24)));
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (array instanceof float[]) {
                this.out.s(".array-data 4");
                this.out.push();
                float[] vs = (float[])array;
                for (i = 0; i < vs.length; ++i) {
                    a2 = Float.floatToIntBits(vs[i]);
                    this.out.s("%s %s %s %s", BaksmaliDumper.escapeValue((byte)(a2 & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a2 >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & a2 >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & a2 >> 24)));
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (array instanceof long[]) {
                this.out.s(".array-data 8");
                this.out.push();
                long[] vs = (long[])array;
                for (i = 0; i < vs.length; ++i) {
                    long ttt = vs[i];
                    a = (int)ttt;
                    b = (int)(ttt >>> 32);
                    this.out.s("%s %s %s %s %s %s %s %s", BaksmaliDumper.escapeValue((byte)(a & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 24)), BaksmaliDumper.escapeValue((byte)(b & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 24)));
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (!(array instanceof double[])) continue;
            this.out.s(".array-data 8");
            this.out.push();
            double[] vs = (double[])array;
            for (i = 0; i < vs.length; ++i) {
                long ttt = Double.doubleToLongBits(vs[i]);
                a = (int)ttt;
                b = (int)(ttt >>> 32);
                this.out.s("%s %s %s %s %s %s %s %s", BaksmaliDumper.escapeValue((byte)(a & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 24)), BaksmaliDumper.escapeValue((byte)(b & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 24)));
            }
            this.out.pop();
            this.out.s(".end array-data");
        }
    }

    @Override
    public void visitFieldStmt(Op op, int a, int b, Field field) {
        if (op.format == InstructionFormat.kFmt22c) {
            this.out.s("%s %s, %s, %s", op.displayName, this.reg(a), this.reg(b), BaksmaliDumper.escapeField(field));
        } else {
            this.out.s("%s %s, %s", op.displayName, this.reg(a), BaksmaliDumper.escapeField(field));
        }
    }

    @Override
    public void visitFilledNewArrayStmt(Op op, int[] args, String type) {
        if (args.length > 0) {
            if (op.format == InstructionFormat.kFmt3rc) {
                this.out.s("%s { %s .. %s }, %s", op.displayName, this.reg(args[0]), this.reg(args[args.length - 1]), BaksmaliDumper.escapeType(type));
            } else {
                StringBuilder buff = new StringBuilder();
                boolean first = true;
                for (int i : args) {
                    if (first) {
                        first = false;
                    } else {
                        buff.append(", ");
                    }
                    buff.append(this.reg(i));
                }
                this.out.s("%s { %s }, %s", op.displayName, buff, BaksmaliDumper.escapeType(type));
            }
        } else {
            this.out.s("%s { }, %s", op.displayName, BaksmaliDumper.escapeType(type));
        }
    }

    @Override
    public void visitJumpStmt(Op op, int a, int b, DexLabel label) {
        if (op.format == InstructionFormat.kFmt21t || op.format == InstructionFormat.kFmt31t) {
            this.out.s(op.displayName + " " + this.reg(a) + ", " + this.xLabel(label));
        } else if (op.format == InstructionFormat.kFmt22t) {
            this.out.s(op.displayName + " " + this.reg(a) + ", " + this.reg(b) + ", " + this.xLabel(label));
        } else {
            this.out.s(op.displayName + " " + this.xLabel(label));
        }
    }

    @Override
    public void visitLabel(DexLabel label) {
        List<DexDebugNode.DexDebugOpNode> dOps;
        if (this.usedLabel.contains(label)) {
            this.out.s(this.xLabel(label));
        }
        if ((dOps = this.debugLabelMap.get(label)) != null) {
            for (DexDebugNode.DexDebugOpNode dOp : dOps) {
                dOp.accept(this.debugDumper);
            }
        }
    }

    @Override
    public final DexDebugVisitor visitDebug() {
        return null;
    }

    @Override
    public void visitMethodStmt(Op op, int[] args, Method method) {
        if (args.length > 0) {
            if (op.format == InstructionFormat.kFmt3rc) {
                this.out.s("%s { %s .. %s }, %s", op.displayName, this.reg(args[0]), this.reg(args[args.length - 1]), BaksmaliDumper.escapeMethod(method));
            } else {
                boolean first = true;
                StringBuilder buff = new StringBuilder();
                for (int i : args) {
                    if (first) {
                        first = false;
                    } else {
                        buff.append(", ");
                    }
                    buff.append(this.reg(i));
                }
                this.out.s("%s { %s }, %s", op.displayName, buff, BaksmaliDumper.escapeMethod(method));
            }
        } else {
            this.out.s("%s { }, %s", op.displayName, BaksmaliDumper.escapeMethod(method));
        }
    }

    @Override
    public void visitMethodStmt(Op op, int[] args, Method method, Proto proto) {
        if (args.length > 0) {
            if (op.format == InstructionFormat.kFmt4rcc) {
                this.out.s("%s { %s .. %s }, %s, %s", op.displayName, this.reg(args[0]), this.reg(args[args.length - 1]), BaksmaliDumper.escapeMethod(method), BaksmaliDumper.escapeMethodDesc(proto));
            } else {
                boolean first = true;
                StringBuilder buff = new StringBuilder();
                for (int i : args) {
                    if (first) {
                        first = false;
                    } else {
                        buff.append(", ");
                    }
                    buff.append(this.reg(i));
                }
                this.out.s("%s { %s }, %s, %s", op.displayName, buff, BaksmaliDumper.escapeMethod(method), BaksmaliDumper.escapeMethodDesc(proto));
            }
        } else {
            this.out.s("%s { }, %s, %s", op.displayName, BaksmaliDumper.escapeMethod(method), BaksmaliDumper.escapeMethodDesc(proto));
        }
    }

    @Override
    public void visitMethodStmt(Op op, int[] args, String name, Proto proto, MethodHandle bsm, Object ... bsmArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ").append(BaksmaliDumper.escapeValue(bsm)).append(", ").append(BaksmaliDumper.escapeValue(name)).append(", ").append(BaksmaliDumper.escapeMethodDesc(proto));
        for (Object o : bsmArgs) {
            sb.append(", ").append(BaksmaliDumper.escapeValue(o));
        }
        sb.append("}");
        if (args.length > 0) {
            if (op.format == InstructionFormat.kFmt3rc) {
                this.out.s("%s { %s .. %s }, %s", op.displayName, this.reg(args[0]), this.reg(args[args.length - 1]), sb);
            } else {
                boolean first = true;
                StringBuilder buff = new StringBuilder();
                for (int i : args) {
                    if (first) {
                        first = false;
                    } else {
                        buff.append(", ");
                    }
                    buff.append(this.reg(i));
                }
                this.out.s("%s { %s }, %s", op.displayName, buff, sb);
            }
        } else {
            this.out.s("%s { }, %s", op.displayName, sb);
        }
    }

    @Override
    public void visitPackedSwitchStmt(Op op, int ra, int first_case, DexLabel[] labels) {
        DexLabel dx = new DexLabel();
        dx.displayName = "L" + this.nextLabelNumber++;
        this.usedLabel.add(dx);
        this.out.s(op.displayName + " " + this.reg(ra) + ", " + this.xLabel(dx));
        this.appendLast.add(new AbstractMap.SimpleEntry<DexLabel, PackedSwitchStmt>(dx, new PackedSwitchStmt(first_case, labels)));
    }

    @Override
    public void visitRegister(int total) {
        if (this.useLocals) {
            this.out.s(".locals %d", this.startParamR);
        } else {
            this.out.s(".registers %d", total);
        }
    }

    @Override
    public void visitSparseSwitchStmt(Op op, int ra, int[] cases, DexLabel[] labels) {
        DexLabel dx = new DexLabel();
        dx.displayName = "L" + this.nextLabelNumber++;
        this.usedLabel.add(dx);
        this.out.s(op.displayName + " " + this.reg(ra) + ", " + this.xLabel(dx));
        this.appendLast.add(new AbstractMap.SimpleEntry<DexLabel, SparseSwitchStmt>(dx, new SparseSwitchStmt(cases, labels)));
    }

    @Override
    public void visitStmt0R(Op op) {
        if (op == Op.BAD_OP) {
            this.out.s("%s # bad op", Op.NOP.displayName);
        } else {
            this.out.s(op.displayName);
        }
    }

    @Override
    public void visitStmt1R(Op op, int a) {
        this.out.s(op.displayName + " " + this.reg(a));
    }

    @Override
    public void visitStmt2R(Op op, int a, int b) {
        this.out.s(op.displayName + " " + this.reg(a) + ", " + this.reg(b));
    }

    @Override
    public void visitStmt2R1N(Op op, int a, int b, int content) {
        this.out.s("%s %s, %s, %s", op.displayName, this.reg(a), this.reg(b), content);
    }

    @Override
    public void visitStmt3R(Op op, int a, int b, int c) {
        this.out.s("%s %s, %s, %s", op.displayName, this.reg(a), this.reg(b), this.reg(c));
    }

    @Override
    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel[] handler, String[] type) {
        for (int i = 0; i < type.length; ++i) {
            String t = type[i];
            if (t == null) {
                this.out.s(".catchall { %s .. %s } %s", this.xLabel(start), this.xLabel(end), this.xLabel(handler[i]));
                continue;
            }
            this.out.s(".catch %s { %s .. %s } %s", t, this.xLabel(start), this.xLabel(end), this.xLabel(handler[i]));
        }
    }

    @Override
    public void visitTypeStmt(Op op, int a, int b, String type) {
        if (op.format == InstructionFormat.kFmt21c) {
            this.out.s("%s %s, %s", op.displayName, this.reg(a), BaksmaliDumper.escapeType(type));
        } else {
            this.out.s("%s %s, %s, %s", op.displayName, this.reg(a), this.reg(b), BaksmaliDumper.escapeType(type));
        }
    }

    String xLabel(DexLabel d) {
        return ":" + d.displayName;
    }

    class SparseSwitchStmt {
        int[] cases;
        DexLabel[] labels;

        public SparseSwitchStmt(int[] cases, DexLabel[] labels) {
            this.cases = cases;
            this.labels = labels;
        }
    }

    class PackedSwitchStmt {
        int first_case;
        DexLabel[] labels;

        public PackedSwitchStmt(int first_case, DexLabel[] labels) {
            this.first_case = first_case;
            this.labels = labels;
        }
    }
}

