/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util;

import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.Visibility;
import com.googlecode.d2j.util.ASMifierAnnotationV;
import com.googlecode.d2j.util.ASMifierCodeV;
import com.googlecode.d2j.util.ArrayOut;
import com.googlecode.d2j.util.Escape;
import com.googlecode.d2j.util.Utf8Utils;
import com.googlecode.d2j.visitors.DexAnnotationAble;
import com.googlecode.d2j.visitors.DexAnnotationVisitor;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexFieldVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;
import java.util.ArrayList;
import java.util.List;

public class ASMifierClassV
extends DexClassVisitor {
    protected ArrayOut out = new ArrayOut();
    private List<ArrayOut> methodOuts = new ArrayList<ArrayOut>();
    private List<ArrayOut> fieldOuts = new ArrayList<ArrayOut>();
    int fCount = 0;
    int mCount = 0;

    public ASMifierClassV(String pkgName, String javaClassName, int access_flags, String className, String superClass, String[] interfaceNames) {
        this.out.s("package %s;", pkgName);
        this.out.s("import com.googlecode.d2j.*;");
        this.out.s("import com.googlecode.d2j.visitors.*;");
        this.out.s("import static com.googlecode.d2j.DexConstants.*;");
        this.out.s("import static com.googlecode.d2j.reader.Op.*;");
        this.out.s("public class %s {", javaClassName);
        this.out.push();
        this.out.s("public static void accept(DexFileVisitor v) {");
        this.out.push();
        this.out.s("DexClassVisitor cv=v.visit(%s,%s,%s,%s);", Escape.classAcc(access_flags), Escape.v(className), Escape.v(superClass), Escape.v(interfaceNames));
        this.out.s("if(cv!=null) {");
        this.out.push();
        this.out.s("accept(cv);");
        this.out.s("cv.visitEnd();");
        this.out.pop();
        this.out.s("}");
        this.out.pop();
        this.out.s("}");
        this.out.s("public static void accept(DexClassVisitor cv) {");
        this.out.push();
    }

    @Override
    public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
        return new ASMifierAnnotationV("cv", this.out, name, visibility);
    }

    @Override
    public void visitSource(String file) {
        this.out.s("cv.visitSource(\"%s\");", Utf8Utils.escapeString(file));
    }

    @Override
    public DexFieldVisitor visitField(int accessFlags, Field field, Object value) {
        String fieldName = String.format("f%03d_%s", this.fCount++, field.getName());
        this.out.s("%s(cv);", fieldName);
        final ArrayOut f = new ArrayOut();
        this.fieldOuts.add(f);
        f.s("public static void %s(DexClassVisitor cv) {", fieldName);
        f.push();
        f.s("DexFieldVisitor fv=cv.visitField(%s, %s, %s);", Escape.fieldAcc(accessFlags), Escape.v(field), Escape.v(value));
        f.s("if(fv != null) {");
        f.push();
        return new DexFieldVisitor(){

            @Override
            public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
                return new ASMifierAnnotationV("fv", f, name, visibility);
            }

            @Override
            public void visitEnd() {
                f.s("fv.visitEnd();");
                f.pop();
                f.s("}");
                f.pop();
                f.s("}");
            }
        };
    }

    @Override
    public DexMethodVisitor visitMethod(int accessFlags, Method method) {
        String methodName = String.format("m%03d_%s", this.mCount++, method.getName().replace('<', '_').replace('>', '_'));
        this.out.s("%s(cv);", methodName);
        final ArrayOut m3 = new ArrayOut();
        this.methodOuts.add(m3);
        m3.s("public static void %s(DexClassVisitor cv) {", methodName);
        m3.push();
        m3.s("DexMethodVisitor mv=cv.visitMethod(%s, %s);", Escape.methodAcc(accessFlags), Escape.v(method));
        m3.s("if(mv != null) {");
        m3.push();
        return new DexMethodVisitor(){

            @Override
            public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
                return new ASMifierAnnotationV("mv", m3, name, visibility);
            }

            @Override
            public DexAnnotationAble visitParameterAnnotation(final int index) {
                m3.s("DexAnnotationAble pv%02d = mv.visitParameterAnnotation(%s);", index, index);
                return new DexAnnotationAble(){

                    @Override
                    public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
                        return new ASMifierAnnotationV(String.format("pv%02d", index), m3, name, visibility);
                    }
                };
            }

            @Override
            public DexCodeVisitor visitCode() {
                m3.s("DexCodeVisitor code=mv.visitCode();");
                m3.s("if(code != null) {");
                m3.push();
                return new ASMifierCodeV(m3){

                    @Override
                    public void visitEnd() {
                        super.visitEnd();
                        this.m.pop();
                        this.m.s("}");
                    }
                };
            }

            @Override
            public void visitEnd() {
                m3.s("mv.visitEnd();");
                m3.pop();
                m3.s("}");
                m3.pop();
                m3.s("}");
            }
        };
    }

    @Override
    public void visitEnd() {
        this.out.pop();
        this.out.s("}");
        for (ArrayOut o : this.fieldOuts) {
            this.out.array.addAll(o.array);
            for (int i : o.is) {
                this.out.is.add(this.out.i + i);
            }
        }
        this.fieldOuts = null;
        for (ArrayOut o : this.methodOuts) {
            this.out.array.addAll(o.array);
            for (int i : o.is) {
                this.out.is.add(this.out.i + i);
            }
        }
        this.methodOuts = null;
        this.out.pop();
        this.out.s("}");
    }
}

