/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.dex.ClassVisitorFactory;
import com.googlecode.d2j.dex.Dex2Asm;
import com.googlecode.d2j.dex.ExDex2Asm;
import com.googlecode.d2j.dex.LambadaNameSafeClassAdapter;
import com.googlecode.d2j.node.DexClassNode;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.reader.BaseDexFileReader;
import com.googlecode.d2j.reader.MultiDexFileReader;
import com.googlecode.dex2jar.tools.BaksmaliBaseDexExceptionHandler;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

@BaseCmd.Syntax(cmd="d2j-mt-dex2jar", syntax="[options] <file0> [file1 ... fileN]", desc="convert dex to jar")
public class Dex2jarMultiThreadCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="mt", longOpt="multi-thread", description="concurrent process, default is 4 thread")
    private int multiThread = 4;
    @BaseCmd.Opt(opt="fl", longOpt="file-list", description="a file contains a list of dex to process")
    private Path fileList;

    public static void main(String ... args) {
        new Dex2jarMultiThreadCmd().doMain(args);
    }

    @Override
    protected void doCommandLine() throws Exception {
        ArrayList<String> f = new ArrayList<String>();
        f.addAll(Arrays.asList(this.remainingArgs));
        if (this.fileList != null) {
            f.addAll(Files.readAllLines(this.fileList, StandardCharsets.UTF_8));
        }
        if (f.size() < 1) {
            throw new BaseCmd.HelpException();
        }
        final ExecutorService executorService = Executors.newFixedThreadPool(this.multiThread);
        final Iterator fileIt = f.iterator();
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (fileIt.hasNext()) {
                    String fileName = (String)fileIt.next();
                    try {
                        Dex2jarMultiThreadCmd.this.run0(fileName, executorService);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        executorService.submit(this);
                    }
                } else {
                    executorService.shutdown();
                }
            }
        });
        executorService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    private void run0(String fileName, final ExecutorService executorService) throws IOException {
        String baseName = Dex2jarMultiThreadCmd.getBaseName(new File(fileName).toPath());
        Path currentDir = new File(".").toPath();
        Path file = currentDir.resolve(baseName + "-dex2jar.jar");
        final Path errorFile = currentDir.resolve(baseName + "-error.zip");
        System.err.println("dex2jar " + fileName + " -> " + file);
        final BaksmaliBaseDexExceptionHandler exceptionHandler = new BaksmaliBaseDexExceptionHandler();
        BaseDexFileReader reader = MultiDexFileReader.open(Files.readAllBytes(new File(fileName).toPath()));
        DexFileNode fileNode = new DexFileNode();
        try {
            reader.accept(fileNode, 33);
        }
        catch (Exception ex) {
            exceptionHandler.handleFileException(ex);
            throw ex;
        }
        final FileSystem fs = Dex2jarMultiThreadCmd.createZip(file);
        final Path dist = fs.getPath("/", new String[0]);
        ClassVisitorFactory cvf = new ClassVisitorFactory(){

            @Override
            public ClassVisitor create(String name) {
                final ClassWriter cw = new ClassWriter(1);
                final LambadaNameSafeClassAdapter rca = new LambadaNameSafeClassAdapter(cw);
                return new ClassVisitor(262144, rca){

                    @Override
                    public void visitEnd() {
                        byte[] data;
                        super.visitEnd();
                        String className = rca.getClassName();
                        try {
                            data = cw.toByteArray();
                        }
                        catch (Exception ex) {
                            System.err.println(String.format("ASM fail to generate .class file: %s", className));
                            exceptionHandler.handleFileException(ex);
                            return;
                        }
                        try {
                            Path dist1 = dist.resolve(className + ".class");
                            BaseCmd.createParentDirectories(dist1);
                            Files.write(dist1, data, new OpenOption[0]);
                        }
                        catch (IOException e) {
                            exceptionHandler.handleFileException(e);
                        }
                    }
                };
            }
        };
        new ExDex2Asm(exceptionHandler){

            @Override
            public void convertDex(final DexFileNode fileNode, final ClassVisitorFactory cvf) {
                if (fileNode.clzs != null) {
                    final Map<String, Dex2Asm.Clz> classes = 3.collectClzInfo(fileNode);
                    final ArrayList results = new ArrayList(fileNode.clzs.size());
                    for (final DexClassNode classNode : fileNode.clzs) {
                        results.add(executorService.submit(new Runnable(){

                            @Override
                            public void run() {
                                this.convertClass(fileNode, classNode, cvf, (Map<String, Dex2Asm.Clz>)classes);
                            }
                        }));
                    }
                    executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (Future result : results) {
                                try {
                                    result.get();
                                }
                                catch (InterruptedException | ExecutionException e) {
                                    e.printStackTrace();
                                }
                            }
                            BaksmaliBaseDexExceptionHandler exceptionHandler1 = (BaksmaliBaseDexExceptionHandler)exceptionHandler;
                            if (exceptionHandler1.hasException()) {
                                exceptionHandler1.dump(errorFile, new String[0]);
                            }
                            try {
                                fs.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        }.convertDex(fileNode, cvf);
    }
}

