/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.util.zip.AutoSTOREDZipOutputStream;
import com.googlecode.d2j.util.zip.ZipEntry;
import com.googlecode.d2j.util.zip.ZipFile;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipOutputStream;

@BaseCmd.Syntax(cmd="d2j-std-zip", syntax="[options] <zip>", desc="clean up apk to standard zip")
public class StdApkCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="o", longOpt="output", description="The output file", argName="out", required=true)
    private Path output;

    public static void main(String ... args) {
        new StdApkCmd().doMain(args);
    }

    @Override
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length < 1) {
            System.err.println("ERROR: no file to process");
            return;
        }
        System.err.printf("fix %s -> %s\n", this.remainingArgs[0], this.output);
        byte[] buffer = new byte[1000];
        try (AutoSTOREDZipOutputStream zos = new AutoSTOREDZipOutputStream(Files.newOutputStream(this.output, new OpenOption[0]));){
            byte[] data = Files.readAllBytes(new File(this.remainingArgs[0]).toPath());
            try (ZipFile zipFile = new ZipFile(data);){
                for (ZipEntry zipEntry : zipFile.entries()) {
                    java.util.zip.ZipEntry nEntry = new java.util.zip.ZipEntry(zipEntry.getName());
                    nEntry.setMethod(zipEntry.getMethod() == 0 ? 0 : 8);
                    ((ZipOutputStream)zos).putNextEntry(nEntry);
                    if (!nEntry.isDirectory()) {
                        try (InputStream is = zipFile.getInputStream(zipEntry);){
                            int c;
                            while ((c = is.read(buffer)) >= 0) {
                                ((ZipOutputStream)zos).write(buffer, 0, c);
                            }
                        }
                    }
                    ((ZipOutputStream)zos).closeEntry();
                }
            }
            zos.finish();
        }
    }
}

