/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.misc;

public class CharSupport {
    public static int[] ANTLRLiteralEscapedCharValue = new int[255];
    public static String[] ANTLRLiteralCharValueEscape = new String[255];

    public static String getANTLRCharLiteralForChar(int c) {
        if (c < 0) {
            return "'<INVALID>'";
        }
        if (c < ANTLRLiteralCharValueEscape.length && ANTLRLiteralCharValueEscape[c] != null) {
            return '\'' + ANTLRLiteralCharValueEscape[c] + '\'';
        }
        if (Character.UnicodeBlock.of((char)c) == Character.UnicodeBlock.BASIC_LATIN && !Character.isISOControl((char)c)) {
            if (c == 92) {
                return "'\\\\'";
            }
            if (c == 39) {
                return "'\\''";
            }
            return '\'' + Character.toString((char)c) + '\'';
        }
        String hex = Integer.toHexString(c | 0x10000).toUpperCase().substring(1, 5);
        String unicodeStr = "'\\u" + hex + "'";
        return unicodeStr;
    }

    public static int getCharValueFromGrammarCharLiteral(String literal) {
        if (literal == null || literal.length() < 3) {
            return -1;
        }
        return CharSupport.getCharValueFromCharInGrammarLiteral(literal.substring(1, literal.length() - 1));
    }

    public static int getCharValueFromCharInGrammarLiteral(String cstr) {
        switch (cstr.length()) {
            case 1: {
                return cstr.charAt(0);
            }
            case 2: {
                if (cstr.charAt(0) != '\\') {
                    return -1;
                }
                if (Character.isDigit(cstr.charAt(1))) {
                    return -1;
                }
                char escChar = cstr.charAt(1);
                int charVal = ANTLRLiteralEscapedCharValue[escChar];
                if (charVal == 0) {
                    return -1;
                }
                return charVal;
            }
            case 6: {
                if (!cstr.startsWith("\\u")) {
                    return -1;
                }
                String unicodeChars = cstr.substring(2, cstr.length());
                return Integer.parseInt(unicodeChars, 16);
            }
        }
        return -1;
    }

    public static String getStringFromGrammarStringLiteral(String literal) {
        StringBuilder buf = new StringBuilder();
        int i = 1;
        int n = literal.length() - 1;
        while (i < n) {
            int end = i + 1;
            if (literal.charAt(i) == '\\') {
                end = i + 2;
                if (i + 1 >= n) break;
                if (literal.charAt(i + 1) == 'u') {
                    end = i + 6;
                }
            }
            if (end > n) break;
            String esc = literal.substring(i, end);
            int c = CharSupport.getCharValueFromCharInGrammarLiteral(esc);
            if (c == -1) {
                buf.append(esc);
            } else {
                buf.append((char)c);
            }
            i = end;
        }
        return buf.toString();
    }

    public static String capitalize(String s2) {
        return Character.toUpperCase(s2.charAt(0)) + s2.substring(1);
    }

    static {
        CharSupport.ANTLRLiteralEscapedCharValue[110] = 10;
        CharSupport.ANTLRLiteralEscapedCharValue[114] = 13;
        CharSupport.ANTLRLiteralEscapedCharValue[116] = 9;
        CharSupport.ANTLRLiteralEscapedCharValue[98] = 8;
        CharSupport.ANTLRLiteralEscapedCharValue[102] = 12;
        CharSupport.ANTLRLiteralEscapedCharValue[92] = 92;
        CharSupport.ANTLRLiteralEscapedCharValue[39] = 39;
        CharSupport.ANTLRLiteralEscapedCharValue[34] = 34;
        CharSupport.ANTLRLiteralCharValueEscape[10] = "\\n";
        CharSupport.ANTLRLiteralCharValueEscape[13] = "\\r";
        CharSupport.ANTLRLiteralCharValueEscape[9] = "\\t";
        CharSupport.ANTLRLiteralCharValueEscape[8] = "\\b";
        CharSupport.ANTLRLiteralCharValueEscape[12] = "\\f";
        CharSupport.ANTLRLiteralCharValueEscape[92] = "\\\\";
        CharSupport.ANTLRLiteralCharValueEscape[39] = "\\'";
    }
}

