/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.StmtGraph;

public class DominanceFinder {
    private List<BasicBlock<?>> blocks;
    private Map<BasicBlock<?>, Integer> blockToIdx = new HashMap();
    private int[] doms;
    private ArrayList<Integer>[] domFrontiers;

    public DominanceFinder(StmtGraph<?> blockGraph) {
        this.blocks = new ArrayList(blockGraph.getBlocks());
        BasicBlock<?> startingStmtBlock = blockGraph.getStartingStmtBlock();
        int i = 1;
        for (BasicBlock<?> block : this.blocks) {
            if (startingStmtBlock == block) {
                this.blockToIdx.put(block, 0);
                continue;
            }
            this.blockToIdx.put(block, i);
            ++i;
        }
        this.doms = new int[this.blocks.size()];
        this.doms[0] = 0;
        for (i = 1; i < this.doms.length; ++i) {
            this.doms[i] = -1;
        }
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (BasicBlock<?> block : this.blocks) {
                if (block == startingStmtBlock) continue;
                int blockIdx = this.blockToIdx.get(block);
                ArrayList preds = new ArrayList(block.getPredecessors());
                int newIdom = this.getFirstDefinedBlockPredIdx(preds);
                if (preds.isEmpty() || newIdom == -1) continue;
                preds.remove(this.blocks.get(newIdom));
                for (BasicBlock basicBlock : preds) {
                    int predIdx = this.blockToIdx.get(basicBlock);
                    if (this.doms[predIdx] == -1) continue;
                    newIdom = this.isIntersecting(newIdom, predIdx);
                }
                if (this.doms[blockIdx] == newIdom) continue;
                this.doms[blockIdx] = newIdom;
                isChanged = true;
            }
        }
        this.domFrontiers = new ArrayList[blockGraph.getBlocks().size()];
        for (int i2 = 0; i2 < this.domFrontiers.length; ++i2) {
            this.domFrontiers[i2] = new ArrayList();
        }
        for (BasicBlock<?> block : this.blocks) {
            ArrayList preds = new ArrayList(block.getPredecessors());
            if (preds.size() <= 1) continue;
            int blockId = this.blockToIdx.get(block);
            for (BasicBlock pred : preds) {
                int n = this.blockToIdx.get(pred);
                while (n != this.doms[blockId]) {
                    this.domFrontiers[n].add(blockId);
                    n = this.doms[n];
                }
            }
        }
    }

    public void replaceBlock(@Nonnull BasicBlock<?> newBlock, BasicBlock<?> oldBlock) {
        if (!this.blockToIdx.containsKey(oldBlock)) {
            throw new RuntimeException("The given block: " + oldBlock + " is not in BlockGraph!");
        }
        Integer idx = this.blockToIdx.get(oldBlock);
        this.blockToIdx.put(newBlock, idx);
        this.blockToIdx.remove(oldBlock);
        this.blocks.set(idx, newBlock);
    }

    @Nonnull
    public BasicBlock<?> getImmediateDominator(@Nonnull BasicBlock<?> block) {
        if (!this.blockToIdx.containsKey(block)) {
            throw new RuntimeException("The given block: " + block + " is not in BlockGraph!");
        }
        int idx = this.blockToIdx.get(block);
        int idomIdx = this.doms[idx];
        return this.blocks.get(idomIdx);
    }

    @Nonnull
    public Set<BasicBlock<?>> getDominanceFrontiers(@Nonnull BasicBlock<?> block) {
        if (!this.blockToIdx.containsKey(block)) {
            throw new RuntimeException("The given block: " + block + " is not in BlockGraph!");
        }
        int idx = this.blockToIdx.get(block);
        HashSet dFs = new HashSet();
        ArrayList<Integer> dFs_idx = this.domFrontiers[idx];
        for (Integer i : dFs_idx) {
            dFs.add(this.blocks.get(i));
        }
        return dFs;
    }

    @Nonnull
    public List<BasicBlock<?>> getIdxToBlock() {
        return this.blocks;
    }

    @Nonnull
    public Map<BasicBlock<?>, Integer> getBlockToIdx() {
        return this.blockToIdx;
    }

    @Nonnull
    public int[] getImmediateDominators() {
        return this.doms;
    }

    private int getFirstDefinedBlockPredIdx(List<BasicBlock<?>> preds) {
        for (BasicBlock<?> block : preds) {
            int idx = this.blockToIdx.get(block);
            if (this.doms[idx] == -1) continue;
            return idx;
        }
        return -1;
    }

    private int isIntersecting(int a, int b) {
        while (a != b) {
            if (a > b) {
                a = this.doms[a];
                continue;
            }
            b = this.doms[b];
        }
        return a;
    }
}

