/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.graph;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.MutableBasicBlock;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.types.ClassType;

public class ImmutableBlockStmtGraph
extends StmtGraph<ImmutableBasicBlock> {
    private final List<ImmutableBasicBlock> blocks;
    private final Map<Stmt, ImmutableBasicBlock> stmtToBlock = new HashMap<Stmt, ImmutableBasicBlock>();

    public ImmutableBlockStmtGraph(@Nonnull MutableStmtGraph graph) {
        List<BasicBlock<?>> mblocks = graph.getBlocksSorted();
        this.blocks = Lists.newArrayListWithExpectedSize(mblocks.size());
        for (BasicBlock<?> basicBlock : mblocks) {
        }
    }

    @Override
    @Nullable
    public Stmt getStartingStmt() {
        return this.blocks.isEmpty() ? null : this.blocks.get(0).getHead();
    }

    @Override
    public BasicBlock<?> getStartingStmtBlock() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public BasicBlock<ImmutableBasicBlock> getBlockOf(@Nonnull Stmt stmt) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Nonnull
    public List<Stmt> nodes() {
        int size = 0;
        for (ImmutableBasicBlock block : this.blocks) {
            size += block.getStmtCount();
        }
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(size);
        for (ImmutableBasicBlock block : this.blocks) {
            stmts.addAll(block.getStmts());
        }
        return stmts;
    }

    @Override
    @Nonnull
    public Collection<ImmutableBasicBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    @Nonnull
    public List<? extends BasicBlock<?>> getBlocksSorted() {
        return this.blocks;
    }

    @Override
    public boolean containsNode(@Nonnull Stmt node) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    @Nonnull
    public List<Stmt> predecessors(@Nonnull Stmt node) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    @Nonnull
    public List<Stmt> exceptionalPredecessors(@Nonnull Stmt node) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    @Nonnull
    public List<Stmt> successors(@Nonnull Stmt node) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    @Nonnull
    public Map<ClassType, Stmt> exceptionalSuccessors(@Nonnull Stmt node) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public int inDegree(@Nonnull Stmt node) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public int outDegree(@Nonnull Stmt node) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public boolean hasEdgeConnecting(@Nonnull Stmt source, @Nonnull Stmt target) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    @Nonnull
    public List<Trap> getTraps() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    @Nonnull
    public Iterator<Stmt> iterator() {
        return new Iterator<Stmt>(){
            final Iterator<ImmutableBasicBlock> blockIt;
            Iterator<Stmt> stmtIt;
            {
                this.blockIt = ImmutableBlockStmtGraph.this.blocks.iterator();
                this.stmtIt = this.blockIt.next().getStmts().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.stmtIt.hasNext() || this.blockIt.hasNext();
            }

            @Override
            public Stmt next() {
                if (this.stmtIt.hasNext()) {
                    return this.stmtIt.next();
                }
                this.stmtIt = this.blockIt.next().getStmts().iterator();
                return this.stmtIt.next();
            }
        };
    }

    public class ImmutableBasicBlock
    implements BasicBlock<ImmutableBasicBlock> {
        private final MutableBasicBlock graph;
        private final int startIdx;
        private final int endIdx;
        private final List<ImmutableBasicBlock> successors;
        private final List<ImmutableBasicBlock> predecessors;

        private ImmutableBasicBlock(MutableBasicBlock graph, int startIdx, int endIdx, List<ImmutableBasicBlock> successors, List<ImmutableBasicBlock> predecessors) {
            this.graph = graph;
            this.startIdx = startIdx;
            this.endIdx = endIdx;
            this.successors = successors;
            this.predecessors = predecessors;
        }

        @Override
        @Nonnull
        public List<ImmutableBasicBlock> getPredecessors() {
            return this.predecessors;
        }

        @Override
        @Nonnull
        public List<ImmutableBasicBlock> getSuccessors() {
            return this.successors;
        }

        @Override
        public List<ImmutableBasicBlock> getExceptionalPredecessors() {
            return null;
        }

        @Override
        @Nonnull
        public Map<? extends ClassType, ImmutableBasicBlock> getExceptionalSuccessors() {
            throw new UnsupportedOperationException("not implemented yet");
        }

        @Override
        @Nonnull
        public List<Stmt> getStmts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStmtCount() {
            return this.endIdx - this.startIdx + 1;
        }

        @Override
        @Nonnull
        public Stmt getHead() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public Stmt getTail() {
            throw new UnsupportedOperationException();
        }
    }
}

