/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.inputlocation;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SootClass;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public class EagerInputLocation<S extends SootClass<? extends SootClassSource<S>>>
implements AnalysisInputLocation<S> {
    @Nonnull
    private final Map<ClassType, ? extends SootClassSource<S>> map;

    public EagerInputLocation() {
        this.map = Collections.emptyMap();
    }

    public EagerInputLocation(@Nonnull Map<ClassType, ? extends SootClassSource<S>> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    @Override
    @Nonnull
    public Optional<? extends AbstractClassSource<S>> getClassSource(@Nonnull ClassType type, @Nullable View<?> view) {
        return Optional.ofNullable(this.map.get(type));
    }

    @Override
    @Nonnull
    public Collection<? extends AbstractClassSource<S>> getClassSources(@Nullable View<?> view) {
        return this.map.values();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof EagerInputLocation)) {
            return false;
        }
        return this.map.equals(((EagerInputLocation)o).map);
    }
}

