/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sootup.core.IdentifierFactory;
import sootup.core.graph.BasicBlock;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JAddExpr;
import sootup.core.jimple.common.expr.JAndExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JCmpExpr;
import sootup.core.jimple.common.expr.JCmpgExpr;
import sootup.core.jimple.common.expr.JCmplExpr;
import sootup.core.jimple.common.expr.JDivExpr;
import sootup.core.jimple.common.expr.JDynamicInvokeExpr;
import sootup.core.jimple.common.expr.JEqExpr;
import sootup.core.jimple.common.expr.JGeExpr;
import sootup.core.jimple.common.expr.JGtExpr;
import sootup.core.jimple.common.expr.JInstanceOfExpr;
import sootup.core.jimple.common.expr.JInterfaceInvokeExpr;
import sootup.core.jimple.common.expr.JLeExpr;
import sootup.core.jimple.common.expr.JLengthExpr;
import sootup.core.jimple.common.expr.JLtExpr;
import sootup.core.jimple.common.expr.JMulExpr;
import sootup.core.jimple.common.expr.JNeExpr;
import sootup.core.jimple.common.expr.JNegExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.expr.JOrExpr;
import sootup.core.jimple.common.expr.JPhiExpr;
import sootup.core.jimple.common.expr.JRemExpr;
import sootup.core.jimple.common.expr.JShlExpr;
import sootup.core.jimple.common.expr.JShrExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.expr.JSubExpr;
import sootup.core.jimple.common.expr.JUshrExpr;
import sootup.core.jimple.common.expr.JVirtualInvokeExpr;
import sootup.core.jimple.common.expr.JXorExpr;
import sootup.core.jimple.common.ref.IdentityRef;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JInstanceFieldRef;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.JNopStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JReturnVoidStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JBreakpointStmt;
import sootup.core.jimple.javabytecode.stmt.JEnterMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JExitMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JRetStmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.core.util.StringTools;

public abstract class Jimple {
    public static final String NEWARRAY = "newarray";
    public static final String NEWMULTIARRAY = "newmultiarray";
    public static final String NOP = "nop";
    public static final String RET = "ret";
    public static final String SPECIALINVOKE = "specialinvoke";
    public static final String DYNAMICINVOKE = "dynamicinvoke";
    public static final String STATICINVOKE = "staticinvoke";
    public static final String VIRTUALINVOKE = "virtualinvoke";
    public static final String CMP = "cmp";
    public static final String CMPG = "cmpg";
    public static final String CMPL = "cmpl";
    public static final String ENTERMONITOR = "entermonitor";
    public static final String EXITMONITOR = "exitmonitor";
    public static final String INTERFACEINVOKE = "interfaceinvoke";
    public static final String LENGTHOF = "lengthof";
    public static final String NEG = "neg";
    public static final String IF = "if";
    public static final String ABSTRACT = "abstract";
    public static final String CASE = "case";
    public static final String CATCH = "catch";
    public static final String CLASS = "class";
    public static final String FINAL = "final";
    public static final String NATIVE = "native";
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String PRIVATE = "private";
    public static final String STATIC = "static";
    public static final String SYNCHRONIZED = "synchronized";
    public static final String TRANSIENT = "transient";
    public static final String VOLATILE = "volatile";
    public static final String STRICTFP = "strictfp";
    public static final String ENUM = "enum";
    public static final String ANNOTATION = "annotation";
    public static final String INTERFACE = "interface";
    public static final String EXTENDS = "extends";
    public static final String IMPLEMENTS = "implements";
    public static final String BREAKPOINT = "breakpoint";
    public static final String DEFAULT = "default";
    public static final String GOTO = "goto";
    public static final String INSTANCEOF = "instanceof";
    public static final String NEW = "new";
    public static final String RETURN = "return";
    public static final String SWITCH = "switch";
    public static final String THROW = "throw";
    public static final String THROWS = "throws";
    public static final String NULL = "null";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String WITH = "with";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String PHI = "phi";

    public static List<String> jimpleKeywordList() {
        List<String> l = Arrays.asList(NEWARRAY, NEWMULTIARRAY, NOP, RET, SPECIALINVOKE, STATICINVOKE, SWITCH, VIRTUALINVOKE, CMP, CMPG, CMPL, ENTERMONITOR, EXITMONITOR, INTERFACEINVOKE, LENGTHOF, NEG, IF, ABSTRACT, CASE, CATCH, CLASS, FINAL, NATIVE, PUBLIC, PROTECTED, PRIVATE, STATIC, SYNCHRONIZED, TRANSIENT, VOLATILE, STRICTFP, ENUM, ANNOTATION, INTERFACE, EXTENDS, IMPLEMENTS, BREAKPOINT, DEFAULT, GOTO, INSTANCEOF, NEW, RETURN, THROW, THROWS, NULL, FROM, TO, WITH, TRUE, FALSE, PHI);
        return l;
    }

    public static String escape(String str) {
        if (str.length() == 0) {
            return "\"\"";
        }
        return StringTools.getQuotedStringOf(str, Jimple.jimpleKeywordList().contains(str));
    }

    public static String unescape(String str) {
        StringBuilder sb = new StringBuilder();
        boolean lastWasRealEscape = false;
        int lastAppendedPos = 0;
        int openHyphenPos = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (!(str.charAt(i) != '\"' && str.charAt(i) != '\'' || lastWasRealEscape)) {
                if (openHyphenPos < 0) {
                    if (lastAppendedPos < i) {
                        sb.append(StringTools.getUnEscapedStringOf(str.substring(lastAppendedPos, i)));
                    }
                    openHyphenPos = i;
                    lastAppendedPos = i;
                } else if (str.charAt(i) == str.charAt(openHyphenPos)) {
                    sb.append(StringTools.getUnEscapedStringOf(str.substring(openHyphenPos + 1, i)));
                    openHyphenPos = -1;
                    lastAppendedPos = i + 1;
                }
            }
            lastWasRealEscape = !lastWasRealEscape && str.charAt(i) == '\\';
        }
        if (lastAppendedPos < str.length()) {
            sb.append(StringTools.getUnEscapedStringOf(str.substring(lastAppendedPos)));
        }
        return sb.toString();
    }

    public abstract IdentifierFactory getIdentifierFactory();

    public static JXorExpr newXorExpr(Immediate op1, Immediate op2) {
        return new JXorExpr(op1, op2);
    }

    public static JUshrExpr newUshrExpr(Immediate op1, Immediate op2) {
        return new JUshrExpr(op1, op2);
    }

    public static JSubExpr newSubExpr(Immediate op1, Immediate op2) {
        return new JSubExpr(op1, op2);
    }

    public static JShrExpr newShrExpr(Immediate op1, Immediate op2) {
        return new JShrExpr(op1, op2);
    }

    public static JShlExpr newShlExpr(Immediate op1, Immediate op2) {
        return new JShlExpr(op1, op2);
    }

    public static JRemExpr newRemExpr(Immediate op1, Immediate op2) {
        return new JRemExpr(op1, op2);
    }

    public static JOrExpr newOrExpr(Immediate op1, Immediate op2) {
        return new JOrExpr(op1, op2);
    }

    public static JNeExpr newNeExpr(Immediate op1, Immediate op2) {
        return new JNeExpr(op1, op2);
    }

    public static JMulExpr newMulExpr(Immediate op1, Immediate op2) {
        return new JMulExpr(op1, op2);
    }

    public static JLeExpr newLeExpr(Immediate op1, Immediate op2) {
        return new JLeExpr(op1, op2);
    }

    public static JGeExpr newGeExpr(Immediate op1, Immediate op2) {
        return new JGeExpr(op1, op2);
    }

    public static JEqExpr newEqExpr(Immediate op1, Immediate op2) {
        return new JEqExpr(op1, op2);
    }

    public static JDivExpr newDivExpr(Immediate op1, Immediate op2) {
        return new JDivExpr(op1, op2);
    }

    public static JCmplExpr newCmplExpr(Immediate op1, Immediate op2) {
        return new JCmplExpr(op1, op2);
    }

    public static JCmpgExpr newCmpgExpr(Immediate op1, Immediate op2) {
        return new JCmpgExpr(op1, op2);
    }

    public static JCmpExpr newCmpExpr(Immediate op1, Immediate op2) {
        return new JCmpExpr(op1, op2);
    }

    public static JGtExpr newGtExpr(Immediate op1, Immediate op2) {
        return new JGtExpr(op1, op2);
    }

    public static JLtExpr newLtExpr(Immediate op1, Immediate op2) {
        return new JLtExpr(op1, op2);
    }

    public static JAddExpr newAddExpr(Immediate op1, Immediate op2) {
        return new JAddExpr(op1, op2);
    }

    public static JAndExpr newAndExpr(Immediate op1, Immediate op2) {
        return new JAndExpr(op1, op2);
    }

    public static JNegExpr newNegExpr(Immediate op) {
        return new JNegExpr(op);
    }

    public static JLengthExpr newLengthExpr(Immediate op) {
        return new JLengthExpr(op);
    }

    public static JCastExpr newCastExpr(Immediate op1, Type t) {
        return new JCastExpr(op1, t);
    }

    public static JInstanceOfExpr newInstanceOfExpr(Immediate op1, Type t) {
        return new JInstanceOfExpr(op1, t);
    }

    public JNewArrayExpr newNewArrayExpr(Type type, Immediate size) {
        return new JNewArrayExpr(type, size, this.getIdentifierFactory());
    }

    public static JPhiExpr newPhiExpr(List<Local> args, Map<Local, BasicBlock<?>> argToBlock) {
        return new JPhiExpr(args, argToBlock);
    }

    public static JStaticInvokeExpr newStaticInvokeExpr(MethodSignature method, List<Immediate> args) {
        return new JStaticInvokeExpr(method, args);
    }

    public static JStaticInvokeExpr newStaticInvokeExpr(MethodSignature method, Immediate ... args) {
        return Jimple.newStaticInvokeExpr(method, Arrays.asList(args));
    }

    public static JStaticInvokeExpr newStaticInvokeExpr(MethodSignature method, Immediate arg) {
        return Jimple.newStaticInvokeExpr(method, Collections.singletonList(arg));
    }

    public static JStaticInvokeExpr newStaticInvokeExpr(MethodSignature method) {
        return Jimple.newStaticInvokeExpr(method, Collections.emptyList());
    }

    public static JSpecialInvokeExpr newSpecialInvokeExpr(Local base, MethodSignature method, List<Immediate> args) {
        return new JSpecialInvokeExpr(base, method, args);
    }

    public static JSpecialInvokeExpr newSpecialInvokeExpr(Local base, MethodSignature method, Immediate ... args) {
        return Jimple.newSpecialInvokeExpr(base, method, Arrays.asList(args));
    }

    public static JSpecialInvokeExpr newSpecialInvokeExpr(Local base, MethodSignature method, Immediate arg) {
        return Jimple.newSpecialInvokeExpr(base, method, Collections.singletonList(arg));
    }

    public static JSpecialInvokeExpr newSpecialInvokeExpr(Local base, MethodSignature method) {
        return Jimple.newSpecialInvokeExpr(base, method, Collections.emptyList());
    }

    public static JDynamicInvokeExpr newDynamicInvokeExpr(MethodSignature bootstrapMethodSignature, List<Immediate> bootstrapArgs, MethodSignature methodSignature, List<Immediate> args) {
        return new JDynamicInvokeExpr(bootstrapMethodSignature, bootstrapArgs, methodSignature, args);
    }

    public static JDynamicInvokeExpr newDynamicInvokeExpr(MethodSignature bootstrapMethodSignature, List<Immediate> bootstrapArgs, MethodSignature methodSignature, int tag, List<Immediate> args) {
        return new JDynamicInvokeExpr(bootstrapMethodSignature, bootstrapArgs, methodSignature, tag, args);
    }

    public static JVirtualInvokeExpr newVirtualInvokeExpr(Local base, MethodSignature method, List<Immediate> args) {
        return new JVirtualInvokeExpr(base, method, args);
    }

    public static JVirtualInvokeExpr newVirtualInvokeExpr(Local base, MethodSignature method, Immediate ... args) {
        return Jimple.newVirtualInvokeExpr(base, method, Arrays.asList(args));
    }

    public static JVirtualInvokeExpr newVirtualInvokeExpr(Local base, MethodSignature method, Immediate arg) {
        return Jimple.newVirtualInvokeExpr(base, method, Collections.singletonList(arg));
    }

    public static JVirtualInvokeExpr newVirtualInvokeExpr(Local base, MethodSignature method) {
        return Jimple.newVirtualInvokeExpr(base, method, Collections.emptyList());
    }

    public static JInterfaceInvokeExpr newInterfaceInvokeExpr(Local base, MethodSignature method, List<Immediate> args) {
        return new JInterfaceInvokeExpr(base, method, args);
    }

    public static JInterfaceInvokeExpr newInterfaceInvokeExpr(Local base, MethodSignature method, Immediate ... args) {
        return Jimple.newInterfaceInvokeExpr(base, method, Arrays.asList(args));
    }

    public static JInterfaceInvokeExpr newInterfaceInvokeExpr(Local base, MethodSignature method, Immediate arg) {
        return Jimple.newInterfaceInvokeExpr(base, method, Collections.singletonList(arg));
    }

    public static JInterfaceInvokeExpr newInterfaceInvokeExpr(Local base, MethodSignature method) {
        return Jimple.newInterfaceInvokeExpr(base, method, Collections.emptyList());
    }

    public static JThrowStmt newThrowStmt(Immediate op, StmtPositionInfo posInfo) {
        return new JThrowStmt(op, posInfo);
    }

    public static JExitMonitorStmt newExitMonitorStmt(Immediate op, StmtPositionInfo posInfo) {
        return new JExitMonitorStmt(op, posInfo);
    }

    public static JEnterMonitorStmt newEnterMonitorStmt(Immediate op, StmtPositionInfo posInfo) {
        return new JEnterMonitorStmt(op, posInfo);
    }

    public static JBreakpointStmt newBreakpointStmt(StmtPositionInfo posInfo) {
        return new JBreakpointStmt(posInfo);
    }

    public static JGotoStmt newGotoStmt(StmtPositionInfo posInfo) {
        return new JGotoStmt(posInfo);
    }

    public static JNopStmt newNopStmt(StmtPositionInfo posInfo) {
        return new JNopStmt(posInfo);
    }

    public static JReturnVoidStmt newReturnVoidStmt(StmtPositionInfo posInfo) {
        return new JReturnVoidStmt(posInfo);
    }

    public static JReturnStmt newReturnStmt(Immediate op, StmtPositionInfo posInfo) {
        return new JReturnStmt(op, posInfo);
    }

    public static JRetStmt newRetStmt(Immediate stmtAddress, StmtPositionInfo posInfo) {
        return new JRetStmt(stmtAddress, posInfo);
    }

    public static JIfStmt newIfStmt(AbstractConditionExpr condition, StmtPositionInfo posInfo) {
        return new JIfStmt(condition, posInfo);
    }

    public static <L extends IdentityRef> JIdentityStmt<L> newIdentityStmt(Local local, L identityRef, StmtPositionInfo posInfo) {
        return new JIdentityStmt<L>(local, identityRef, posInfo);
    }

    public static <L extends Value, R extends Value> JAssignStmt<L, R> newAssignStmt(L variable, R rvalue, StmtPositionInfo posInfo) {
        return new JAssignStmt<L, R>(variable, rvalue, posInfo);
    }

    public static JInvokeStmt newInvokeStmt(AbstractInvokeExpr op, StmtPositionInfo posInfo) {
        return new JInvokeStmt(op, posInfo);
    }

    public static JSwitchStmt newTableSwitchStmt(Immediate key, int lowIndex, int highIndex, StmtPositionInfo posInfo) {
        return new JSwitchStmt(key, lowIndex, highIndex, posInfo);
    }

    public static JSwitchStmt newLookupSwitchStmt(Immediate key, List<IntConstant> lookupValues, StmtPositionInfo posInfo) {
        return new JSwitchStmt(key, lookupValues, posInfo);
    }

    public static Local newLocal(String name, Type t) {
        return new Local(name, t);
    }

    public static JStaticFieldRef newStaticFieldRef(FieldSignature f) {
        return new JStaticFieldRef(f);
    }

    public static JThisRef newThisRef(ClassType t) {
        return new JThisRef(t);
    }

    public static JParameterRef newParameterRef(Type paramType, int number) {
        return new JParameterRef(paramType, number);
    }

    public static JInstanceFieldRef newInstanceFieldRef(Local base, FieldSignature f) {
        return new JInstanceFieldRef(base, f);
    }

    public JArrayRef newArrayRef(Local base, Immediate index) {
        return new JArrayRef(base, index, this.getIdentifierFactory());
    }

    public abstract JCaughtExceptionRef newCaughtExceptionRef();

    public static JNewExpr newNewExpr(ClassType type) {
        return new JNewExpr(type);
    }

    public static JNewMultiArrayExpr newNewMultiArrayExpr(ArrayType type, List<Immediate> sizes) {
        return new JNewMultiArrayExpr(type, sizes);
    }

    public static Trap newTrap(ClassType exception, Stmt beginStmt, Stmt endStmt, Stmt handlerStmt) {
        return new Trap(exception, beginStmt, endStmt, handlerStmt);
    }
}

