/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.basic;

import java.util.Objects;
import javax.annotation.Nonnull;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.types.ClassType;
import sootup.core.util.Copyable;

public final class Trap
implements Copyable {
    @Nonnull
    private final ClassType exception;
    @Nonnull
    private final Stmt beginStmt;
    @Nonnull
    private final Stmt endStmt;
    @Nonnull
    private final Stmt handlerStmt;

    public Trap(@Nonnull ClassType exception, @Nonnull Stmt beginStmt, @Nonnull Stmt endStmt, @Nonnull Stmt handlerStmt) {
        this.exception = exception;
        this.beginStmt = beginStmt;
        this.endStmt = endStmt;
        this.handlerStmt = handlerStmt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.exception);
        sb.append(" from: ").append(this.getBeginStmt());
        sb.append(" to: ").append(this.getEndStmt());
        sb.append(" handler: ").append(this.getHandlerStmt());
        return new String(sb);
    }

    @Nonnull
    public Trap withException(@Nonnull ClassType exception) {
        return new Trap(exception, this.getBeginStmt(), this.getEndStmt(), this.getHandlerStmt());
    }

    @Nonnull
    public Trap withBeginStmt(@Nonnull Stmt beginStmt) {
        return new Trap(this.getExceptionType(), beginStmt, this.getEndStmt(), this.getHandlerStmt());
    }

    @Nonnull
    public Trap withHandlerStmt(@Nonnull Stmt handlerStmt) {
        return new Trap(this.getExceptionType(), this.getBeginStmt(), this.getEndStmt(), handlerStmt);
    }

    @Nonnull
    public Trap withEndStmt(@Nonnull Stmt endStmt) {
        return new Trap(this.getExceptionType(), this.getBeginStmt(), endStmt, this.getHandlerStmt());
    }

    @Nonnull
    public Stmt getBeginStmt() {
        return this.beginStmt;
    }

    @Nonnull
    public Stmt getEndStmt() {
        return this.endStmt;
    }

    @Nonnull
    public Stmt getHandlerStmt() {
        return this.handlerStmt;
    }

    @Nonnull
    public ClassType getExceptionType() {
        return this.exception;
    }

    public int hashCode() {
        return Objects.hash(this.getExceptionType(), this.getBeginStmt(), this.getEndStmt(), this.getHandlerStmt());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trap trap = (Trap)o;
        return this.exception.equals(trap.exception) && this.beginStmt.equals(trap.beginStmt) && this.endStmt.equals(trap.endStmt) && this.handlerStmt.equals(trap.handlerStmt);
    }
}

