/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.constant;

import javax.annotation.Nonnull;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.types.Type;

public class ClassConstant
implements Constant {
    private final String value;
    private final Type type;

    public ClassConstant(@Nonnull String str, @Nonnull Type type) {
        if (str.contains(".")) {
            throw new RuntimeException("ClassConstants must use class names separated by '/', not '.'!");
        }
        this.value = str;
        this.type = type;
    }

    public boolean isRefType() {
        return this.value.startsWith("L") && this.value.endsWith(";");
    }

    public boolean equals(Object c) {
        return c instanceof ClassConstant && ((ClassConstant)c).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(@Nonnull ConstantVisitor v) {
        v.caseClassConstant(this);
    }

    public String toString() {
        return "class " + Jimple.escape(this.value);
    }
}

