/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.constant;

import javax.annotation.Nonnull;
import sootup.core.jimple.common.constant.BooleanConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.RealConstant;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;

public class FloatConstant
implements RealConstant<FloatConstant> {
    private final float value;

    private FloatConstant(@Nonnull float value) {
        this.value = value;
    }

    public static FloatConstant getInstance(@Nonnull float value) {
        return new FloatConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof FloatConstant && Float.compare(((FloatConstant)c).value, this.value) == 0;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    @Nonnull
    public FloatConstant add(@Nonnull FloatConstant c) {
        return FloatConstant.getInstance(this.value + c.value);
    }

    @Override
    @Nonnull
    public FloatConstant subtract(@Nonnull FloatConstant c) {
        return FloatConstant.getInstance(this.value - c.value);
    }

    @Override
    @Nonnull
    public FloatConstant multiply(@Nonnull FloatConstant c) {
        return FloatConstant.getInstance(this.value * c.value);
    }

    @Override
    @Nonnull
    public FloatConstant divide(@Nonnull FloatConstant c) {
        return FloatConstant.getInstance(this.value / c.value);
    }

    @Override
    @Nonnull
    public FloatConstant remainder(@Nonnull FloatConstant c) {
        return FloatConstant.getInstance(this.value % c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant equalEqual(@Nonnull FloatConstant c) {
        return BooleanConstant.getInstance(Float.compare(this.value, c.value) == 0);
    }

    @Override
    @Nonnull
    public BooleanConstant notEqual(@Nonnull FloatConstant c) {
        return BooleanConstant.getInstance(Float.compare(this.value, c.value) != 0);
    }

    @Override
    @Nonnull
    public BooleanConstant lessThan(@Nonnull FloatConstant c) {
        return BooleanConstant.getInstance(Float.compare(this.value, c.value) < 0);
    }

    @Override
    @Nonnull
    public BooleanConstant lessThanOrEqual(@Nonnull FloatConstant c) {
        return BooleanConstant.getInstance(Float.compare(this.value, c.value) <= 0);
    }

    @Override
    @Nonnull
    public BooleanConstant greaterThan(@Nonnull FloatConstant c) {
        return BooleanConstant.getInstance(Float.compare(this.value, c.value) > 0);
    }

    @Override
    @Nonnull
    public BooleanConstant greaterThanOrEqual(@Nonnull FloatConstant c) {
        return BooleanConstant.getInstance(Float.compare(this.value, c.value) >= 0);
    }

    @Override
    @Nonnull
    public IntConstant cmpg(@Nonnull FloatConstant constant) {
        float cValue = constant.value;
        if (this.value < cValue) {
            return IntConstant.getInstance(-1);
        }
        if (this.value == cValue) {
            return IntConstant.getInstance(0);
        }
        return IntConstant.getInstance(1);
    }

    @Override
    @Nonnull
    public IntConstant cmpl(@Nonnull FloatConstant constant) {
        float cValue = constant.value;
        if (this.value > cValue) {
            return IntConstant.getInstance(1);
        }
        if (this.value == cValue) {
            return IntConstant.getInstance(0);
        }
        return IntConstant.getInstance(-1);
    }

    @Override
    @Nonnull
    public FloatConstant negate() {
        return FloatConstant.getInstance(-this.value);
    }

    public String toString() {
        String floatString = Float.toString(this.value);
        if (floatString.equals("NaN") || floatString.equals("Infinity") || floatString.equals("-Infinity")) {
            return "#" + floatString + "F";
        }
        return floatString + "F";
    }

    @Override
    @Nonnull
    public Type getType() {
        return PrimitiveType.getFloat();
    }

    @Override
    public void accept(@Nonnull ConstantVisitor v) {
        v.caseFloatConstant(this);
    }

    public float getValue() {
        return this.value;
    }
}

