/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.constant;

import javax.annotation.Nonnull;
import sootup.core.jimple.common.constant.BooleanConstant;
import sootup.core.jimple.common.constant.ShiftableConstant;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;

public class IntConstant
implements ShiftableConstant<IntConstant> {
    private final int value;

    protected IntConstant(@Nonnull int value) {
        this.value = value;
    }

    public static IntConstant getInstance(@Nonnull int value) {
        return new IntConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof IntConstant && ((IntConstant)c).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    @Nonnull
    public IntConstant add(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value + c.value);
    }

    @Override
    @Nonnull
    public IntConstant subtract(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value - c.value);
    }

    @Override
    @Nonnull
    public IntConstant multiply(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value * c.value);
    }

    @Override
    @Nonnull
    public IntConstant divide(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value / c.value);
    }

    @Override
    @Nonnull
    public IntConstant remainder(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value % c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant equalEqual(@Nonnull IntConstant c) {
        return BooleanConstant.getInstance(this.value == c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant notEqual(@Nonnull IntConstant c) {
        return BooleanConstant.getInstance(this.value != c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant lessThan(@Nonnull IntConstant c) {
        return BooleanConstant.getInstance(this.value < c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant lessThanOrEqual(@Nonnull IntConstant c) {
        return BooleanConstant.getInstance(this.value <= c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant greaterThan(@Nonnull IntConstant c) {
        return BooleanConstant.getInstance(this.value > c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant greaterThanOrEqual(@Nonnull IntConstant c) {
        return BooleanConstant.getInstance(this.value >= c.value);
    }

    @Override
    @Nonnull
    public IntConstant negate() {
        return IntConstant.getInstance(-this.value);
    }

    @Override
    @Nonnull
    public IntConstant and(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value & c.value);
    }

    @Override
    @Nonnull
    public IntConstant or(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value | c.value);
    }

    @Override
    @Nonnull
    public IntConstant xor(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value ^ c.value);
    }

    @Override
    @Nonnull
    public IntConstant shiftLeft(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value << c.value);
    }

    @Override
    @Nonnull
    public IntConstant shiftRight(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value >> c.value);
    }

    @Override
    @Nonnull
    public IntConstant unsignedShiftRight(@Nonnull IntConstant c) {
        return IntConstant.getInstance(this.value >>> c.value);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    @Nonnull
    public Type getType() {
        return PrimitiveType.getInt();
    }

    @Override
    public void accept(@Nonnull ConstantVisitor v) {
        v.caseIntConstant(this);
    }

    public int getValue() {
        return this.value;
    }
}

