/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.constant;

import javax.annotation.Nonnull;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.Type;

public class MethodHandle
implements Constant {
    private final Type type;
    private final MethodSignature methodSignature;
    private final JFieldRef fieldRef;
    public int tag;

    public MethodHandle(MethodSignature methodSignature, int tag, Type type) {
        this.methodSignature = methodSignature;
        this.tag = tag;
        this.fieldRef = null;
        this.type = type;
    }

    public MethodHandle(JFieldRef ref, int tag, Type type) {
        this.fieldRef = ref;
        this.tag = tag;
        this.methodSignature = null;
        this.type = type;
    }

    public static boolean isMethodRef(int kind) {
        return kind == Kind.REF_INVOKE_VIRTUAL.getValue() || kind == Kind.REF_INVOKE_STATIC.getValue() || kind == Kind.REF_INVOKE_SPECIAL.getValue() || kind == Kind.REF_INVOKE_CONSTRUCTOR.getValue() || kind == Kind.REF_INVOKE_INTERFACE.getValue();
    }

    public String toString() {
        return "handle: " + this.methodSignature;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    @Override
    public void accept(@Nonnull ConstantVisitor v) {
        v.caseMethodHandle(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodSignature == null ? 0 : this.methodSignature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodHandle other = (MethodHandle)obj;
        if (this.methodSignature == null) {
            return other.methodSignature == null;
        }
        return this.methodSignature.equals(other.methodSignature);
    }

    public static enum Kind {
        REF_GET_FIELD(1, "REF_GET_FIELD"),
        REF_GET_FIELD_STATIC(2, "REF_GET_FIELD_STATIC"),
        REF_PUT_FIELD(3, "REF_PUT_FIELD"),
        REF_PUT_FIELD_STATIC(4, "REF_PUT_FIELD_STATIC"),
        REF_INVOKE_VIRTUAL(5, "REF_INVOKE_VIRTUAL"),
        REF_INVOKE_STATIC(6, "REF_INVOKE_STATIC"),
        REF_INVOKE_SPECIAL(7, "REF_INVOKE_SPECIAL"),
        REF_INVOKE_CONSTRUCTOR(8, "REF_INVOKE_CONSTRUCTOR"),
        REF_INVOKE_INTERFACE(9, "REF_INVOKE_INTERFACE");

        private final int val;
        private final String valStr;

        private Kind(int val, String valStr) {
            this.val = val;
            this.valStr = valStr;
        }

        public String toString() {
            return this.valStr;
        }

        public int getValue() {
            return this.val;
        }

        public static Kind getKind(int kind) {
            for (Kind k : Kind.values()) {
                if (k.getValue() != kind) continue;
                return k;
            }
            throw new RuntimeException("Error: No method handle kind for value '" + kind + "'.");
        }

        public static Kind getKind(String kind) {
            for (Kind k : Kind.values()) {
                if (!k.toString().equals(kind)) continue;
                return k;
            }
            throw new RuntimeException("Error: No method handle kind for value '" + kind + "'.");
        }
    }
}

