/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.visitor.ExprVisitor;
import sootup.core.types.Type;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JCastExpr
implements Expr,
Copyable {
    private final Immediate op;
    private final Type type;

    public JCastExpr(@Nonnull Immediate op, @Nonnull Type type) {
        this.op = op;
        this.type = type;
    }

    @Override
    public boolean equivTo(@Nonnull Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseCastExpr(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.op.equivHashCode() * 101 + this.type.hashCode() + 17;
    }

    public String toString() {
        return "(" + this.type.toString() + ") " + this.op.toString();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        up.literal("(");
        up.typeSignature(this.type);
        up.literal(") ");
        this.op.toString(up);
    }

    public Immediate getOp() {
        return this.op;
    }

    @Override
    @Nonnull
    public final List<Value> getUses() {
        ArrayList<Value> list = new ArrayList<Value>(this.op.getUses());
        list.add(this.op);
        return list;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(@Nonnull ExprVisitor v) {
        v.caseCastExpr(this);
    }

    @Nonnull
    public JCastExpr withOp(@Nonnull Immediate op) {
        return new JCastExpr(op, this.type);
    }

    @Nonnull
    public JCastExpr withType(@Nonnull Type type) {
        return new JCastExpr(this.getOp(), type);
    }
}

