/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.visitor.ExprVisitor;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.util.Copyable;
import sootup.core.util.ImmutableUtils;
import sootup.core.util.printer.StmtPrinter;

public final class JDynamicInvokeExpr
extends AbstractInvokeExpr
implements Copyable {
    @Nonnull
    public static final String INVOKEDYNAMIC_DUMMY_CLASS_NAME = "sootup.dummy.InvokeDynamic";
    @Nonnull
    private final MethodSignature bootstrapMethodSignature;
    private final List<Immediate> bootstrapMethodSignatureArgs;
    private final int tag;

    public JDynamicInvokeExpr(@Nonnull MethodSignature bootstrapMethodSignature, @Nonnull List<Immediate> bootstrapArgs, @Nonnull MethodSignature methodSignature, int tag, @Nonnull List<Immediate> methodArgs) {
        super(methodSignature, methodArgs.toArray(new Immediate[0]));
        if (!methodSignature.getDeclClassType().getFullyQualifiedName().equals(INVOKEDYNAMIC_DUMMY_CLASS_NAME)) {
            throw new IllegalArgumentException("Receiver type of JDynamicInvokeExpr must be sootup.dummy.InvokeDynamic!");
        }
        this.bootstrapMethodSignature = bootstrapMethodSignature;
        this.bootstrapMethodSignatureArgs = ImmutableUtils.immutableListOf(bootstrapArgs);
        this.tag = tag;
    }

    public JDynamicInvokeExpr(@Nonnull MethodSignature bootstrapMethodSignature, @Nonnull List<Immediate> bootstrapArgs, @Nonnull MethodSignature methodSignature, @Nonnull List<Immediate> methodArgs) {
        this(bootstrapMethodSignature, bootstrapArgs, methodSignature, 6, methodArgs);
    }

    @Nonnull
    public MethodSignature getBootstrapMethodSignature() {
        return this.bootstrapMethodSignature;
    }

    public int getBootstrapArgCount() {
        return this.bootstrapMethodSignatureArgs.size();
    }

    @Nonnull
    public Value getBootstrapArg(int index) {
        return this.bootstrapMethodSignatureArgs.get(index);
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseDynamicInvokeExpr(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.bootstrapMethodSignature.hashCode() * this.getMethodSignature().hashCode() * 17;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("dynamicinvoke");
        builder.append(" \"");
        builder.append(this.getMethodSignature().getName());
        builder.append("\" <");
        builder.append(this.getNamelessSubSig((MethodSubSignature)this.getMethodSignature().getSubSignature()));
        builder.append(">(");
        this.argsToString(builder);
        builder.append(") ");
        builder.append(this.getBootstrapMethodSignature());
        builder.append("(");
        int len = this.bootstrapMethodSignatureArgs.size();
        if (0 < len) {
            builder.append(this.bootstrapMethodSignatureArgs.get(0).toString());
            for (int i = 1; i < len; ++i) {
                builder.append(", ");
                builder.append(this.bootstrapMethodSignatureArgs.get(i).toString());
            }
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        up.literal("dynamicinvoke");
        MethodSignature methodSignature = this.getMethodSignature();
        MethodSubSignature mSubSig = (MethodSubSignature)methodSignature.getSubSignature();
        up.literal(" " + Jimple.escape(mSubSig.getName()) + " <" + this.getNamelessSubSig(mSubSig) + ">(");
        this.argsToPrinter(up);
        up.literal(") ");
        up.methodSignature(this.bootstrapMethodSignature);
        up.literal("(");
        int len = this.bootstrapMethodSignatureArgs.size();
        if (0 < len) {
            this.bootstrapMethodSignatureArgs.get(0).toString(up);
            for (int i = 1; i < len; ++i) {
                up.literal(", ");
                this.bootstrapMethodSignatureArgs.get(i).toString(up);
            }
        }
        up.literal(")");
    }

    @Nonnull
    private String getNamelessSubSig(MethodSubSignature mSubSig) {
        return mSubSig.getType() + " (" + mSubSig.getParameterTypes().stream().map(Object::toString).collect(Collectors.joining(",")) + ")";
    }

    @Override
    public void accept(@Nonnull ExprVisitor v) {
        v.caseDynamicInvokeExpr(this);
    }

    @Nonnull
    public List<Immediate> getBootstrapArgs() {
        return this.bootstrapMethodSignatureArgs;
    }

    public int getHandleTag() {
        return this.tag;
    }

    @Nonnull
    public JDynamicInvokeExpr withBootstrapMethodSignature(@Nonnull MethodSignature bootstrapMethodSignature) {
        return new JDynamicInvokeExpr(bootstrapMethodSignature, this.getBootstrapArgs(), this.getMethodSignature(), this.getArgs());
    }

    @Nonnull
    public JDynamicInvokeExpr withBootstrapArgs(@Nonnull List<Immediate> bootstrapArgs) {
        return new JDynamicInvokeExpr(this.bootstrapMethodSignature, bootstrapArgs, this.getMethodSignature(), this.getArgs());
    }

    @Nonnull
    public JDynamicInvokeExpr withMethodSignature(@Nonnull MethodSignature methodSignature) {
        return new JDynamicInvokeExpr(this.bootstrapMethodSignature, this.getBootstrapArgs(), this.getMethodSignature(), this.getArgs());
    }

    @Nonnull
    public JDynamicInvokeExpr withMethodArgs(@Nonnull List<Immediate> methodArgs) {
        return new JDynamicInvokeExpr(this.bootstrapMethodSignature, this.getBootstrapArgs(), this.getMethodSignature(), methodArgs);
    }
}

